/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.h2.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.h2.builder.CreateTableSqlBuilder;
import org.dromara.autotable.strategy.h2.data.H2CompareTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyTableSqlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifyTableSqlBuilder.class);

    public static List<String> buildSql(H2CompareTableInfo compareTableInfo) {
        String tableName = compareTableInfo.getName();
        String schema = compareTableInfo.getSchema();
        String tableComment = compareTableInfo.getComment();
        Map<String, String> columnComment = compareTableInfo.getColumnComment();
        Map<String, String> indexComment = compareTableInfo.getIndexComment();
        ArrayList<String> alterTableSqlList = new ArrayList<String>();
        List<String> dropColumnList = compareTableInfo.getDropColumnList();
        dropColumnList.stream().map(columnName -> "ALTER TABLE {tableName} DROP COLUMN " + IStrategy.wrapIdentifiers((String)columnName)).forEach(alterTableSqlList::add);
        List<ColumnMetadata> newColumnList = compareTableInfo.getNewColumnMetadataList();
        newColumnList.stream().map(column -> "ALTER TABLE {tableName} ADD COLUMN " + CreateTableSqlBuilder.buildColumnSql(column)).forEach(alterTableSqlList::add);
        List<ColumnMetadata> modifyColumnList = compareTableInfo.getModifyColumnMetadataList();
        modifyColumnList.stream().map(column -> "ALTER TABLE {tableName} ALTER COLUMN " + CreateTableSqlBuilder.buildColumnSql(column)).forEach(alterTableSqlList::add);
        List<ColumnMetadata> newPrimaries = compareTableInfo.getNewPrimaries();
        if (!newPrimaries.isEmpty()) {
            alterTableSqlList.add("ALTER TABLE {tableName} DROP PRIMARY KEY");
            String primaryColumns = newPrimaries.stream().map(ColumnMetadata::getName).map(IStrategy::wrapIdentifiers).collect(Collectors.joining(", "));
            alterTableSqlList.add("ALTER TABLE {tableName} ADD PRIMARY KEY (" + primaryColumns + ")");
        }
        List<String> allCommentSql = CreateTableSqlBuilder.getAllCommentSql(schema, tableName, tableComment, columnComment, indexComment);
        List<String> dropIndexList = compareTableInfo.getDropIndexList();
        List dropIndexSql = dropIndexList.stream().map(indexName -> "DROP INDEX " + IStrategy.concatWrapIdentifiers((String[])new String[]{schema, indexName}) + ";").collect(Collectors.toList());
        List<String> createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, compareTableInfo.getIndexMetadataList());
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.addAll(alterTableSqlList);
        sqlList.addAll(dropIndexSql);
        sqlList.addAll(createIndexSql);
        sqlList.addAll(allCommentSql);
        return sqlList.stream().filter(StringUtils::hasText).map(sql -> {
            if (!(sql = sql.replace("{tableName}", IStrategy.concatWrapIdentifiers((String[])new String[]{schema, tableName}))).endsWith(";")) {
                sql = sql + ";";
            }
            return sql;
        }).collect(Collectors.toList());
    }
}

