/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.data;

import lombok.Generated;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;

public enum DmDefaultTypeEnum implements DefaultTypeEnumInterface
{
    SERIAL("SERIAL", null, null),
    INTEGER("INTEGER", null, null),
    BIGINT("BIGINT", null, null),
    TINYINT("TINYINT", null, null),
    SMALLINT("SMALLINT", null, null),
    DECIMAL("DECIMAL", 10, 2),
    FLOAT("FLOAT", 20, null),
    DOUBLE("DOUBLE", 20, null),
    NUMBER("NUMBER", null, null),
    CHAR("CHAR", 1, null),
    VARCHAR("VARCHAR", 50, null),
    VARCHAR2("VARCHAR2", 255, null),
    CLOB("CLOB", null, null),
    TEXT("TEXT", null, null),
    DATE("DATE", null, null),
    TIME("TIME", null, null),
    DATETIME("DATETIME", null, null),
    TIMESTAMP("TIMESTAMP", null, null),
    BLOB("BLOB", null, null),
    BINARY("BINARY", 1024, null),
    VARBINARY("VARBINARY", 1024, null),
    IMAGE("IMAGE", null, null),
    BIT("BIT", null, null),
    XML("XML", null, null),
    FILE("FILE", null, null),
    ARRAY("ARRAY", null, null),
    OBJECT("OBJECT", null, null);

    private final String typeName;
    private final Integer defaultLength;
    private final Integer defaultDecimalLength;

    private DmDefaultTypeEnum(String typeName, Integer defaultLength, Integer defaultDecimalLength) {
        this.typeName = typeName;
        this.defaultLength = defaultLength;
        this.defaultDecimalLength = defaultDecimalLength;
    }

    public static String convertNumberType(int precision, int scale) {
        if (scale == 0) {
            if (precision <= 4) {
                return "SMALLINT";
            }
            if (precision <= 9) {
                return "INTEGER";
            }
            if (precision <= 18) {
                return "BIGINT";
            }
        }
        return String.format("%s(%d,%d)", "NUMBER", Math.min(precision, 38), Math.min(scale, 38));
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public Integer getDefaultLength() {
        return this.defaultLength;
    }

    @Generated
    public Integer getDefaultDecimalLength() {
        return this.defaultDecimalLength;
    }
}

