/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringUtils;

public class DmCompareTableInfo
extends CompareTableInfo {
    private String comment;
    private List<ColumnMetadata> newPrimaries = new ArrayList<ColumnMetadata>();
    private String dropPrimaryKeyName;
    private Map<String, String> columnComment = new HashMap<String, String>();
    private Map<String, String> indexComment = new HashMap<String, String>();
    private List<String> dropColumnList = new ArrayList<String>();
    private List<ColumnMetadata> modifyColumnMetadataList = new ArrayList<ColumnMetadata>();
    private List<ColumnMetadata> newColumnMetadataList = new ArrayList<ColumnMetadata>();
    private List<String> dropIndexList = new ArrayList<String>();
    private List<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>();
    private List<String> recreateSequences = new ArrayList<String>();
    private Map<String, String> storageParams = new HashMap<String, String>();

    public DmCompareTableInfo(@NonNull String name, @NonNull String schema) {
        super(name, schema);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
    }

    public boolean needModify() {
        return StringUtils.hasText((String)this.comment) || StringUtils.hasText((String)this.dropPrimaryKeyName) || !this.newPrimaries.isEmpty() || !this.columnComment.isEmpty() || !this.indexComment.isEmpty() || !this.dropColumnList.isEmpty() || !this.modifyColumnMetadataList.isEmpty() || !this.newColumnMetadataList.isEmpty() || !this.dropIndexList.isEmpty() || !this.indexMetadataList.isEmpty() || !this.recreateSequences.isEmpty() || !this.storageParams.isEmpty();
    }

    public String validateFailedMessage() {
        StringBuilder dmMsg = new StringBuilder();
        if (StringUtils.hasText((String)this.comment)) {
            dmMsg.append("\u8868\u6ce8\u91ca\u53d8\u66f4: ").append(this.comment).append("\n");
        }
        if (StringUtils.hasText((String)this.dropPrimaryKeyName)) {
            dmMsg.append("\u5220\u9664\u4e3b\u952e: ").append(this.dropPrimaryKeyName).append("\n");
        }
        if (!this.newPrimaries.isEmpty()) {
            dmMsg.append("\u65b0\u589e\u4e3b\u952e: ").append(this.newPrimaries).append("\n");
        }
        if (!this.columnComment.isEmpty()) {
            dmMsg.append("\u5217\u6ce8\u91ca\u53d8\u66f4: ").append(this.columnComment.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(", "))).append("\n");
        }
        if (!this.indexComment.isEmpty()) {
            dmMsg.append("\u7d22\u5f15\u6ce8\u91ca\u53d8\u66f4: ").append(this.indexComment.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(", "))).append("\n");
        }
        if (!this.dropColumnList.isEmpty()) {
            dmMsg.append("\u5220\u9664\u5217: ").append(String.join((CharSequence)",", this.dropColumnList)).append("\n");
        }
        if (!this.modifyColumnMetadataList.isEmpty()) {
            dmMsg.append("\u4fee\u6539\u5217: ").append(this.modifyColumnMetadataList.stream().map(ColumnMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        if (!this.newColumnMetadataList.isEmpty()) {
            dmMsg.append("\u65b0\u589e\u5217: ").append(this.newColumnMetadataList.stream().map(ColumnMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        if (!this.dropIndexList.isEmpty()) {
            dmMsg.append("\u5220\u9664\u7d22\u5f15: ").append(String.join((CharSequence)",", this.dropIndexList)).append("\n");
        }
        if (!this.indexMetadataList.isEmpty()) {
            dmMsg.append("\u65b0\u589e\u7d22\u5f15: ").append(this.indexMetadataList.stream().map(IndexMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        if (!this.recreateSequences.isEmpty()) {
            dmMsg.append("\u9700\u8981\u91cd\u5efa\u5e8f\u5217: ").append(String.join((CharSequence)",", this.recreateSequences)).append("\n");
        }
        if (!this.storageParams.isEmpty()) {
            dmMsg.append("\u5b58\u50a8\u53c2\u6570\u4fee\u6539: ").append(this.storageParams).append("\n");
        }
        return dmMsg + dmMsg.toString();
    }

    public void addColumnComment(String columnName, String newComment) {
        this.columnComment.put(columnName, newComment);
    }

    public void addNewColumn(ColumnMetadata columnMetadata) {
        this.newColumnMetadataList.add(columnMetadata);
    }

    public void addModifyColumn(ColumnMetadata columnMetadata) {
        this.modifyColumnMetadataList.add(columnMetadata);
    }

    public void addDropColumns(Set<String> dropColumnList) {
        this.dropColumnList.addAll(dropColumnList);
    }

    public void addNewIndex(IndexMetadata indexMetadata) {
        this.indexMetadataList.add(indexMetadata);
    }

    public void addModifyIndex(IndexMetadata indexMetadata) {
        this.dropIndexList.add(indexMetadata.getName());
        this.indexMetadataList.add(indexMetadata);
    }

    public void addIndexComment(@NonNull String indexName, @NonNull String newComment) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (newComment == null) {
            throw new NullPointerException("newComment is marked non-null but is null");
        }
        this.indexComment.put(indexName, newComment);
    }

    public void addDropIndexes(Set<String> indexNameList) {
        this.dropIndexList.addAll(indexNameList);
    }

    public void addNewPrimary(List<ColumnMetadata> columnMetadata) {
        this.newPrimaries.addAll(columnMetadata);
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public List<ColumnMetadata> getNewPrimaries() {
        return this.newPrimaries;
    }

    @Generated
    public String getDropPrimaryKeyName() {
        return this.dropPrimaryKeyName;
    }

    @Generated
    public Map<String, String> getColumnComment() {
        return this.columnComment;
    }

    @Generated
    public Map<String, String> getIndexComment() {
        return this.indexComment;
    }

    @Generated
    public List<String> getDropColumnList() {
        return this.dropColumnList;
    }

    @Generated
    public List<ColumnMetadata> getModifyColumnMetadataList() {
        return this.modifyColumnMetadataList;
    }

    @Generated
    public List<ColumnMetadata> getNewColumnMetadataList() {
        return this.newColumnMetadataList;
    }

    @Generated
    public List<String> getDropIndexList() {
        return this.dropIndexList;
    }

    @Generated
    public List<IndexMetadata> getIndexMetadataList() {
        return this.indexMetadataList;
    }

    @Generated
    public List<String> getRecreateSequences() {
        return this.recreateSequences;
    }

    @Generated
    public Map<String, String> getStorageParams() {
        return this.storageParams;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setNewPrimaries(List<ColumnMetadata> newPrimaries) {
        this.newPrimaries = newPrimaries;
    }

    @Generated
    public void setDropPrimaryKeyName(String dropPrimaryKeyName) {
        this.dropPrimaryKeyName = dropPrimaryKeyName;
    }

    @Generated
    public void setColumnComment(Map<String, String> columnComment) {
        this.columnComment = columnComment;
    }

    @Generated
    public void setIndexComment(Map<String, String> indexComment) {
        this.indexComment = indexComment;
    }

    @Generated
    public void setDropColumnList(List<String> dropColumnList) {
        this.dropColumnList = dropColumnList;
    }

    @Generated
    public void setModifyColumnMetadataList(List<ColumnMetadata> modifyColumnMetadataList) {
        this.modifyColumnMetadataList = modifyColumnMetadataList;
    }

    @Generated
    public void setNewColumnMetadataList(List<ColumnMetadata> newColumnMetadataList) {
        this.newColumnMetadataList = newColumnMetadataList;
    }

    @Generated
    public void setDropIndexList(List<String> dropIndexList) {
        this.dropIndexList = dropIndexList;
    }

    @Generated
    public void setIndexMetadataList(List<IndexMetadata> indexMetadataList) {
        this.indexMetadataList = indexMetadataList;
    }

    @Generated
    public void setRecreateSequences(List<String> recreateSequences) {
        this.recreateSequences = recreateSequences;
    }

    @Generated
    public void setStorageParams(Map<String, String> storageParams) {
        this.storageParams = storageParams;
    }
}

