/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.builder;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.dromara.autotable.core.builder.ColumnMetadataBuilder;
import org.dromara.autotable.core.builder.DefaultTableMetadataBuilder;
import org.dromara.autotable.core.builder.IndexMetadataBuilder;
import org.dromara.autotable.core.dynamicds.DataSourceManager;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.dm.builder.DmColumnMetadataBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmTableMetadataBuilder
extends DefaultTableMetadataBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmTableMetadataBuilder.class);

    public DmTableMetadataBuilder() {
        super((ColumnMetadataBuilder)new DmColumnMetadataBuilder(), new IndexMetadataBuilder());
    }

    protected String getTableSchema(Class<?> clazz) {
        String tableSchema = super.getTableSchema(clazz);
        if (StringUtils.hasText((String)tableSchema)) {
            return tableSchema;
        }
        return (String)DataSourceManager.useConnection(connection -> {
            try {
                String url = connection.getClientInfo("url");
                String schema = this.parseSchemaFromUrl(url);
                if (StringUtils.hasText((String)schema)) {
                    return schema;
                }
                return connection.getSchema();
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u6570\u636e\u5e93\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                return "public";
            }
        });
    }

    private String parseSchemaFromUrl(String url) {
        try {
            String[] urlParts = url.split("\\?");
            if (urlParts.length < 2) {
                return null;
            }
            Map<String, String> params = Arrays.stream(urlParts[1].split("&")).map(param -> param.split("=")).filter(pair -> ((String[])pair).length == 2).collect(Collectors.toMap(pair -> pair[0].toLowerCase(), pair -> pair[1], (oldVal, newVal) -> newVal));
            return params.getOrDefault("schema", params.getOrDefault("currentSchema", null));
        }
        catch (Exception e) {
            log.warn("\u89e3\u6790JDBC URL\u53c2\u6570\u5931\u8d25: {}", (Object)url, (Object)e);
            return null;
        }
    }
}

