/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.dm.builder.ColumnSqlBuilder;
import org.dromara.autotable.strategy.dm.builder.DmCreateTableSqlBuilder;
import org.dromara.autotable.strategy.dm.data.DmCompareTableInfo;

public class DmModifyTableSqlBuilder {
    public static List<String> buildSql(DmCompareTableInfo compareInfo) {
        List<String> commentStatements;
        List<String> indexStatements;
        ArrayList<String> sqlList = new ArrayList<String>();
        String qualifiedTableName = IStrategy.concatWrapIdentifiers((String[])new String[]{compareInfo.getSchema(), compareInfo.getName()});
        compareInfo.getDropIndexList().forEach(index -> sqlList.add("DROP INDEX " + IStrategy.concatWrapIdentifiers((String[])new String[]{compareInfo.getSchema(), index}) + ";"));
        compareInfo.getModifyColumnMetadataList().forEach(column -> {
            String columnDef = ColumnSqlBuilder.buildSql(column).replaceFirst("\"\\w+\"", IStrategy.wrapIdentifiers((String)column.getName()));
            if (StringUtils.hasText((String)columnDef)) {
                sqlList.add("ALTER TABLE " + qualifiedTableName + " MODIFY " + columnDef + ";");
            }
        });
        if (StringUtils.hasText((String)compareInfo.getDropPrimaryKeyName())) {
            sqlList.add("ALTER TABLE " + qualifiedTableName + " DROP CONSTRAINT " + IStrategy.wrapIdentifiers((String)compareInfo.getDropPrimaryKeyName()) + ";");
        }
        compareInfo.getDropColumnList().forEach(column -> sqlList.add("ALTER TABLE " + qualifiedTableName + " DROP COLUMN " + IStrategy.wrapIdentifiers((String)column) + ";"));
        compareInfo.getNewColumnMetadataList().forEach(column -> sqlList.add("ALTER TABLE " + qualifiedTableName + " ADD " + ColumnSqlBuilder.buildSql(column) + ";"));
        if (!compareInfo.getNewPrimaries().isEmpty()) {
            String pkColumns = compareInfo.getNewPrimaries().stream().map(ColumnMetadata::getName).map(IStrategy::wrapIdentifiers).collect(Collectors.joining(", "));
            String pkStatement = "ADD PRIMARY KEY (" + pkColumns + ")";
            sqlList.add("ALTER TABLE " + qualifiedTableName + " " + pkStatement + ";");
        }
        if (!(indexStatements = DmCreateTableSqlBuilder.buildIndexStatements(compareInfo.getSchema(), compareInfo.getName(), compareInfo.getIndexMetadataList())).isEmpty()) {
            sqlList.addAll(indexStatements);
        }
        if (!(commentStatements = DmModifyTableSqlBuilder.buildCommentStatements(compareInfo)).isEmpty()) {
            sqlList.addAll(commentStatements);
        }
        return sqlList.stream().filter(StringUtils::hasText).collect(Collectors.toList());
    }

    private static List<String> buildCommentStatements(DmCompareTableInfo compareInfo) {
        ArrayList<String> comments = new ArrayList<String>();
        String qualifiedTableName = IStrategy.concatWrapIdentifiers((String[])new String[]{compareInfo.getSchema(), compareInfo.getName()});
        if (StringUtils.hasText((String)compareInfo.getComment())) {
            comments.add("COMMENT ON TABLE " + qualifiedTableName + " IS '" + compareInfo.getComment().replace("'", "''") + "';");
        }
        compareInfo.getColumnComment().forEach((col, comment) -> comments.add("COMMENT ON COLUMN " + qualifiedTableName + "." + IStrategy.wrapIdentifiers((String)col) + " IS '" + comment.replace("'", "''") + "';"));
        return comments;
    }
}

