/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.strategy.dm.builder;

import java.util.Arrays;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.strategy.dm.data.DmDefaultTypeEnum;

public class ColumnSqlBuilder {
    public static String buildSql(ColumnMetadata columnMetadata) {
        StringConnectHelper sql = StringConnectHelper.newInstance((String)"{columnName} {type} {null} {default} {autoIncrement}").replace("{columnName}", IStrategy.wrapIdentifiers((String)columnMetadata.getName())).replace("{type}", ColumnSqlBuilder.buildTypeDefinition(columnMetadata.getType())).replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "").replace("{default}", ColumnSqlBuilder.buildDefaultValue(columnMetadata)).replace("{autoIncrement}", ColumnSqlBuilder.buildAutoIncrement(columnMetadata));
        return sql.toString().replaceAll("\\s+", " ").trim();
    }

    private static String buildTypeDefinition(DatabaseTypeAndLength type) {
        String typeName = type.getType().toUpperCase();
        Integer length = type.getLength();
        Integer decimal = type.getDecimalLength();
        DmDefaultTypeEnum typeEnum = Arrays.stream(DmDefaultTypeEnum.values()).filter(e -> e.getTypeName().equalsIgnoreCase(typeName)).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid type: " + typeName));
        if ("NUMBER".equals(typeName)) {
            return ColumnSqlBuilder.handleNumberType(typeEnum, length, decimal);
        }
        if ("VARCHAR2".equals(typeName)) {
            int actualLength = length != null ? Math.min(length, 8188) : 50;
            return String.format("VARCHAR2(%d)", actualLength);
        }
        if ("CHAR".equals(typeName)) {
            return length != null && length > 1 ? "CHAR(" + length + ")" : "CHAR";
        }
        if ("INTEGER".equals(typeName)) {
            return "INTEGER";
        }
        return ColumnSqlBuilder.buildDefaultType(type, typeEnum, length, decimal);
    }

    private static String handleNumberType(DmDefaultTypeEnum typeEnum, Integer length, Integer decimal) {
        int precision = length != null ? length : typeEnum.getDefaultLength();
        int scale = decimal != null ? decimal : typeEnum.getDefaultDecimalLength();
        return DmDefaultTypeEnum.convertNumberType(precision, scale);
    }

    private static String buildDefaultType(DatabaseTypeAndLength type, DmDefaultTypeEnum typeEnum, Integer length, Integer decimal) {
        if (typeEnum == DmDefaultTypeEnum.FLOAT || typeEnum == DmDefaultTypeEnum.DOUBLE) {
            int actualLength = length != null ? length : typeEnum.getDefaultLength();
            return String.format("%s(%d)", typeEnum.getTypeName(), actualLength);
        }
        if (typeEnum == DmDefaultTypeEnum.DECIMAL) {
            int actualLength = length != null ? length : typeEnum.getDefaultLength();
            int actualDecimal = decimal != null ? decimal : typeEnum.getDefaultDecimalLength();
            return String.format("%s(%d,%d)", typeEnum.getTypeName(), actualLength, actualDecimal);
        }
        return type.getDefaultFullType();
    }

    private static String buildDefaultValue(ColumnMetadata columnMetadata) {
        if (columnMetadata.isAutoIncrement()) {
            return "";
        }
        DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
        String defaultValue = columnMetadata.getDefaultValue();
        String typeName = columnMetadata.getType().getType().toUpperCase();
        boolean isNumberType = ColumnSqlBuilder.isNumberType(typeName);
        boolean isBooleanType = "TINYINT".equals(typeName);
        if (defaultValueType == DefaultValueEnum.NULL) {
            return "DEFAULT NULL";
        }
        if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
            return isNumberType ? "" : "DEFAULT ''";
        }
        if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText((String)defaultValue)) {
            if (ColumnSqlBuilder.isFunctionDefault(defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            if (isBooleanType) {
                return "DEFAULT " + ColumnSqlBuilder.convertBooleanValue(defaultValue);
            }
            if (isNumberType) {
                return "DEFAULT " + defaultValue;
            }
            return "DEFAULT '" + defaultValue.replace("'", "''") + "'";
        }
        return "";
    }

    private static boolean isNumberType(String typeName) {
        return typeName.matches("BIGINT|INT|INTEGER|SMALLINT|TINYINT|NUMBER|DECIMAL|FLOAT|DOUBLE");
    }

    private static String convertBooleanValue(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return "1";
        }
        if ("false".equalsIgnoreCase(value)) {
            return "0";
        }
        return value;
    }

    private static String buildAutoIncrement(ColumnMetadata columnMetadata) {
        if (!columnMetadata.isAutoIncrement()) {
            return "";
        }
        return "SERIAL".equalsIgnoreCase(columnMetadata.getType().getType()) ? "" : "IDENTITY(1,1)";
    }

    public static String wrapColumnName(String columnName) {
        return IStrategy.wrapIdentifiers((String)columnName);
    }

    private static boolean isFunctionDefault(String value) {
        return value.toUpperCase().matches("^(SYSDATE|CURRENT_TIMESTAMP|NEXTVAL\\()");
    }
}

