/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.util.Collection;
import java.util.IllegalFormatException;
import javapns.notification.Payload;
import javapns.notification.exceptions.PayloadAlertAlreadyExistsException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushNotificationPayload
extends Payload {
    private static final Logger logger = LoggerFactory.getLogger(PushNotificationPayload.class);
    private static final int MAXIMUM_PAYLOAD_LENGTH = 4000;
    public static final String ALERT = "alert";
    private JSONObject apsDictionary;

    protected PushNotificationPayload() {
        this.apsDictionary = new JSONObject();
        try {
            JSONObject payload = this.getPayload();
            if (!payload.has("aps")) {
                payload.put("aps", (Object)this.apsDictionary);
            }
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected PushNotificationPayload(String rawJSON) {
        super(rawJSON);
        try {
            JSONObject payload = this.getPayload();
            this.apsDictionary = payload.getJSONObject("aps");
            if (this.apsDictionary == null) {
                this.apsDictionary = new JSONObject();
                payload.put("aps", (Object)this.apsDictionary);
            }
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public PushNotificationPayload(String alert, int badge, String sound) {
        this();
        if (alert != null) {
            this.addAlert(alert);
        }
        this.addBadge(badge);
        if (sound != null) {
            this.addSound(sound);
        }
    }

    public static PushNotificationPayload alert(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Alert cannot be null");
        }
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            payload.addAlert(message);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return payload;
    }

    public static PushNotificationPayload badge(int badge) {
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            payload.addBadge(badge);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return payload;
    }

    public static PushNotificationPayload sound(String sound) {
        if (sound == null) {
            throw new IllegalArgumentException("Sound name cannot be null");
        }
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            payload.addSound(sound);
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return payload;
    }

    public static PushNotificationPayload combined(String message, int badge, String sound) {
        if (message == null && badge < 0 && sound == null) {
            throw new IllegalArgumentException("Must provide at least one non-null argument");
        }
        PushNotificationPayload payload = PushNotificationPayload.complex();
        try {
            if (message != null) {
                payload.addAlert(message);
            }
            if (badge >= 0) {
                payload.addBadge(badge);
            }
            if (sound != null) {
                payload.addSound(sound);
            }
        }
        catch (JSONException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return payload;
    }

    public static PushNotificationPayload test() {
        PushNotificationPayload payload = PushNotificationPayload.complex();
        payload.setPreSendConfiguration(1);
        return payload;
    }

    public static PushNotificationPayload complex() {
        return new PushNotificationPayload();
    }

    public static PushNotificationPayload fromJSON(String rawJSON) {
        return new PushNotificationPayload(rawJSON);
    }

    public void addBadge(int badge) {
        logger.debug("Adding badge [{}]", (Object)badge);
        this.put("badge", badge, this.apsDictionary, true);
    }

    public void addSound(String sound) {
        logger.debug("Adding sound [{}]", (Object)sound);
        this.put("sound", sound, this.apsDictionary, true);
    }

    public void addThreadId(String threadId) {
        logger.debug("Adding thread id [{}]", (Object)threadId);
        this.put("thread-id", threadId, this.apsDictionary, true);
    }

    public void addCategory(String category) {
        logger.debug("Adding category [{}]", (Object)category);
        this.put("category", category, this.apsDictionary, true);
    }

    public void addTargetContentId(String targetContentId) {
        logger.debug("Adding target content id [{}]", (Object)targetContentId);
        this.put("target-content-id", targetContentId, this.apsDictionary, true);
    }

    public void addMedia(String mediaUrl) {
        logger.debug("Adding mediaUrl [{}]", (Object)mediaUrl);
        this.put("mutable-content", 1, this.apsDictionary, false);
        this.put("my-attachment", mediaUrl, this.getPayload(), false);
    }

    public void addAlert(String alertMessage) {
        String previousAlert = this.getCompatibleProperty(ALERT, String.class, "A custom alert (\"%s\") was already added to this payload");
        logger.debug("Adding alert [{}]{}", (Object)alertMessage, previousAlert != null ? " replacing previous alert [" + previousAlert + "]" : "");
        this.put(ALERT, alertMessage, this.apsDictionary, false);
    }

    private JSONObject getOrAddCustomAlert() {
        JSONObject alert = this.getCompatibleProperty(ALERT, JSONObject.class, "A simple alert (\"%s\") was already added to this payload");
        if (alert == null) {
            alert = new JSONObject();
            this.put(ALERT, alert, this.apsDictionary, false);
        }
        return alert;
    }

    private <T> T getCompatibleProperty(String propertyName, Class<T> expectedClass, String exceptionMessage) {
        return PushNotificationPayload.getCompatibleProperty(propertyName, expectedClass, exceptionMessage, this.apsDictionary);
    }

    private static <T> T getCompatibleProperty(String propertyName, Class<T> expectedClass, String exceptionMessage, JSONObject dictionary) {
        Object propertyValue = null;
        try {
            propertyValue = dictionary.get(propertyName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue.getClass() == expectedClass) {
            return (T)propertyValue;
        }
        try {
            throw new PayloadAlertAlreadyExistsException(String.format(exceptionMessage, propertyValue));
        }
        catch (IllegalFormatException e) {
            throw new PayloadAlertAlreadyExistsException(exceptionMessage);
        }
    }

    public void addCustomAlertBody(String body) {
        this.put("body", body, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertTitle(String title) {
        this.put("title", title, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertSubtitle(String subtitle) {
        this.put("subtitle", subtitle, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertLaunchImage(String launchImage) {
        this.put("launch-image", launchImage, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertTitleLocKey(String titleLocKey) {
        this.put("title-loc-key", titleLocKey, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertTitleLocArgs(Collection<CharSequence> titleLocArgs) {
        this.put("title-loc-args", titleLocArgs, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertSubtitleLocKey(String subtitleLocKey) {
        this.put("subtitle-loc-key", subtitleLocKey, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertSubtitleLocArgs(Collection<CharSequence> subtitleLocArgs) {
        this.put("subtitle-loc-args", subtitleLocArgs, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertActionLocKey(String actionLocKey) {
        Object value = actionLocKey == null ? JSONObject.NULL : actionLocKey;
        this.put("action-loc-key", value, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertLocKey(String locKey) {
        this.put("loc-key", locKey, this.getOrAddCustomAlert(), false);
    }

    public void addCustomAlertLocArgs(Collection<CharSequence> locArgs) {
        this.put("loc-args", locArgs, this.getOrAddCustomAlert(), false);
    }

    public void setContentAvailable(boolean available) {
        if (available) {
            this.put("content-available", 1, this.apsDictionary, false);
        } else {
            this.remove("content-available", this.apsDictionary);
        }
    }

    @Override
    public int getMaximumPayloadSize() {
        return 4000;
    }

    @Override
    void verifyPayloadIsNotEmpty() {
        if (this.getPreSendConfiguration() != 0) {
            return;
        }
        if (this.toString().equals("{\"aps\":{}}")) {
            throw new IllegalArgumentException("Payload cannot be empty");
        }
    }
}

