/*
 * Decompiled with CFR 0.152.
 */
package javapns.notification;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javapns.communication.ConnectionToAppleServer;
import javapns.communication.exceptions.CommunicationException;
import javapns.communication.exceptions.InvalidCertificateChainException;
import javapns.communication.exceptions.KeystoreException;
import javapns.devices.Device;
import javapns.devices.DeviceFactory;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;
import javapns.devices.exceptions.NullIdException;
import javapns.devices.exceptions.UnknownDeviceException;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.devices.implementations.basic.BasicDeviceFactory;
import javapns.notification.AppleNotificationServer;
import javapns.notification.ConnectionToNotificationServer;
import javapns.notification.Payload;
import javapns.notification.PushNotificationPayload;
import javapns.notification.PushedNotification;
import javapns.notification.PushedNotifications;
import javapns.notification.ResponsePacketReader;
import javapns.notification.exceptions.PayloadIsEmptyException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushNotificationManager {
    private static final Logger logger = LoggerFactory.getLogger(PushNotificationManager.class);
    private static final int DEFAULT_RETRIES = 3;
    private static final int SEQUENTIAL_IDENTIFIER = -1;
    private static int testsSerialNumber = 1;
    private static boolean useEnhancedNotificationFormat = true;
    private static boolean heavyDebugMode = false;
    private int sslSocketTimeout = 30000;
    private ConnectionToAppleServer connectionToAppleServer;
    private SSLSocket socket;
    private int retryAttempts = 3;
    private int nextMessageIdentifier = 1;
    private boolean trustAllServerCertificates = true;
    @Deprecated
    private DeviceFactory deviceFactory;
    private final LinkedHashMap<Integer, PushedNotification> pushedNotifications = new LinkedHashMap();

    public PushNotificationManager() {
        this.deviceFactory = new BasicDeviceFactory();
    }

    @Deprecated
    private PushNotificationManager(DeviceFactory deviceManager) {
        this.deviceFactory = deviceManager;
    }

    private static byte[] intTo4ByteArray(int value) {
        return ByteBuffer.allocate(4).putInt(value).array();
    }

    private static byte[] intTo2ByteArray(int value) {
        int s1 = (value & 0xFF00) >> 8;
        int s2 = value & 0xFF;
        return new byte[]{(byte)s1, (byte)s2};
    }

    protected static boolean isEnhancedNotificationFormatEnabled() {
        return useEnhancedNotificationFormat;
    }

    public static void setEnhancedNotificationFormatEnabled(boolean enabled) {
        useEnhancedNotificationFormat = enabled;
    }

    public static void setHeavyDebugMode(boolean enabled) {
        heavyDebugMode = enabled;
    }

    public void initializeConnection(AppleNotificationServer server) throws CommunicationException, KeystoreException {
        try {
            this.connectionToAppleServer = new ConnectionToNotificationServer(server);
            this.socket = this.connectionToAppleServer.getSSLSocket();
            if (heavyDebugMode) {
                this.dumpCertificateChainDescription();
            }
            logger.debug("Initialized Connection to Host: [{}] Port: [{}]: {}", new Object[]{server.getNotificationServerHost(), server.getNotificationServerPort(), this.socket});
        }
        catch (CommunicationException | KeystoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommunicationException("Error creating connection with Apple server", e);
        }
    }

    private void dumpCertificateChainDescription() {
        try {
            File file = new File("apns-certificatechain.txt");
            FileOutputStream outf = new FileOutputStream(file);
            DataOutputStream outd = new DataOutputStream(outf);
            outd.writeBytes(this.getCertificateChainDescription());
            outd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getCertificateChainDescription() {
        StringBuilder buf = new StringBuilder();
        try {
            SSLSession session = this.socket.getSession();
            for (Certificate certificate : session.getLocalCertificates()) {
                buf.append(certificate.toString());
            }
            buf.append("\n--------------------------------------------------------------------------\n");
            for (Certificate certificate : session.getPeerCertificates()) {
                buf.append(certificate.toString());
            }
        }
        catch (Exception e) {
            buf.append(e);
        }
        return buf.toString();
    }

    private void initializePreviousConnection() throws CommunicationException, KeystoreException {
        this.initializeConnection((AppleNotificationServer)this.connectionToAppleServer.getServer());
    }

    public void restartConnection(AppleNotificationServer server) throws CommunicationException, KeystoreException {
        this.stopConnection();
        this.initializeConnection(server);
    }

    private void restartPreviousConnection() throws CommunicationException, KeystoreException {
        try {
            logger.debug("Closing connection to restart previous one");
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializePreviousConnection();
    }

    public void stopConnection() throws CommunicationException, KeystoreException {
        this.processedFailedNotifications();
        try {
            logger.debug("Closing connection");
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int processedFailedNotifications() throws CommunicationException, KeystoreException {
        if (useEnhancedNotificationFormat) {
            logger.debug("Reading responses");
            int responsesReceived = ResponsePacketReader.processResponses(this);
            while (responsesReceived > 0) {
                int n;
                ArrayList<PushedNotification> notificationsToResend = new ArrayList<PushedNotification>();
                boolean foundFirstFail = false;
                for (PushedNotification pushedNotification : this.pushedNotifications.values()) {
                    if (!foundFirstFail && pushedNotification.isSuccessful()) continue;
                    if (foundFirstFail) {
                        notificationsToResend.add(pushedNotification);
                        continue;
                    }
                    foundFirstFail = true;
                }
                this.pushedNotifications.clear();
                int toResend = notificationsToResend.size();
                logger.debug("Found {} notifications that must be re-sent", (Object)toResend);
                if (toResend > 0) {
                    logger.debug("Restarting connection to resend notifications");
                    this.restartPreviousConnection();
                    for (PushedNotification pushedNotification : notificationsToResend) {
                        this.sendNotification(pushedNotification, false);
                    }
                }
                if ((n = (responsesReceived = ResponsePacketReader.processResponses(this))) != 0) continue;
                logger.debug("No notifications remaining to be resent");
                return 0;
            }
            return responsesReceived;
        }
        logger.debug("Not reading responses because using simple notification format");
        return 0;
    }

    public PushedNotification sendNotification(Device device, Payload payload) throws CommunicationException {
        return this.sendNotification(device, payload, true);
    }

    public PushedNotifications sendNotifications(Payload payload, List<Device> devices) throws CommunicationException, KeystoreException {
        PushedNotifications notifications = new PushedNotifications();
        for (Device device : devices) {
            notifications.add(this.sendNotification(device, payload, false, -1));
        }
        this.stopConnection();
        return notifications;
    }

    public PushedNotifications sendNotifications(Payload payload, Device ... devices) throws CommunicationException, KeystoreException {
        PushedNotifications notifications = new PushedNotifications();
        for (Device device : devices) {
            notifications.add(this.sendNotification(device, payload, false, -1));
        }
        this.stopConnection();
        return notifications;
    }

    public PushedNotification sendNotification(Device device, Payload payload, boolean closeAfter) throws CommunicationException {
        return this.sendNotification(device, payload, closeAfter, -1);
    }

    public PushedNotification sendNotification(Device device, Payload payload, int identifier) throws CommunicationException {
        return this.sendNotification(device, payload, false, identifier);
    }

    public PushedNotification sendNotification(Device device, Payload payload, boolean closeAfter, int identifier) throws CommunicationException {
        PushedNotification pushedNotification = new PushedNotification(device, payload, identifier);
        this.sendNotification(pushedNotification, closeAfter);
        return pushedNotification;
    }

    private void sendNotification(PushedNotification notification, boolean closeAfter) throws CommunicationException {
        try {
            Device device = notification.getDevice();
            Payload payload = notification.getPayload();
            try {
                payload.verifyPayloadIsNotEmpty();
            }
            catch (IllegalArgumentException e) {
                throw new PayloadIsEmptyException();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (notification.getIdentifier() <= 0) {
                notification.setIdentifier(this.newMessageIdentifier());
            }
            if (!this.pushedNotifications.containsKey(notification.getIdentifier())) {
                this.pushedNotifications.put(notification.getIdentifier(), notification);
            }
            int identifier = notification.getIdentifier();
            String token = device.getToken();
            BasicDevice.validateTokenFormat(token);
            byte[] bytes = this.getMessage(token, payload, identifier, notification);
            boolean simulationMode = payload.getExpiry() == 919191;
            boolean success = false;
            int socketTimeout = this.getSslSocketTimeout();
            if (socketTimeout > 0) {
                this.socket.setSoTimeout(socketTimeout);
            }
            notification.setTransmissionAttempts(0);
            while (!success) {
                try {
                    logger.debug("Attempting to send notification: {}", (Object)payload.toString());
                    logger.debug("  to device: {}", (Object)token);
                    notification.addTransmissionAttempt();
                    boolean streamConfirmed = false;
                    try {
                        if (!simulationMode) {
                            this.socket.getOutputStream().write(bytes);
                            streamConfirmed = true;
                        } else {
                            logger.debug("* Simulation only: would have streamed {}-bytes message now..", (Object)bytes.length);
                        }
                    }
                    catch (Exception e) {
                        if (e.toString().contains("certificate_unknown")) {
                            throw new InvalidCertificateChainException(e.getMessage());
                        }
                        throw e;
                    }
                    logger.debug("Flushing");
                    this.socket.getOutputStream().flush();
                    if (streamConfirmed) {
                        logger.debug("At this point, the entire {}-bytes message has been streamed out successfully through the SSL connection", (Object)bytes.length);
                    }
                    success = true;
                    logger.debug("Notification sent on {}", (Object)notification.getLatestTransmissionAttempt());
                    notification.setTransmissionCompleted(true);
                }
                catch (IOException e) {
                    if (notification.getTransmissionAttempts() >= this.retryAttempts) {
                        logger.error("Attempt to send Notification failed and beyond the maximum number of attempts permitted");
                        notification.setTransmissionCompleted(false);
                        notification.setException(e);
                        logger.error("Delivery error", (Throwable)e);
                        throw e;
                    }
                    logger.info("Attempt failed ({})... trying again", (Object)e.getMessage());
                    try {
                        this.socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.socket = this.connectionToAppleServer.getSSLSocket();
                    if (socketTimeout <= 0) continue;
                    this.socket.setSoTimeout(socketTimeout);
                }
            }
        }
        catch (CommunicationException e) {
            throw e;
        }
        catch (Exception ex) {
            notification.setException(ex);
            logger.error("Delivery error: {}", (Throwable)ex);
            try {
                if (closeAfter) {
                    logger.error("Closing connection after error");
                    this.stopConnection();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public void addDevice(String id, String token) throws Exception {
        logger.debug("Adding Token [{}] to Device [{}]", (Object)token, (Object)id);
        this.deviceFactory.addDevice(id, token);
    }

    @Deprecated
    public Device getDevice(String id) throws UnknownDeviceException, NullIdException {
        logger.debug("Getting Token from Device [{}]", (Object)id);
        return this.deviceFactory.getDevice(id);
    }

    @Deprecated
    public void removeDevice(String id) throws UnknownDeviceException, NullIdException {
        logger.debug("Removing Token from Device [{}]", (Object)id);
        this.deviceFactory.removeDevice(id);
    }

    private byte[] getMessage(String deviceToken, Payload payload, int identifier, PushedNotification message) throws Exception {
        logger.debug("Building Raw message from deviceToken and payload");
        byte[] deviceTokenAsBytes = new byte[deviceToken.length() / 2];
        String upperCasedDeviceToken = deviceToken.toUpperCase();
        int j = 0;
        try {
            for (int i = 0; i < upperCasedDeviceToken.length(); i += 2) {
                String t = upperCasedDeviceToken.substring(i, i + 2);
                int tmp = Integer.parseInt(t, 16);
                deviceTokenAsBytes[j++] = (byte)tmp;
            }
        }
        catch (NumberFormatException e1) {
            throw new InvalidDeviceTokenFormatException(upperCasedDeviceToken, e1.getMessage());
        }
        this.preconfigurePayload(payload, identifier, upperCasedDeviceToken);
        byte[] payloadAsBytes = payload.getPayloadAsBytes();
        int size = 3 + deviceTokenAsBytes.length + 2 + payloadAsBytes.length;
        ByteArrayOutputStream bao = new ByteArrayOutputStream(size);
        int b = useEnhancedNotificationFormat ? 1 : 0;
        bao.write(b);
        if (useEnhancedNotificationFormat) {
            bao.write(PushNotificationManager.intTo4ByteArray(identifier));
            message.setIdentifier(identifier);
            int requestedExpiry = payload.getExpiry();
            if (requestedExpiry <= 0) {
                bao.write(PushNotificationManager.intTo4ByteArray(requestedExpiry));
                message.setExpiry(0L);
            } else {
                long ctime = System.currentTimeMillis();
                long ttl = requestedExpiry * 1000;
                long expiryDateInSeconds = (ctime + ttl) / 1000L;
                bao.write(PushNotificationManager.intTo4ByteArray((int)expiryDateInSeconds));
                message.setExpiry(ctime + ttl);
            }
        }
        int tl = deviceTokenAsBytes.length;
        bao.write(PushNotificationManager.intTo2ByteArray(tl));
        bao.write(deviceTokenAsBytes);
        int pl = payloadAsBytes.length;
        bao.write(PushNotificationManager.intTo2ByteArray(pl));
        bao.write(payloadAsBytes);
        bao.flush();
        byte[] bytes = bao.toByteArray();
        if (heavyDebugMode) {
            try {
                FileOutputStream outf = new FileOutputStream("apns-message.bytes");
                outf.write(bytes);
                outf.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        logger.debug("Built raw message ID {} of total length {}", (Object)identifier, (Object)bytes.length);
        return bytes;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    @Deprecated
    public DeviceFactory getDeviceFactory() {
        return this.deviceFactory;
    }

    @Deprecated
    public void setDeviceFactory(DeviceFactory deviceFactory) {
        this.deviceFactory = deviceFactory;
    }

    private int getSslSocketTimeout() {
        return this.sslSocketTimeout;
    }

    public void setSslSocketTimeout(int sslSocketTimeout) {
        this.sslSocketTimeout = sslSocketTimeout;
    }

    protected boolean isTrustAllServerCertificates() {
        return this.trustAllServerCertificates;
    }

    public void setTrustAllServerCertificates(boolean trustAllServerCertificates) {
        this.trustAllServerCertificates = trustAllServerCertificates;
    }

    private int newMessageIdentifier() {
        int id = this.nextMessageIdentifier++;
        return id;
    }

    Socket getActiveSocket() {
        return this.socket;
    }

    Map<Integer, PushedNotification> getPushedNotifications() {
        return this.pushedNotifications;
    }

    private void preconfigurePayload(Payload payload, int identifier, String deviceToken) {
        try {
            int config = payload.getPreSendConfiguration();
            if (payload instanceof PushNotificationPayload) {
                PushNotificationPayload pnpayload = (PushNotificationPayload)payload;
                if (config == 1) {
                    pnpayload.getPayload().remove("alert");
                    pnpayload.addAlert(this.buildDebugAlert(payload, identifier, deviceToken));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String buildDebugAlert(Payload payload, int identifier, String deviceToken) {
        StringBuilder alert = new StringBuilder();
        alert.append("JAVAPNS DEBUG ALERT ").append(testsSerialNumber++).append("\n");
        alert.append(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(System.currentTimeMillis())).append("\n");
        alert.append(this.connectionToAppleServer.getServerHost()).append("\n");
        int l = useEnhancedNotificationFormat ? 4 : 8;
        alert.append(deviceToken, 0, l).append("\ufffd").append(deviceToken, 64 - l, 64).append((String)(useEnhancedNotificationFormat ? " [Id:" + identifier + "] " + (String)(payload.getExpiry() <= 0 ? "No-store" : "Exp:T+" + payload.getExpiry()) : "")).append("\n");
        alert.append(useEnhancedNotificationFormat ? "Enhanced" : "Simple").append(" format / ").append(payload.getCharacterEncoding());
        return alert.toString();
    }
}

