/*
 * Decompiled with CFR 0.152.
 */
package javapns.devices.implementations.basic;

import java.sql.Timestamp;
import javapns.devices.Device;
import javapns.devices.exceptions.InvalidDeviceTokenFormatException;

public class BasicDevice
implements Device {
    private String deviceId;
    private String token;
    private Timestamp lastRegister;

    public BasicDevice() {
    }

    public BasicDevice(String token) throws InvalidDeviceTokenFormatException {
        this(token, true);
    }

    private BasicDevice(String token, boolean validate) throws InvalidDeviceTokenFormatException {
        this.deviceId = token;
        this.token = token;
        try {
            this.lastRegister = new Timestamp(System.currentTimeMillis());
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (validate) {
            BasicDevice.validateTokenFormat(token);
        }
    }

    BasicDevice(String id, String token, Timestamp register) throws InvalidDeviceTokenFormatException {
        this.deviceId = id;
        this.token = token;
        this.lastRegister = register;
        BasicDevice.validateTokenFormat(token);
    }

    public static void validateTokenFormat(String token) throws InvalidDeviceTokenFormatException {
        if (token == null) {
            throw new InvalidDeviceTokenFormatException("Device token may not be null");
        }
    }

    public void validateTokenFormat() throws InvalidDeviceTokenFormatException {
        BasicDevice.validateTokenFormat(this.token);
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public void setDeviceId(String id) {
        this.deviceId = id;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public Timestamp getLastRegister() {
        return this.lastRegister;
    }

    @Override
    public void setLastRegister(Timestamp lastRegister) {
        this.lastRegister = lastRegister;
    }
}

