/*
 * Decompiled with CFR 0.152.
 */
package javapns.devices;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javapns.devices.Device;
import javapns.devices.implementations.basic.BasicDevice;
import javapns.notification.PayloadPerDevice;

public class Devices {
    private Devices() {
    }

    public static List<Device> asDevices(Object rawList) {
        ArrayList<Device> list = new ArrayList<Device>();
        if (rawList == null) {
            return list;
        }
        if (rawList instanceof List) {
            List devices = (List)rawList;
            if (devices.isEmpty()) {
                return list;
            }
            Object firstDevice = devices.get(0);
            if (firstDevice instanceof Device) {
                return devices;
            }
            if (firstDevice instanceof String) {
                for (Object token : devices) {
                    BasicDevice device = new BasicDevice();
                    device.setToken((String)token);
                    list.add(device);
                }
            }
        } else if (rawList instanceof String[]) {
            String[] tokens;
            for (String token : tokens = (String[])rawList) {
                BasicDevice device = new BasicDevice();
                device.setToken(token);
                list.add(device);
            }
        } else {
            if (rawList instanceof Device[]) {
                Device[] dvs = (Device[])rawList;
                return Arrays.asList(dvs);
            }
            if (rawList instanceof String) {
                BasicDevice device = new BasicDevice();
                device.setToken((String)rawList);
                list.add(device);
            } else if (rawList instanceof Device) {
                list.add((Device)rawList);
            } else {
                throw new IllegalArgumentException("Device list type not supported. Supported types are: String[], List<String>, Device[], List<Device>, String and Device");
            }
        }
        return list;
    }

    public static List<PayloadPerDevice> asPayloadsPerDevices(Object rawList) {
        ArrayList<PayloadPerDevice> list = new ArrayList<PayloadPerDevice>();
        if (rawList == null) {
            return list;
        }
        if (rawList instanceof List) {
            List devices = (List)rawList;
            if (devices.isEmpty()) {
                return list;
            }
            return devices;
        }
        if (rawList instanceof PayloadPerDevice[]) {
            PayloadPerDevice[] dvs = (PayloadPerDevice[])rawList;
            return Arrays.asList(dvs);
        }
        if (!(rawList instanceof PayloadPerDevice)) {
            throw new IllegalArgumentException("PayloadPerDevice list type not supported. Supported types are: PayloadPerDevice[], List<PayloadPerDevice> and PayloadPerDevice");
        }
        list.add((PayloadPerDevice)rawList);
        return list;
    }
}

