/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.friendlycaptcha;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.drjekyll.friendlycaptcha.FriendlyCaptchaException;
import org.drjekyll.friendlycaptcha.ProxyAuthenticator;
import org.drjekyll.friendlycaptcha.VerificationError;
import org.drjekyll.friendlycaptcha.VerificationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FriendlyCaptchaVerifier {
    private static final Logger log = LoggerFactory.getLogger(FriendlyCaptchaVerifier.class);
    @NonNull
    private final String apiKey;
    @NonNull
    private ObjectMapper objectMapper;
    @NonNull
    private URI verificationEndpoint;
    private Duration connectTimeout;
    private Duration socketTimeout;
    @Nullable
    private String sitekey;
    @Nullable
    private String proxyHost;
    private int proxyPort;
    @Nullable
    private String proxyUserName;
    @Nullable
    private String proxyPassword;
    private boolean verbose;

    /*
     * Exception decompiling
     */
    public boolean verify(@Nonnull String solution) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean processResponse(HttpURLConnection connection, VerificationResponse verificationResponse) throws IOException {
        if (this.verbose) {
            log.info("Received response {} with status code {}", (Object)verificationResponse, (Object)connection.getResponseCode());
        }
        if (connection.getResponseCode() == 200) {
            return verificationResponse.isSuccess();
        }
        Collection<VerificationError> errors = verificationResponse.getErrors();
        if (errors == null || errors.isEmpty()) {
            throw new FriendlyCaptchaException("Verification API did not return any error");
        }
        log.warn("Received response with errors from Verification API: {}", (Object)verificationResponse);
        VerificationError verificationError = errors.iterator().next();
        String message = FriendlyCaptchaVerifier.isEmpty(verificationResponse.getDetails()) ? verificationError.getDescription() : verificationResponse.getDetails();
        throw new FriendlyCaptchaException(message);
    }

    @Nonnull
    private static InputStream getInputStream(@NonNull HttpURLConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        try {
            if (connection.getResponseCode() == 200) {
                return connection.getInputStream();
            }
            return connection.getErrorStream();
        }
        catch (IOException exception) {
            connection.disconnect();
            throw new FriendlyCaptchaException("Could not read response", exception);
        }
    }

    private static void writeEntity(@NonNull byte[] entity, @NonNull HttpURLConnection connection) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(entity);
            outputStream.flush();
        }
        catch (IOException e) {
            connection.disconnect();
            throw new FriendlyCaptchaException("Could not transfer solution", e);
        }
    }

    private HttpURLConnection connect(int contentLength) {
        HttpURLConnection connection;
        try {
            if (FriendlyCaptchaVerifier.isEmpty(this.proxyHost) || this.proxyPort <= 0) {
                connection = (HttpURLConnection)this.verificationEndpoint.toURL().openConnection();
            } else {
                InetSocketAddress proxyAddress = new InetSocketAddress(this.proxyHost, this.proxyPort);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, proxyAddress);
                if (!FriendlyCaptchaVerifier.isEmpty(this.proxyUserName) && !FriendlyCaptchaVerifier.isEmpty(this.proxyPassword)) {
                    Authenticator.setDefault(new ProxyAuthenticator(this.proxyUserName, this.proxyPassword));
                }
                connection = (HttpURLConnection)this.verificationEndpoint.toURL().openConnection(proxy);
            }
        }
        catch (IOException e) {
            throw new FriendlyCaptchaException("Could not open connection", e);
        }
        try {
            connection.setRequestMethod("POST");
        }
        catch (ProtocolException e) {
            throw new FriendlyCaptchaException("Could not set request method", e);
        }
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("User-Agent", "FriendlyCaptchaJavaClient");
        connection.setRequestProperty("charset", "utf-8");
        connection.setRequestProperty("Content-Length", Integer.toString(contentLength));
        connection.setRequestProperty("Connection", "close");
        if (this.connectTimeout != null) {
            connection.setConnectTimeout((int)this.connectTimeout.toMillis());
        }
        if (this.socketTimeout != null) {
            connection.setReadTimeout((int)this.socketTimeout.toMillis());
        }
        return connection;
    }

    private static void assertNotEmpty(@Nonnull String str, @Nullable String message) {
        if (FriendlyCaptchaVerifier.isEmpty(str)) {
            throw new IllegalArgumentException(message);
        }
    }

    private void assertVerificationEndpointScheme() {
        String scheme = this.verificationEndpoint.getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            throw new FriendlyCaptchaException("Invalid verification endpoint URL");
        }
    }

    @Nonnull
    private byte[] createEntity(@Nonnull String solution) {
        FriendlyCaptchaVerifier.assertNotEmpty(solution, "Solution must not be null or empty");
        try {
            String entity = "solution=" + URLEncoder.encode(solution, "UTF-8") + "&secret=" + URLEncoder.encode(this.apiKey, "UTF-8");
            if (!FriendlyCaptchaVerifier.isEmpty(this.sitekey)) {
                entity = entity + "&sitekey=" + this.sitekey;
            }
            return entity.getBytes(StandardCharsets.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new FriendlyCaptchaException("Could not encode payload", e);
        }
    }

    private VerificationResponse readVerificationResponse(@Nonnull InputStream inputStream) {
        try {
            return (VerificationResponse)this.objectMapper.readValue(inputStream, VerificationResponse.class);
        }
        catch (Exception e) {
            throw new FriendlyCaptchaException("Could not read response from verification API", e);
        }
    }

    private static boolean isEmpty(@Nullable String str) {
        return str == null || str.trim().isEmpty();
    }

    private static ObjectMapper $default$objectMapper() {
        return new ObjectMapper();
    }

    private static URI $default$verificationEndpoint() {
        return URI.create("https://api.friendlycaptcha.com/api/v1/siteverify");
    }

    private static Duration $default$connectTimeout() {
        return Duration.ofSeconds(10L);
    }

    private static Duration $default$socketTimeout() {
        return Duration.ofSeconds(30L);
    }

    FriendlyCaptchaVerifier(@NonNull String apiKey, @NonNull ObjectMapper objectMapper, @NonNull URI verificationEndpoint, Duration connectTimeout, Duration socketTimeout, @Nullable String sitekey, @Nullable String proxyHost, int proxyPort, @Nullable String proxyUserName, @Nullable String proxyPassword, boolean verbose) {
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (verificationEndpoint == null) {
            throw new NullPointerException("verificationEndpoint is marked non-null but is null");
        }
        this.apiKey = apiKey;
        this.objectMapper = objectMapper;
        this.verificationEndpoint = verificationEndpoint;
        this.connectTimeout = connectTimeout;
        this.socketTimeout = socketTimeout;
        this.sitekey = sitekey;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUserName = proxyUserName;
        this.proxyPassword = proxyPassword;
        this.verbose = verbose;
    }

    public static FriendlyCaptchaVerifierBuilder builder() {
        return new FriendlyCaptchaVerifierBuilder();
    }

    public static class FriendlyCaptchaVerifierBuilder {
        private String apiKey;
        private boolean objectMapper$set;
        private ObjectMapper objectMapper$value;
        private boolean verificationEndpoint$set;
        private URI verificationEndpoint$value;
        private boolean connectTimeout$set;
        private Duration connectTimeout$value;
        private boolean socketTimeout$set;
        private Duration socketTimeout$value;
        private String sitekey;
        private String proxyHost;
        private int proxyPort;
        private String proxyUserName;
        private String proxyPassword;
        private boolean verbose;

        FriendlyCaptchaVerifierBuilder() {
        }

        public FriendlyCaptchaVerifierBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder objectMapper(@NonNull ObjectMapper objectMapper) {
            if (objectMapper == null) {
                throw new NullPointerException("objectMapper is marked non-null but is null");
            }
            this.objectMapper$value = objectMapper;
            this.objectMapper$set = true;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder verificationEndpoint(@NonNull URI verificationEndpoint) {
            if (verificationEndpoint == null) {
                throw new NullPointerException("verificationEndpoint is marked non-null but is null");
            }
            this.verificationEndpoint$value = verificationEndpoint;
            this.verificationEndpoint$set = true;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder socketTimeout(Duration socketTimeout) {
            this.socketTimeout$value = socketTimeout;
            this.socketTimeout$set = true;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder sitekey(@Nullable String sitekey) {
            this.sitekey = sitekey;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder proxyHost(@Nullable String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder proxyUserName(@Nullable String proxyUserName) {
            this.proxyUserName = proxyUserName;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder proxyPassword(@Nullable String proxyPassword) {
            this.proxyPassword = proxyPassword;
            return this;
        }

        public FriendlyCaptchaVerifierBuilder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public FriendlyCaptchaVerifier build() {
            ObjectMapper objectMapper$value = this.objectMapper$value;
            if (!this.objectMapper$set) {
                objectMapper$value = FriendlyCaptchaVerifier.$default$objectMapper();
            }
            URI verificationEndpoint$value = this.verificationEndpoint$value;
            if (!this.verificationEndpoint$set) {
                verificationEndpoint$value = FriendlyCaptchaVerifier.$default$verificationEndpoint();
            }
            Duration connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = FriendlyCaptchaVerifier.$default$connectTimeout();
            }
            Duration socketTimeout$value = this.socketTimeout$value;
            if (!this.socketTimeout$set) {
                socketTimeout$value = FriendlyCaptchaVerifier.$default$socketTimeout();
            }
            return new FriendlyCaptchaVerifier(this.apiKey, objectMapper$value, verificationEndpoint$value, connectTimeout$value, socketTimeout$value, this.sitekey, this.proxyHost, this.proxyPort, this.proxyUserName, this.proxyPassword, this.verbose);
        }

        public String toString() {
            return "FriendlyCaptchaVerifier.FriendlyCaptchaVerifierBuilder(apiKey=" + this.apiKey + ", objectMapper$value=" + this.objectMapper$value + ", verificationEndpoint$value=" + this.verificationEndpoint$value + ", connectTimeout$value=" + this.connectTimeout$value + ", socketTimeout$value=" + this.socketTimeout$value + ", sitekey=" + this.sitekey + ", proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", proxyUserName=" + this.proxyUserName + ", proxyPassword=" + this.proxyPassword + ", verbose=" + this.verbose + ")";
        }
    }
}

