/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql;

import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.drizzle.jdbc.DrizzleBlob;
import org.drizzle.jdbc.internal.common.AbstractValueObject;
import org.drizzle.jdbc.internal.common.DataType;

public class MySQLValueObject
extends AbstractValueObject {
    public MySQLValueObject(byte[] rawBytes, DataType dataType) {
        super(rawBytes, dataType);
    }

    public Object getObject() throws ParseException {
        if (this.getBytes() == null) {
            return null;
        }
        switch (this.dataType.getType()) {
            case TINY: {
                return this.getShort();
            }
            case LONG: {
                return this.getLong();
            }
            case DOUBLE: {
                return this.getDouble();
            }
            case TIMESTAMP: {
                return this.getTimestamp();
            }
            case LONGLONG: {
                return this.getBigInteger();
            }
            case DATETIME: {
                return this.getTimestamp();
            }
            case DATE: {
                return this.getDate();
            }
            case VARCHAR: {
                return this.getString();
            }
            case NEWDECIMAL: {
                return this.getBigDecimal();
            }
            case ENUM: {
                return this.getString();
            }
            case BLOB: {
                return new DrizzleBlob(this.getBytes());
            }
            case YEAR: {
                return this.getString();
            }
            case BIT: {
                if (this.getBytes().length == 1) {
                    return this.getBytes()[0] == 1;
                }
                return null;
            }
            case SHORT: 
            case INT24: {
                return this.getInt();
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat());
            }
            case TIME: {
                return this.getTime();
            }
            case CLOB: {
                return this.getString();
            }
        }
        return null;
    }

    public Time getTime() throws ParseException {
        if (this.getBytes() == null) {
            return null;
        }
        String rawValue = this.getString();
        SimpleDateFormat sdf = rawValue.length() > 8 ? new SimpleDateFormat("HH:mm:ss.SSS") : new SimpleDateFormat("HH:mm:ss");
        Date utilTime = sdf.parse(rawValue);
        return new Time(utilTime.getTime());
    }
}

