/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.BinlogDumpException;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.PacketFetcher;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.ServerStatus;
import org.drizzle.jdbc.internal.common.SupportedDatabases;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.packet.EOFPacket;
import org.drizzle.jdbc.internal.common.packet.ErrorPacket;
import org.drizzle.jdbc.internal.common.packet.OKPacket;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacket;
import org.drizzle.jdbc.internal.common.packet.ResultPacketFactory;
import org.drizzle.jdbc.internal.common.packet.ResultSetPacket;
import org.drizzle.jdbc.internal.common.packet.SyncPacketFetcher;
import org.drizzle.jdbc.internal.common.packet.buffer.ReadUtil;
import org.drizzle.jdbc.internal.common.packet.buffer.WriteBuffer;
import org.drizzle.jdbc.internal.common.packet.commands.ClosePacket;
import org.drizzle.jdbc.internal.common.packet.commands.SelectDBPacket;
import org.drizzle.jdbc.internal.common.packet.commands.StreamedQueryPacket;
import org.drizzle.jdbc.internal.common.query.DrizzleQuery;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.common.queryresults.DrizzleQueryResult;
import org.drizzle.jdbc.internal.common.queryresults.DrizzleUpdateResult;
import org.drizzle.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.drizzle.jdbc.internal.common.queryresults.QueryResult;
import org.drizzle.jdbc.internal.drizzle.packet.DrizzleRowPacket;
import org.drizzle.jdbc.internal.mysql.MySQLServerCapabilities;
import org.drizzle.jdbc.internal.mysql.packet.MySQLFieldPacket;
import org.drizzle.jdbc.internal.mysql.packet.MySQLGreetingReadPacket;
import org.drizzle.jdbc.internal.mysql.packet.MySQLRowPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.AbbreviatedMySQLClientAuthPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.MySQLBinlogDumpPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.MySQLClientAuthPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.MySQLClientOldPasswordAuthPacket;
import org.drizzle.jdbc.internal.mysql.packet.commands.MySQLPingPacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLProtocol
implements Protocol {
    private static final Logger log = Logger.getLogger(MySQLProtocol.class.getName());
    private boolean connected = false;
    private Socket socket;
    private BufferedOutputStream writer;
    private final String version;
    private boolean readOnly = false;
    private final String host;
    private final int port;
    private String database;
    private final String username;
    private final String password;
    private final List<Query> batchList;
    private PacketFetcher packetFetcher;
    private final Properties info;
    private final long serverThreadId;
    private volatile boolean queryWasCancelled = false;
    private volatile boolean queryTimedOut = false;
    private boolean hasMoreResults = false;

    public MySQLProtocol(String host, int port, String database, String username, String password, Properties info) throws QueryException {
        this.info = info;
        this.host = host;
        this.port = port;
        this.database = database == null ? "" : database;
        this.username = username == null ? "" : username;
        this.password = password == null ? "" : password;
        SocketFactory socketFactory = SocketFactory.getDefault();
        try {
            String connectTimeoutString = info.getProperty("connectTimeout");
            Integer connectTimeout = null;
            if (connectTimeoutString != null) {
                try {
                    connectTimeout = Integer.valueOf(connectTimeoutString);
                }
                catch (Exception e) {
                    connectTimeout = null;
                }
            }
            InetSocketAddress sockAddr = new InetSocketAddress(host, port);
            this.socket = socketFactory.createSocket();
            if (connectTimeout != null) {
                this.socket.connect(sockAddr, connectTimeout * 1000);
            } else {
                this.socket.connect(sockAddr);
            }
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.batchList = new ArrayList<Query>();
        try {
            ResultPacket resultPacket;
            BufferedInputStream reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
            this.packetFetcher = new SyncPacketFetcher(reader);
            this.writer = new BufferedOutputStream(this.socket.getOutputStream(), 32768);
            MySQLGreetingReadPacket greetingPacket = new MySQLGreetingReadPacket(this.packetFetcher.getRawPacket());
            this.serverThreadId = greetingPacket.getServerThreadID();
            log.finest("Got greeting packet");
            this.version = greetingPacket.getServerVersion();
            byte packetSeq = 1;
            EnumSet<MySQLServerCapabilities[]> capabilities = EnumSet.of(MySQLServerCapabilities.LONG_PASSWORD, new MySQLServerCapabilities[]{MySQLServerCapabilities.IGNORE_SPACE, MySQLServerCapabilities.CLIENT_PROTOCOL_41, MySQLServerCapabilities.TRANSACTIONS, MySQLServerCapabilities.SECURE_CONNECTION, MySQLServerCapabilities.LOCAL_FILES});
            if (info.getProperty("allowMultiQueries") != null) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.MULTI_STATEMENTS);
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.MULTI_RESULTS);
            }
            if (this.database != null && !this.database.equals("") && !this.createDB()) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.CONNECT_WITH_DB);
            }
            if (info.getProperty("useAffectedRows", "false").equals("false")) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.FOUND_ROWS);
            }
            if (info.getProperty("useSSL") != null && greetingPacket.getServerCapabilities().contains((Object)MySQLServerCapabilities.SSL)) {
                capabilities.add((MySQLServerCapabilities[])MySQLServerCapabilities.SSL);
                AbbreviatedMySQLClientAuthPacket amcap = new AbbreviatedMySQLClientAuthPacket(capabilities);
                amcap.send(this.writer);
                SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), false);
                sslSocket.setEnabledProtocols(new String[]{"TLSv1"});
                sslSocket.setUseClientMode(true);
                sslSocket.startHandshake();
                this.socket = sslSocket;
                this.writer = new BufferedOutputStream(this.socket.getOutputStream(), 32768);
                this.writer.flush();
                reader = new BufferedInputStream(this.socket.getInputStream(), 32768);
                this.packetFetcher = new SyncPacketFetcher(reader);
                packetSeq = (byte)(packetSeq + 1);
            } else if (info.getProperty("useSSL") != null) {
                throw new QueryException("Trying to connect with ssl, but ssl not enabled in the server");
            }
            MySQLClientAuthPacket cap = new MySQLClientAuthPacket(this.username, this.password, this.database, capabilities, greetingPacket.getSeed(), packetSeq);
            cap.send(this.writer);
            log.finest("Sending auth packet");
            RawPacket rp = this.packetFetcher.getRawPacket();
            if ((rp.getByteBuffer().get(0) & 0xFF) == 254) {
                MySQLClientOldPasswordAuthPacket oldPassPacket = new MySQLClientOldPasswordAuthPacket(this.password, Utils.copyWithLength(greetingPacket.getSeed(), 8), rp.getPacketSeq() + 1);
                oldPassPacket.send(this.writer);
                rp = this.packetFetcher.getRawPacket();
            }
            if ((resultPacket = ResultPacketFactory.createResultPacket(rp)).getResultType() == ResultPacket.ResultType.ERROR) {
                ErrorPacket ep = (ErrorPacket)resultPacket;
                String message = ep.getMessage();
                throw new QueryException("Could not connect: " + message);
            }
            if (this.createDB()) {
                this.executeQuery(new DrizzleQuery("CREATE DATABASE IF NOT EXISTS " + this.database));
                this.executeQuery(new DrizzleQuery("USE " + this.database));
            }
            this.connected = true;
        }
        catch (IOException e) {
            throw new QueryException("Could not connect: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public void close() throws QueryException {
        try {
            if (!(this.socket instanceof SSLSocket)) {
                this.socket.shutdownInput();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            ClosePacket closePacket = new ClosePacket();
            closePacket.send(this.writer);
            if (!(this.socket instanceof SSLSocket)) {
                this.socket.shutdownOutput();
            }
            this.writer.close();
            this.packetFetcher.close();
        }
        catch (IOException e) {
            throw new QueryException("Could not close connection: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        finally {
            try {
                this.connected = false;
                this.socket.close();
            }
            catch (IOException e) {
                log.warning("Could not close socket");
            }
        }
        this.connected = false;
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private QueryResult createDrizzleQueryResult(ResultSetPacket packet) throws IOException, QueryException {
        RawPacket rawPacket;
        ArrayList<ColumnInformation> columnInformation = new ArrayList<ColumnInformation>();
        int i = 0;
        while ((long)i < packet.getFieldCount()) {
            rawPacket = this.packetFetcher.getRawPacket();
            ColumnInformation columnInfo = MySQLFieldPacket.columnInformationFactory(rawPacket);
            columnInformation.add(columnInfo);
            ++i;
        }
        this.packetFetcher.getRawPacket();
        ArrayList<List<ValueObject>> valueObjects = new ArrayList<List<ValueObject>>();
        while (true) {
            Object rowPacket;
            if (ReadUtil.isErrorPacket(rawPacket = this.packetFetcher.getRawPacket())) {
                ErrorPacket errorPacket = (ErrorPacket)ResultPacketFactory.createResultPacket(rawPacket);
                this.checkIfCancelled();
                throw new QueryException(errorPacket.getMessage(), errorPacket.getErrorNumber(), errorPacket.getSqlState());
            }
            if (ReadUtil.eofIsNext(rawPacket)) {
                EOFPacket eofPacket = (EOFPacket)ResultPacketFactory.createResultPacket(rawPacket);
                this.hasMoreResults = eofPacket.getStatusFlags().contains((Object)EOFPacket.ServerStatus.SERVER_MORE_RESULTS_EXISTS);
                this.checkIfCancelled();
                return new DrizzleQueryResult(columnInformation, valueObjects, eofPacket.getWarningCount());
            }
            if (this.getDatabaseType() == SupportedDatabases.MYSQL) {
                rowPacket = new MySQLRowPacket(rawPacket, columnInformation);
                valueObjects.add(((MySQLRowPacket)rowPacket).getRow(this.packetFetcher));
                continue;
            }
            rowPacket = new DrizzleRowPacket(rawPacket, columnInformation);
            valueObjects.add(((DrizzleRowPacket)rowPacket).getRow());
        }
    }

    private void checkIfCancelled() throws QueryException {
        if (this.queryWasCancelled) {
            this.queryWasCancelled = false;
            throw new QueryException("Query was cancelled by another thread", -1, "JZ0001");
        }
        if (this.queryTimedOut) {
            this.queryTimedOut = false;
            throw new QueryException("Query timed out", -1, "JZ0002");
        }
    }

    @Override
    public void selectDB(String database) throws QueryException {
        log.finest("Selecting db " + database);
        SelectDBPacket packet = new SelectDBPacket(database);
        try {
            packet.send(this.writer);
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not select database: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        this.database = database;
    }

    @Override
    public String getServerVersion() {
        return this.version;
    }

    @Override
    public void setReadonly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public void commit() throws QueryException {
        log.finest("commiting transaction");
        this.executeQuery(new DrizzleQuery("COMMIT"));
    }

    @Override
    public void rollback() throws QueryException {
        log.finest("rolling transaction back");
        this.executeQuery(new DrizzleQuery("ROLLBACK"));
    }

    @Override
    public void rollback(String savepoint) throws QueryException {
        log.finest("rolling back to savepoint " + savepoint);
        this.executeQuery(new DrizzleQuery("ROLLBACK TO SAVEPOINT " + savepoint));
    }

    @Override
    public void setSavepoint(String savepoint) throws QueryException {
        this.executeQuery(new DrizzleQuery("SAVEPOINT " + savepoint));
    }

    @Override
    public void releaseSavepoint(String savepoint) throws QueryException {
        this.executeQuery(new DrizzleQuery("RELEASE SAVEPOINT " + savepoint));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public boolean ping() throws QueryException {
        MySQLPingPacket pingPacket = new MySQLPingPacket();
        try {
            pingPacket.send(this.writer);
            log.finest("Sent ping packet");
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            return ResultPacketFactory.createResultPacket(rawPacket).getResultType() == ResultPacket.ResultType.OK;
        }
        catch (IOException e) {
            throw new QueryException("Could not ping: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
    }

    @Override
    public QueryResult executeQuery(Query dQuery) throws QueryException {
        ResultPacket resultPacket;
        log.finest("Executing streamed query: " + dQuery);
        this.hasMoreResults = false;
        StreamedQueryPacket packet = new StreamedQueryPacket(dQuery);
        try {
            this.packetFetcher.clearInputStream();
            packet.send(this.writer);
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                ErrorPacket ep = (ErrorPacket)resultPacket;
                this.checkIfCancelled();
                log.warning("Could not execute query " + dQuery + ": " + ((ErrorPacket)resultPacket).getMessage());
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OKPacket okpacket = (OKPacket)resultPacket;
                this.hasMoreResults = okpacket.getServerStatus().contains((Object)ServerStatus.MORE_RESULTS_EXISTS);
                DrizzleUpdateResult updateResult = new DrizzleUpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                log.fine("OK, " + okpacket.getAffectedRows());
                return updateResult;
            }
            case RESULTSET: {
                log.fine("SELECT executed, fetching result set");
                try {
                    return this.createDrizzleQueryResult((ResultSetPacket)resultPacket);
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        log.severe("Could not parse result..." + (Object)((Object)resultPacket.getResultType()));
        throw new QueryException("Could not parse result", -1, SQLExceptionMapper.SQLStates.INTERRUPTED_EXCEPTION.getSqlState());
    }

    @Override
    public void addToBatch(Query dQuery) {
        this.batchList.add(dQuery);
    }

    @Override
    public List<QueryResult> executeBatch() throws QueryException {
        ArrayList<QueryResult> retList = new ArrayList<QueryResult>(this.batchList.size());
        for (Query query : this.batchList) {
            retList.add(this.executeQuery(query));
        }
        this.clearBatch();
        return retList;
    }

    @Override
    public void clearBatch() {
        this.batchList.clear();
    }

    @Override
    public List<RawPacket> startBinlogDump(int startPos, String filename) throws BinlogDumpException {
        MySQLBinlogDumpPacket mbdp = new MySQLBinlogDumpPacket(startPos, filename);
        try {
            mbdp.send(this.writer);
            LinkedList<RawPacket> rpList = new LinkedList<RawPacket>();
            while (true) {
                RawPacket rp;
                if (ReadUtil.eofIsNext(rp = this.packetFetcher.getRawPacket())) {
                    return rpList;
                }
                rpList.add(rp);
            }
        }
        catch (IOException e) {
            throw new BinlogDumpException("Could not read binlog", e);
        }
    }

    @Override
    public SupportedDatabases getDatabaseType() {
        return SupportedDatabases.fromVersionString(this.version);
    }

    @Override
    public boolean supportsPBMS() {
        return this.info != null && this.info.getProperty("enableBlobStreaming", "").equalsIgnoreCase("true");
    }

    @Override
    public String getServerVariable(String variable) throws QueryException {
        DrizzleQueryResult qr = (DrizzleQueryResult)this.executeQuery(new DrizzleQuery("select @@" + variable));
        if (!qr.next()) {
            throw new QueryException("Could not get variable: " + variable);
        }
        try {
            String value = qr.getValueObject(0).getString();
            return value;
        }
        catch (NoSuchColumnException e) {
            throw new QueryException("Could not get variable: " + variable);
        }
    }

    @Override
    public QueryResult executeQuery(Query dQuery, InputStream inputStream) throws QueryException {
        ResultPacket resultPacket;
        RawPacket rawPacket;
        int packIndex = 0;
        if (this.hasMoreResults) {
            try {
                this.packetFetcher.clearInputStream();
            }
            catch (IOException e) {
                throw new QueryException("Could clear input stream: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
            }
        }
        this.hasMoreResults = false;
        log.finest("Executing streamed query: " + dQuery);
        StreamedQueryPacket packet = new StreamedQueryPacket(dQuery);
        try {
            packIndex = packet.send(this.writer);
            ++packIndex;
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            rawPacket = this.packetFetcher.getRawPacket();
            resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        if (rawPacket.getPacketSeq() != packIndex) {
            throw new QueryException("Got out of order packet ", -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), null);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                ErrorPacket ep = (ErrorPacket)resultPacket;
                log.warning("Could not execute query " + dQuery + ": " + ((ErrorPacket)resultPacket).getMessage());
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                break;
            }
            case RESULTSET: {
                break;
            }
            default: {
                log.severe("Could not parse result...");
                throw new QueryException("Could not parse result");
            }
        }
        return this.sendFile(dQuery, inputStream, ++packIndex);
    }

    @Override
    public void cancelCurrentQuery() throws QueryException {
        MySQLProtocol copiedProtocol = new MySQLProtocol(this.host, this.port, this.database, this.username, this.password, this.info);
        this.queryWasCancelled = true;
        copiedProtocol.executeQuery(new DrizzleQuery("KILL QUERY " + this.serverThreadId));
        copiedProtocol.close();
    }

    @Override
    public void timeOut() throws QueryException {
        MySQLProtocol copiedProtocol = new MySQLProtocol(this.host, this.port, this.database, this.username, this.password, this.info);
        this.queryTimedOut = true;
        copiedProtocol.executeQuery(new DrizzleQuery("KILL QUERY " + this.serverThreadId));
        copiedProtocol.close();
    }

    @Override
    public boolean createDB() {
        return this.info != null && this.info.getProperty("createDB", "").equalsIgnoreCase("true");
    }

    @Override
    public boolean noPrepStmtCache() {
        return this.info != null && this.info.getProperty("noPrepStmtCache", "").equalsIgnoreCase("true");
    }

    private QueryResult sendFile(Query dQuery, InputStream inputStream, int packIndex) throws QueryException {
        ResultPacket resultPacket;
        byte[] emptyHeader = Utils.copyWithLength(WriteBuffer.intToByteArray(0), 4);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream bOS = new ByteArrayOutputStream();
        try {
            while (true) {
                int data;
                if ((data = bufferedInputStream.read()) == -1) {
                    byte[] data1 = bOS.toByteArray();
                    byte[] byteHeader = Utils.copyWithLength(WriteBuffer.intToByteArray(data1.length), 4);
                    byteHeader[3] = (byte)packIndex;
                    this.writer.write(byteHeader);
                    this.writer.write(data1);
                    this.writer.flush();
                    ++packIndex;
                    break;
                }
                bOS.write(data);
                if (bOS.size() < 0xFFFFFF) continue;
                byte[] byteHeader = Utils.copyWithLength(WriteBuffer.intToByteArray(bOS.size()), 4);
                byteHeader[3] = (byte)packIndex;
                this.writer.write(byteHeader);
                bOS.writeTo(this.writer);
                this.writer.flush();
                ++packIndex;
                bOS.reset();
            }
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            emptyHeader[3] = (byte)packIndex;
            this.writer.write(emptyHeader);
            this.writer.flush();
        }
        catch (IOException e) {
            throw new QueryException("Could not send query: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        try {
            RawPacket rawPacket = this.packetFetcher.getRawPacket();
            resultPacket = ResultPacketFactory.createResultPacket(rawPacket);
        }
        catch (IOException e) {
            throw new QueryException("Could not read resultset: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        switch (resultPacket.getResultType()) {
            case ERROR: {
                ErrorPacket ep = (ErrorPacket)resultPacket;
                this.checkIfCancelled();
                throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
            }
            case OK: {
                OKPacket okpacket = (OKPacket)resultPacket;
                this.hasMoreResults = okpacket.getServerStatus().contains((Object)ServerStatus.MORE_RESULTS_EXISTS);
                DrizzleUpdateResult updateResult = new DrizzleUpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                log.fine("OK, " + okpacket.getAffectedRows());
                return updateResult;
            }
            case RESULTSET: {
                log.fine("SELECT executed, fetching result set");
                try {
                    return this.createDrizzleQueryResult((ResultSetPacket)resultPacket);
                }
                catch (IOException e) {
                    throw new QueryException("Could not read result set: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
                }
            }
        }
        log.severe("Could not parse result...");
        throw new QueryException("Could not parse result");
    }

    @Override
    public QueryResult getMoreResults() throws QueryException {
        try {
            if (!this.hasMoreResults) {
                return null;
            }
            ResultPacket resultPacket = ResultPacketFactory.createResultPacket(this.packetFetcher.getRawPacket());
            switch (resultPacket.getResultType()) {
                case RESULTSET: {
                    return this.createDrizzleQueryResult((ResultSetPacket)resultPacket);
                }
                case OK: {
                    OKPacket okpacket = (OKPacket)resultPacket;
                    this.hasMoreResults = okpacket.getServerStatus().contains((Object)ServerStatus.MORE_RESULTS_EXISTS);
                    return new DrizzleUpdateResult(okpacket.getAffectedRows(), okpacket.getWarnings(), okpacket.getMessage(), okpacket.getInsertId());
                }
                case ERROR: {
                    ErrorPacket ep = (ErrorPacket)resultPacket;
                    this.checkIfCancelled();
                    throw new QueryException(ep.getMessage(), ep.getErrorNumber(), ep.getSqlState());
                }
            }
        }
        catch (IOException e) {
            throw new QueryException("Could not read result set: " + e.getMessage(), -1, SQLExceptionMapper.SQLStates.CONNECTION_EXCEPTION.getSqlState(), e);
        }
        return null;
    }

    public static String hexdump(byte[] buffer, int offset) {
        StringBuffer dump = new StringBuffer();
        if (buffer.length - offset > 0) {
            dump.append(String.format("%02x", buffer[offset]));
            for (int i = offset + 1; i < buffer.length; ++i) {
                dump.append("_");
                dump.append(String.format("%02x", buffer[i]));
            }
        }
        return dump.toString();
    }

    public static String hexdump(ByteBuffer bb, int offset) {
        byte[] b = new byte[bb.capacity()];
        bb.mark();
        bb.get(b);
        bb.reset();
        return MySQLProtocol.hexdump(b, offset);
    }

    @Override
    public void setCatalog(String catalog) throws QueryException {
        if (this.getDatabaseType() == SupportedDatabases.MYSQL) {
            this.executeQuery(new DrizzleQuery("USE `" + catalog + "`"));
            this.database = catalog;
        }
    }

    @Override
    public String getCatalog() throws QueryException {
        if (this.getDatabaseType() == SupportedDatabases.MYSQL) {
            return this.getDatabase();
        }
        return null;
    }
}

