/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.mysql;

import java.util.Collections;
import java.util.Set;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.DataType;
import org.drizzle.jdbc.internal.common.queryresults.ColumnFlags;
import org.drizzle.jdbc.internal.mysql.MySQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLColumnInformation
implements ColumnInformation {
    private final String catalog;
    private final String db;
    private final String table;
    private final String orgTable;
    private final String name;
    private final String orgName;
    private final short charsetNumber;
    private final long length;
    private final DataType type;
    private final byte decimals;
    private final Set<ColumnFlags> flags;
    private int displayWidth = 0;

    private MySQLColumnInformation(Builder builder) {
        this.catalog = builder.catalog;
        this.db = builder.db;
        this.table = builder.table;
        this.orgTable = builder.originalTable;
        this.name = builder.name;
        this.orgName = builder.originalName;
        this.charsetNumber = builder.charsetNumber;
        this.length = builder.length;
        this.decimals = builder.decimals;
        this.flags = Collections.unmodifiableSet(builder.flags);
        this.type = builder.type.getSqlType() == 2004 && this.charsetNumber != 63 ? new MySQLType(MySQLType.Type.CLOB) : builder.type;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public String getDb() {
        return this.db;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getOriginalTable() {
        return this.orgTable;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getOriginalName() {
        return this.orgName;
    }

    @Override
    public short getCharsetNumber() {
        return this.charsetNumber;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public byte getDecimals() {
        return this.decimals;
    }

    @Override
    public Set<ColumnFlags> getFlags() {
        return this.flags;
    }

    @Override
    public void updateDisplaySize(int displayLength) {
        if (displayLength > this.displayWidth) {
            this.displayWidth = displayLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String catalog;
        private String db;
        private String table;
        private String originalTable;
        private String name;
        private String originalName;
        private short charsetNumber;
        private int length;
        private DataType type;
        private Set<ColumnFlags> flags;
        private byte decimals;

        public Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder originalTable(String orgTable) {
            this.originalTable = orgTable;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder originalName(String orgName) {
            this.originalName = orgName;
            return this;
        }

        public Builder skipMe(long bytesSkipped) {
            return this;
        }

        public Builder charsetNumber(short charsetNumber) {
            this.charsetNumber = charsetNumber;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder type(DataType dataType) {
            this.type = dataType;
            return this;
        }

        public Builder flags(Set<ColumnFlags> columnFlags) {
            this.flags = columnFlags;
            return this;
        }

        public Builder decimals(byte decimals) {
            this.decimals = decimals;
            return this;
        }

        public MySQLColumnInformation build() {
            return new MySQLColumnInformation(this);
        }
    }
}

