/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.queryresults;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.drizzle.jdbc.internal.common.ColumnInformation;
import org.drizzle.jdbc.internal.common.GeneratedIdValueObject;
import org.drizzle.jdbc.internal.common.ValueObject;
import org.drizzle.jdbc.internal.common.queryresults.ColumnFlags;
import org.drizzle.jdbc.internal.common.queryresults.NoSuchColumnException;
import org.drizzle.jdbc.internal.common.queryresults.ResultSetType;
import org.drizzle.jdbc.internal.common.queryresults.SelectQueryResult;
import org.drizzle.jdbc.internal.mysql.MySQLColumnInformation;
import org.drizzle.jdbc.internal.mysql.MySQLType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrizzleInsertIdQueryResult
implements SelectQueryResult {
    private final long insertId;
    private int rowPointer = 0;
    private final long rows;
    private final String message;

    public DrizzleInsertIdQueryResult(long insertId, long rows, String message) {
        this.insertId = insertId;
        this.message = message;
        this.rows = rows;
    }

    @Override
    public ValueObject getValueObject(int index) throws NoSuchColumnException {
        if (index != 0) {
            throw new NoSuchColumnException("No such column: " + index);
        }
        return new GeneratedIdValueObject(this.insertId);
    }

    @Override
    public ValueObject getValueObject(String columnName) throws NoSuchColumnException {
        if (!columnName.toLowerCase().equals("insert_id")) {
            throw new NoSuchColumnException("No such column: " + columnName);
        }
        return new GeneratedIdValueObject(this.insertId + (long)this.rowPointer - 1L);
    }

    @Override
    public int getRows() {
        return (int)this.rows;
    }

    @Override
    public int getColumnId(String columnLabel) throws NoSuchColumnException {
        if (columnLabel.equals("insert_id")) {
            return 0;
        }
        throw new NoSuchColumnException("No such column");
    }

    @Override
    public void moveRowPointerTo(int i) {
    }

    @Override
    public int getRowPointer() {
        return this.rowPointer;
    }

    @Override
    public boolean next() {
        return (long)this.rowPointer++ < this.rows;
    }

    @Override
    public List<ColumnInformation> getColumnInformation() {
        return Arrays.asList(new MySQLColumnInformation.Builder().flags(EnumSet.of(ColumnFlags.PRIMARY_KEY, ColumnFlags.AUTO_INCREMENT)).name("insert_id").type(new MySQLType(MySQLType.Type.LONG)).build());
    }

    @Override
    public ResultSetType getResultSetType() {
        return ResultSetType.SELECT;
    }

    @Override
    public void close() {
    }

    @Override
    public short getWarnings() {
        return 0;
    }

    @Override
    public String getMessage() {
        return null;
    }
}

