/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class DateParameter
implements ParameterHolder {
    private final byte[] byteRepresentation;

    public DateParameter(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        this.byteRepresentation = String.valueOf("'" + sdf.format(new Date(timestamp)) + "'").getBytes();
    }

    public DateParameter(long timestamp, Calendar cal) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setCalendar(cal);
        this.byteRepresentation = String.valueOf("'" + sdf.format(new Date(timestamp)) + "'").getBytes();
    }

    public int writeTo(OutputStream os, int offset, int maxWriteSize) throws IOException {
        int bytesToWrite = Math.min(this.byteRepresentation.length - offset, maxWriteSize);
        os.write(this.byteRepresentation, offset, bytesToWrite);
        return bytesToWrite;
    }

    public long length() {
        return this.byteRepresentation.length;
    }
}

