/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query;

import java.util.concurrent.ConcurrentHashMap;
import org.drizzle.jdbc.internal.common.query.DrizzleParameterizedQuery;
import org.drizzle.jdbc.internal.common.query.DrizzleQuery;
import org.drizzle.jdbc.internal.common.query.ParameterizedQuery;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.common.query.QueryFactory;

public class DrizzleQueryFactory
implements QueryFactory {
    private static final ConcurrentHashMap<String, ParameterizedQuery> PREPARED_CACHE = new ConcurrentHashMap();

    public Query createQuery(String query) {
        return new DrizzleQuery(query);
    }

    public DrizzleQuery createQuery(byte[] query) {
        return new DrizzleQuery(query);
    }

    public ParameterizedQuery createParameterizedQuery(String query, boolean noCache) {
        if (noCache) {
            return new DrizzleParameterizedQuery(new DrizzleParameterizedQuery(query));
        }
        ParameterizedQuery pq = PREPARED_CACHE.get(query);
        if (pq == null) {
            pq = new DrizzleParameterizedQuery(query);
            PREPARED_CACHE.put(query, pq);
            return pq;
        }
        return new DrizzleParameterizedQuery(pq);
    }

    public ParameterizedQuery createParameterizedQuery(ParameterizedQuery dQuery) {
        return new DrizzleParameterizedQuery(dQuery);
    }
}

