/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.query.IllegalParameterException;
import org.drizzle.jdbc.internal.common.query.ParameterizedQuery;
import org.drizzle.jdbc.internal.common.query.QueryType;
import org.drizzle.jdbc.internal.common.query.parameters.ParameterHolder;

public class DrizzleParameterizedQuery
implements ParameterizedQuery {
    private ParameterHolder[] parameters;
    private final int paramCount;
    private final String query;
    private final byte[][] queryPartsArray;

    public DrizzleParameterizedQuery(String query) {
        this.query = query;
        List<String> queryParts = Utils.createQueryParts(query);
        this.queryPartsArray = new byte[queryParts.size()][];
        for (int i = 0; i < queryParts.size(); ++i) {
            try {
                this.queryPartsArray[i] = queryParts.get(i).getBytes("UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF-8 not supported", e);
            }
        }
        this.paramCount = queryParts.size() - 1;
        this.parameters = new ParameterHolder[this.paramCount];
    }

    public DrizzleParameterizedQuery(ParameterizedQuery paramQuery) {
        this.query = paramQuery.getQuery();
        this.queryPartsArray = paramQuery.getQueryPartsArray();
        this.paramCount = this.queryPartsArray.length - 1;
        this.parameters = Arrays.copyOf(paramQuery.getParameters(), this.paramCount);
    }

    public void setParameter(int position, ParameterHolder parameter) throws IllegalParameterException {
        if (position < 0 || position >= this.paramCount) {
            throw new IllegalParameterException("No '?' on that position");
        }
        this.parameters[position] = parameter;
    }

    public ParameterHolder[] getParameters() {
        return this.parameters;
    }

    public void clearParameters() {
        this.parameters = new ParameterHolder[this.paramCount];
    }

    public int length() throws QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
        int length = 0;
        for (byte[] s : this.queryPartsArray) {
            length += s.length;
        }
        for (ParameterHolder ph : this.parameters) {
            try {
                length = (int)((long)length + ph.length());
            }
            catch (IOException e) {
                throw new QueryException("Could not calculate length of parameter: " + e.getMessage());
            }
        }
        return length;
    }

    public void writeTo(OutputStream os) throws IOException, QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        os.write(this.queryPartsArray[0]);
        for (int i = 1; i < this.queryPartsArray.length; ++i) {
            this.parameters[i - 1].writeTo(os, 0, Integer.MAX_VALUE);
            if (this.queryPartsArray[i].length == 0) continue;
            os.write(this.queryPartsArray[i]);
        }
    }

    public void writeTo(OutputStream ostream, int offset, int packLength) throws IOException, QueryException {
        if (this.containsNull(this.parameters)) {
            throw new QueryException("You need to set exactly " + this.paramCount + " parameters on the prepared statement");
        }
        if (this.queryPartsArray.length == 0) {
            throw new AssertionError((Object)"Invalid query, queryParts was empty");
        }
        int skipped = 0;
        int sendCounter = 0;
        if (this.queryPartsArray[0].length > offset) {
            ostream.write(this.queryPartsArray[0], offset, this.queryPartsArray[0].length);
            sendCounter = this.queryPartsArray[0].length;
        } else {
            skipped = this.queryPartsArray[0].length;
        }
        for (int i = 1; i < this.queryPartsArray.length; ++i) {
            ParameterHolder ph = this.parameters[i - 1];
            if (skipped < offset && (long)skipped + ph.length() > (long)offset) {
                int written = ph.writeTo(ostream, offset - skipped, packLength);
                skipped += offset - skipped;
                sendCounter += written;
            } else if (ph.length() + (long)skipped + (long)sendCounter > (long)offset) {
                sendCounter += ph.writeTo(ostream, 0, packLength - sendCounter);
            } else {
                skipped = (int)((long)skipped + ph.length());
            }
            if (sendCounter + skipped >= offset + packLength) {
                return;
            }
            if (this.queryPartsArray[i].length + sendCounter + skipped > offset) {
                ostream.write(this.queryPartsArray[i]);
                sendCounter += this.queryPartsArray[i].length;
            } else {
                skipped += this.queryPartsArray[i].length;
            }
            if (sendCounter < packLength) continue;
            return;
        }
    }

    private boolean containsNull(ParameterHolder[] parameters) {
        for (ParameterHolder ph : parameters) {
            if (ph != null) continue;
            return true;
        }
        return false;
    }

    public String getQuery() {
        return this.query;
    }

    public byte[][] getQueryPartsArray() {
        return this.queryPartsArray;
    }

    public QueryType getQueryType() {
        return QueryType.classifyQuery(this.query);
    }

    public int getParamCount() {
        return this.paramCount;
    }
}

