/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.commands;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.packet.CommandPacket;
import org.drizzle.jdbc.internal.common.packet.buffer.WriteBuffer;
import org.drizzle.jdbc.internal.common.query.Query;
import org.drizzle.jdbc.internal.mysql.MySQLProtocol;

public class StreamedQueryPacket
implements CommandPacket {
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private static final Logger log = Logger.getLogger(StreamedQueryPacket.class.getName());
    private static final int HEADER_LENGTH = 4;
    private final Query query;

    public StreamedQueryPacket(Query query) {
        this.query = query;
    }

    public int send(OutputStream ostream) throws IOException, QueryException {
        if (this.query.length() > 0xFFFFFB) {
            return this.sendSplittedQuery(ostream);
        }
        byte[] byteHeader = Utils.copyWithLength(WriteBuffer.intToByteArray(this.query.length() + 1), 5);
        byteHeader[3] = 0;
        byteHeader[4] = 3;
        ostream.write(byteHeader);
        this.query.writeTo(ostream);
        ostream.flush();
        return 0;
    }

    private int sendSplittedQuery(OutputStream ostream) throws QueryException, IOException {
        int remainingBytes = this.query.length();
        int offset = 0;
        int packetIndex = 0;
        while ((long)remainingBytes >= 0L) {
            int packLength = Math.min(remainingBytes, 0xFFFFFF);
            byte[] byteHeader = null;
            if (packetIndex == 0) {
                byteHeader = Utils.copyWithLength(WriteBuffer.intToByteArray(packLength), 5);
                byteHeader[4] = 3;
                --packLength;
            } else {
                byteHeader = Utils.copyWithLength(WriteBuffer.intToByteArray(packLength), 4);
            }
            byteHeader[3] = (byte)packetIndex;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Sending packet " + packetIndex + " with length = " + packLength + " / " + remainingBytes);
            }
            ostream.write(byteHeader);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Header is " + MySQLProtocol.hexdump(byteHeader, 0));
            }
            if (packLength > 0) {
                this.query.writeTo(ostream, offset, packLength);
            }
            ostream.flush();
            if (remainingBytes >= 0xFFFFFF) {
                remainingBytes -= packLength;
                offset += packLength;
                ++packetIndex;
                continue;
            }
            remainingBytes = -1;
        }
        return packetIndex;
    }
}

