/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class WriteBuffer {
    private final ByteBuffer byteBuffer;

    public WriteBuffer() {
        this.byteBuffer = ByteBuffer.allocate(1000).order(ByteOrder.LITTLE_ENDIAN);
    }

    public WriteBuffer(int bufferSize) {
        this.byteBuffer = ByteBuffer.allocate(bufferSize).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void assureBufferCapacity(int len) {
        if (this.byteBuffer.remaining() < len) {
            this.byteBuffer.limit(this.byteBuffer.capacity() * 2);
        }
    }

    public WriteBuffer writeByte(byte theByte) {
        this.assureBufferCapacity(1);
        this.byteBuffer.put(theByte);
        return this;
    }

    public WriteBuffer writeByteArray(byte[] bytes) {
        this.assureBufferCapacity(bytes.length);
        this.byteBuffer.put(bytes);
        return this;
    }

    public WriteBuffer writeBytes(byte theByte, int count) {
        for (int i = 0; i < count; ++i) {
            this.writeByte(theByte);
        }
        return this;
    }

    public WriteBuffer writeShort(short theShort) {
        this.assureBufferCapacity(2);
        this.byteBuffer.putShort(theShort);
        return this;
    }

    public WriteBuffer writeInt(int theInt) {
        this.assureBufferCapacity(4);
        this.byteBuffer.putInt(theInt);
        return this;
    }

    public WriteBuffer writeString(String str) {
        byte[] strBytes;
        try {
            strBytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 not supported", e);
        }
        return this.writeByteArray(strBytes);
    }

    public byte[] getLengthWithPacketSeq(byte packetNumber) {
        int length = this.getLength();
        byte[] lenArr = WriteBuffer.intToByteArray(length);
        lenArr[3] = packetNumber;
        return lenArr;
    }

    public byte[] getBuffer() {
        return this.byteBuffer.array();
    }

    public byte[] toByteArrayWithLength(byte packetNumber) {
        int length = this.byteBuffer.capacity() - this.byteBuffer.remaining();
        ByteBuffer returnBuffer = ByteBuffer.allocate(length + 4);
        byte[] lenArr = WriteBuffer.intToByteArray(length);
        lenArr[3] = packetNumber;
        returnBuffer.put(lenArr);
        returnBuffer.put(this.byteBuffer.array(), 0, length);
        return returnBuffer.array();
    }

    public static byte[] intToByteArray(int l) {
        byte[] returnArray = new byte[]{(byte)(l & 0xFF), (byte)(l >>> 8), (byte)(l >>> 16), (byte)(l >>> 24)};
        return returnArray;
    }

    public static byte[] longToByteArray(long l) {
        byte[] returnArray = new byte[8];
        returnArray[0] = (byte)(l & 0xFFL);
        returnArray[1] = (byte)(l >>> 8);
        returnArray[2] = (byte)(l >>> 16);
        returnArray[3] = (byte)(l >>> 24);
        returnArray[0] = (byte)(l >>> 32);
        returnArray[1] = (byte)(l >>> 40);
        returnArray[2] = (byte)(l >>> 48);
        returnArray[3] = (byte)(l >>> 56);
        return returnArray;
    }

    public int getLength() {
        return this.byteBuffer.capacity() - this.byteBuffer.remaining();
    }
}

