/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common.packet.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.drizzle.jdbc.internal.common.packet.RawPacket;

public final class ReadUtil {
    private ReadUtil() {
    }

    public static int safeRead(InputStream inputStream, byte[] buffer) throws IOException {
        int readBytes = inputStream.read(buffer);
        if (readBytes == -1) {
            return -1;
        }
        if (readBytes < buffer.length) {
            int offset = readBytes;
            int left = buffer.length;
            left -= readBytes;
            do {
                try {
                    int nr = inputStream.read(buffer, offset, left);
                    if (nr == -1) {
                        return nr;
                    }
                    offset += nr;
                    left -= nr;
                }
                catch (InterruptedIOException interruptedIOException) {
                    // empty catch block
                }
            } while (left > 0);
        }
        return buffer.length;
    }

    public static boolean eofIsNext(RawPacket rawPacket) {
        ByteBuffer buf = rawPacket.getByteBuffer();
        return buf.get(0) == -2 && buf.capacity() < 9;
    }

    public static boolean isErrorPacket(RawPacket rawPacket) {
        return rawPacket.getByteBuffer().get(0) == -1;
    }
}

