/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc.internal.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final int START_BIT_MILLISECONDS = 17;
    private static final int START_BIT_SECONDS = 11;
    private static final int START_BIT_MINUTES = 5;
    private static final int MASK_HOURS = 31;
    private static final int MASK_MINUTES = 2016;
    private static final int MASK_SECONDS = 129024;
    private static final int MASK_MILLISECONDS = -131072;
    private static boolean java5Determined = false;
    private static boolean isJava5 = false;

    public static boolean needsEscaping(byte b) {
        if ((b & 0x80) == 0) {
            switch (b) {
                case 0: 
                case 10: 
                case 13: 
                case 26: 
                case 34: 
                case 39: 
                case 92: {
                    return true;
                }
            }
        }
        return false;
    }

    public static String sqlEscapeString(String str) {
        StringBuilder buffer = new StringBuilder(str.length() * 2);
        boolean neededEscaping = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Utils.needsEscaping((byte)c)) {
                neededEscaping = true;
                buffer.append('\\');
            }
            buffer.append(c);
        }
        return neededEscaping ? buffer.toString() : str;
    }

    public static int countChars(String str, char chr) {
        int count = 0;
        boolean isWithinDoubleQuotes = false;
        boolean isWithinQuotes = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinDoubleQuotes = true;
            } else if (c == '\"' && !isWithinQuotes) {
                isWithinDoubleQuotes = false;
            }
            if (c == '\'' && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinQuotes = true;
            } else if (c == '\'' && !isWithinDoubleQuotes) {
                isWithinQuotes = false;
            }
            if (isWithinDoubleQuotes || isWithinQuotes || chr != c) continue;
            ++count;
        }
        return count;
    }

    public static List<String> createQueryParts(String query) {
        boolean isWithinDoubleQuotes = false;
        boolean isWithinQuotes = false;
        int queryPos = 0;
        int lastQueryPos = 0;
        LinkedList<String> queryParts = new LinkedList<String>();
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (c == '\"' && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinDoubleQuotes = true;
            } else if (c == '\"' && !isWithinQuotes) {
                isWithinDoubleQuotes = false;
            }
            if (c == '\'' && !isWithinQuotes && !isWithinDoubleQuotes) {
                isWithinQuotes = true;
            } else if (c == '\'' && !isWithinDoubleQuotes) {
                isWithinQuotes = false;
            }
            if (!isWithinDoubleQuotes && !isWithinQuotes && c == '?') {
                queryParts.add(query.substring(lastQueryPos, queryPos));
                lastQueryPos = queryPos + 1;
            }
            ++queryPos;
        }
        queryParts.add(query.substring(lastQueryPos, queryPos));
        return queryParts;
    }

    public static String stripQuery(String query) {
        StringBuilder sb = new StringBuilder();
        ParsingState parsingState = ParsingState.NORMAL;
        ParsingState nextParsingState = ParsingState.NORMAL;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            int nextCodePoint = 0;
            if (i < query.length() - 1) {
                nextCodePoint = query.codePointAt(i + 1);
            }
            switch (parsingState) {
                case WITHIN_DOUBLE_QUOTES: {
                    if (c != '\"') break;
                    nextParsingState = ParsingState.NORMAL;
                    break;
                }
                case WITHIN_QUOTES: {
                    if (c != '\'') break;
                    nextParsingState = ParsingState.NORMAL;
                    break;
                }
                case NORMAL: {
                    if (c == '\'') {
                        nextParsingState = ParsingState.WITHIN_QUOTES;
                        break;
                    }
                    if (c == '\"') {
                        nextParsingState = ParsingState.WITHIN_DOUBLE_QUOTES;
                        break;
                    }
                    if (c == '/' && nextCodePoint == 42) {
                        nextParsingState = ParsingState.WITHIN_COMMENT;
                        parsingState = ParsingState.WITHIN_COMMENT;
                        break;
                    }
                    if (c != '#') break;
                    return sb.toString();
                }
                case WITHIN_COMMENT: {
                    if (c != '*' || nextCodePoint != 47) break;
                    nextParsingState = ParsingState.NORMAL;
                    ++i;
                }
            }
            if (parsingState != ParsingState.WITHIN_COMMENT) {
                sb.append(c);
            }
            parsingState = nextParsingState;
        }
        return sb.toString();
    }

    public static byte[] encryptPassword(String password, byte[] seed) throws NoSuchAlgorithmException {
        if (password == null || password.equals("")) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] stage1 = messageDigest.digest(password.getBytes());
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static int packTime(long milliseconds) {
        int millis = (int)(milliseconds % 1000L);
        int seconds = (int)(milliseconds / 1000L % 60L);
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L % 24L);
        return millis * 131072 + seconds * 2048 + minutes * 32 + hours;
    }

    public static long unpackTime(int packedTime) {
        int hours = packedTime & 0x1F;
        int minutes = (packedTime & 0x7E0) >> 5;
        int seconds = (packedTime & 0x1F800) >> 11;
        int millis = (packedTime & 0xFFFE0000) >> 17;
        long returnValue = (long)hours * 60L * 60L * 1000L;
        returnValue += (long)minutes * 60L * 1000L;
        returnValue += (long)seconds * 1000L;
        return returnValue += (long)millis;
    }

    public static byte[] copyWithLength(byte[] orig, int length) {
        byte[] result = new byte[length];
        int howMuchToCopy = length < orig.length ? length : orig.length;
        System.arraycopy(orig, 0, result, 0, howMuchToCopy);
        return result;
    }

    public static byte[] copyRange(byte[] orig, int from, int to) {
        int length = to - from;
        byte[] result = new byte[length];
        int howMuchToCopy = orig.length - from < length ? orig.length - from : length;
        System.arraycopy(orig, from, result, 0, howMuchToCopy);
        return result;
    }

    public static boolean isJava5() {
        if (!java5Determined) {
            try {
                Arrays.copyOf(new byte[0], 0);
                isJava5 = false;
            }
            catch (NoSuchMethodError e) {
                isJava5 = true;
            }
            java5Determined = true;
        }
        return isJava5;
    }

    public static short byteArrayToShort(byte[] b) {
        int value = Utils.byteArrayToInt(b);
        if (value > Short.MAX_VALUE) {
            return Short.MAX_VALUE;
        }
        if (value < Short.MIN_VALUE) {
            return Short.MIN_VALUE;
        }
        return (short)value;
    }

    public static byte byteArrayToByte(byte[] b) {
        int value = Utils.byteArrayToInt(b);
        if (value > 127) {
            return 127;
        }
        if (value < -128) {
            return -128;
        }
        return (byte)value;
    }

    public static int byteArrayToInt(byte[] b) {
        byte x;
        int sum = 0;
        int len = b.length;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 46) continue;
            len = i;
            break;
        }
        int limit = -2147483647;
        int startIdx = 0;
        boolean isPositive = true;
        if (len > 1 && ((x = (byte)(b[0] - 48)) < 0 || x > 9)) {
            if (b[0] == 43) {
                isPositive = true;
                limit = -2147483647;
                ++startIdx;
            } else if (b[0] == 45) {
                isPositive = false;
                limit = Integer.MIN_VALUE;
                ++startIdx;
            }
        }
        int factor = (int)Math.pow(10.0, len - 1 - startIdx);
        for (int i = startIdx; i < len; ++i) {
            int oldSum;
            byte x2 = (byte)(b[i] - 48);
            if (x2 < 0 || x2 > 9) {
                throw new NumberFormatException("Could not parse as int");
            }
            if ((sum -= x2 * factor) > (oldSum = sum) || sum < limit) {
                if (isPositive) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MIN_VALUE;
            }
            factor /= 10;
        }
        return isPositive ? -sum : sum;
    }

    public static long byteArrayToLong(byte[] b) {
        byte x;
        long sum = 0L;
        int len = b.length;
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 46) continue;
            len = i;
            break;
        }
        long limit = -9223372036854775807L;
        int startIdx = 0;
        boolean isPositive = true;
        if (len > 1 && ((x = (byte)(b[0] - 48)) < 0 || x > 9)) {
            if (b[0] == 43) {
                isPositive = true;
                limit = -9223372036854775807L;
                ++startIdx;
            } else if (b[0] == 45) {
                isPositive = false;
                limit = Long.MIN_VALUE;
                ++startIdx;
            }
        }
        long factor = (long)Math.pow(10.0, len - 1 - startIdx);
        for (int i = startIdx; i < len; ++i) {
            long oldSum;
            byte x2 = (byte)(b[i] - 48);
            if (x2 < 0 || x2 > 9) {
                throw new NumberFormatException("Could not parse as long");
            }
            if ((sum -= (long)x2 * factor) > (oldSum = sum) || sum < limit) {
                if (isPositive) {
                    return Long.MAX_VALUE;
                }
                return Long.MIN_VALUE;
            }
            factor /= 10L;
        }
        return isPositive ? -sum : sum;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParsingState {
        WITHIN_COMMENT,
        WITHIN_QUOTES,
        WITHIN_DOUBLE_QUOTES,
        NORMAL;

    }
}

