/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.drizzle.jdbc.CommonDatabaseMetaData;
import org.drizzle.jdbc.internal.SQLExceptionMapper;

public class DrizzleDataBaseMetaData
extends CommonDatabaseMetaData {
    public DrizzleDataBaseMetaData(CommonDatabaseMetaData.Builder builder) {
        super(builder);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT null TABLE_CAT, columns.table_schema TABLE_SCHEM, columns.table_name, columns.column_name, kcu.ordinal_position KEY_SEQ,null pk_name FROM information_schema.columns INNER JOIN information_schema.key_column_usage kcu ON kcu.constraint_schema = columns.table_schema AND columns.table_name = kcu.table_name AND columns.column_name = kcu.column_name WHERE columns.table_name='" + table + "' AND kcu.constraint_name='PRIMARY'";
        if (schema != null) {
            query = query + " AND columns.table_schema = '" + schema + "'";
        }
        query = query + " ORDER BY columns.column_name";
        Statement stmt = this.getConnection().createStatement();
        return stmt.executeQuery(query);
    }

    private String mapTableTypes(String tableType) {
        if (tableType.equals("TABLE")) {
            return "BASE TABLE";
        }
        if (tableType.equals("SYSTEM VIEW")) {
            return "VIEW";
        }
        return tableType;
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String query = "SELECT table_catalog table_cat, table_schema table_schem, table_name, table_type, 'remarks' as remarks,null as type_cat, null as type_schem,null as type_name, null as self_referencing_col_name,null as ref_generation FROM information_schema.tables WHERE table_name LIKE \"" + (tableNamePattern == null ? "%" : tableNamePattern) + "\"" + this.getSchemaPattern(schemaPattern);
        if (types != null) {
            query = query + " AND table_type in (";
            boolean first = true;
            for (String s : types) {
                String mappedType = this.mapTableTypes(s);
                if (!first) {
                    query = query + ",";
                }
                first = false;
                query = query + "'" + mappedType + "'";
            }
            query = query + ")";
        }
        Statement stmt = this.getConnection().createStatement();
        return stmt.executeQuery(query);
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String query = "     SELECT null as table_cat,            table_schema as table_schem,            table_name,            column_name, CASE data_type WHEN 'int' THEN 4 WHEN 'mediumint' THEN 4 WHEN 'varchar' THEN 12 WHEN 'datetime' THEN 93 WHEN 'date' THEN 91 WHEN 'time' THEN 92 WHEN 'text' THEN 12 WHEN 'bigint' THEN -5 WHEN 'varbinary' THEN -3 WHEN 'timestamp' THEN 93 WHEN 'double' THEN 8 WHEN 'bit' THEN -7 END data_type,            data_type type_name,            character_maximum_length column_size,            0 buffer_length,            numeric_precision decimal_digits,            numeric_scale num_prec_radix,            if(is_nullable='yes',1,0) nullable,            'remarks' remarks,            column_default column_def,            0 sql_data,            0 sql_datetime_sub,            character_octet_length char_octet_length,            ordinal_position,            is_nullable,            null scope_catalog,            null scope_schema,            null scope_table,            null source_data_type,            '' is_autoincrement    FROM information_schema.columns WHERE table_schema LIKE '" + (schemaPattern == null ? "%" : schemaPattern) + "' AND table_name LIKE '" + (tableNamePattern == null ? "%" : tableNamePattern) + "' AND column_name LIKE '" + (columnNamePattern == null ? "%" : columnNamePattern) + "' ORDER BY table_cat, table_schem, table_name, ordinal_position";
        Statement stmt = this.getConnection().createStatement();
        return stmt.executeQuery(query);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT null PKTABLE_CAT,\n       fk.constraint_schema PKTABLE_SCHEM,\n       fk.referenced_table_name PKTABLE_NAME,\n       replace(fk.referenced_table_columns,'`','') PKCOLUMN_NAME,\n       null FKTABLE_CAT,\n       fk.constraint_schema FKTABLE_SCHEM,\n       fk.constraint_table FKTABLE_NAME,\n       replace(fk.constraint_columns,'`','') FKCOLUMN_NAME,\n       1 KEY_SEQ,\n       CASE update_rule\n            WHEN 'RESTRICT' THEN 1\n            WHEN 'NO ACTION' THEN 3\n            WHEN 'CASCADE' THEN 0\n            WHEN 'SET NULL' THEN 2\n            WHEN 'SET DEFAULT' THEN 4\n       END UPDATE_RULE,\n       CASE delete_rule\n            WHEN 'RESTRICT' THEN 1\n            WHEN 'NO ACTION' THEN 3\n            WHEN 'CASCADE' THEN 0\n            WHEN 'SET NULL' THEN 2\n            WHEN 'SET DEFAULT' THEN 4\n       END DELETE_RULE,\n       fk.constraint_name FK_NAME,\n       null PK_NAME,\n       6 DEFERRABILITY\nFROM data_dictionary.foreign_keys fk WHERE " + (schema != null ? "fk.constraint_schema='" + schema + "' AND " : "") + "fk.referenced_table_name='" + table + "' ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        Statement stmt = this.getConnection().createStatement();
        return stmt.executeQuery(query);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT null PKTABLE_CAT,\nfk.constraint_schema PKTABLE_SCHEM,\nfk.referenced_table_name PKTABLE_NAME,\nreplace(fk.referenced_table_columns,'`','') PKCOLUMN_NAME,\nnull FKTABLE_CAT,\nfk.constraint_schema FKTABLE_SCHEM,\nfk.constraint_table FKTABLE_NAME,\nreplace(fk.constraint_columns,'`','') FKCOLUMN_NAME,\n1 KEY_SEQ,\nCASE update_rule\n   WHEN 'RESTRICT' THEN 1\n   WHEN 'NO ACTION' THEN 3\n   WHEN 'CASCADE' THEN 0\n   WHEN 'SET NULL' THEN 2\n   WHEN 'SET DEFAULT' THEN 4\nEND UPDATE_RULE,\nCASE delete_rule\n   WHEN 'RESTRICT' THEN 1\n   WHEN 'NO ACTION' THEN 3\n   WHEN 'CASCADE' THEN 0\n   WHEN 'SET NULL' THEN 2\n   WHEN 'SET DEFAULT' THEN 4\nEND DELETE_RULE,\nfk.constraint_name FK_NAME,\nnull PK_NAME,\n6 DEFERRABILITY\nFROM data_dictionary.foreign_keys fk WHERE " + (schema != null ? "fk.constraint_schema='" + schema + "' AND " : "") + "fk.constraint_table='" + table + "'ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ";
        Statement stmt = this.getConnection().createStatement();
        return stmt.executeQuery(query);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String query = "SELECT 2 scope,column_name, CASE data_type WHEN 'int' THEN 4 WHEN 'mediumint' THEN 4 WHEN 'varchar' THEN 12 WHEN 'datetime' THEN 93 WHEN 'date' THEN 91 WHEN 'time' THEN 92 WHEN 'text' THEN 12 WHEN 'bigint' THEN -5 WHEN 'varbinary' THEN -3 WHEN 'timestamp' THEN 93 WHEN 'double' THEN 8 WHEN 'bit' THEN -7 END data_type,data_type type_name,if(numeric_precision is null, character_maximum_length, numeric_precision) column_size,0 buffer_length,numeric_scale decimal_digits,1 pseudo_column FROM data_dictionary.columns WHERE is_indexed = 'YES' OR is_used_in_primary = 'YES' OR is_unique = 'YES' AND table_schema like " + (schema != null ? "'%'" : "'" + schema + "'") + " AND table_name='" + table + "' ORDER BY scope";
        Statement stmt = this.getConnection().createStatement();
        return stmt.executeQuery(query);
    }

    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("getPseudoColumns");
    }

    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }
}

