/*
 * Decompiled with CFR 0.152.
 */
package org.drizzle.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.drizzle.jdbc.CommonDatabaseMetaData;
import org.drizzle.jdbc.DrizzleBlob;
import org.drizzle.jdbc.DrizzlePreparedStatement;
import org.drizzle.jdbc.DrizzleSavepoint;
import org.drizzle.jdbc.DrizzleStatement;
import org.drizzle.jdbc.ReplicationConnection;
import org.drizzle.jdbc.internal.SQLExceptionMapper;
import org.drizzle.jdbc.internal.common.BinlogDumpException;
import org.drizzle.jdbc.internal.common.DefaultParameterizedBatchHandlerFactory;
import org.drizzle.jdbc.internal.common.ParameterizedBatchHandlerFactory;
import org.drizzle.jdbc.internal.common.Protocol;
import org.drizzle.jdbc.internal.common.QueryException;
import org.drizzle.jdbc.internal.common.Utils;
import org.drizzle.jdbc.internal.common.packet.RawPacket;
import org.drizzle.jdbc.internal.common.query.QueryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DrizzleConnection
implements Connection,
ReplicationConnection {
    private final Protocol protocol;
    private int savepointCount = 0;
    private final Properties clientInfoProperties;
    private final QueryFactory queryFactory;
    private ParameterizedBatchHandlerFactory parameterizedBatchHandlerFactory;
    private final ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor();

    public DrizzleConnection(Protocol protocol, QueryFactory queryFactory) {
        this.protocol = protocol;
        this.clientInfoProperties = new Properties();
        this.queryFactory = queryFactory;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new DrizzleStatement(this.protocol, this, this.queryFactory);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.parameterizedBatchHandlerFactory == null) {
            this.parameterizedBatchHandlerFactory = new DefaultParameterizedBatchHandlerFactory();
        }
        String strippedQuery = Utils.stripQuery(sql);
        return new DrizzlePreparedStatement(this.protocol, this, strippedQuery, this.queryFactory, this.parameterizedBatchHandlerFactory.get(strippedQuery, this.protocol));
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Stored procedures not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        Statement stmt = this.createStatement();
        String clause = autoCommit ? "1" : "0";
        stmt.executeUpdate("set autocommit=" + clause);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select @@autocommit");
        rs.next();
        boolean autocommit = rs.getBoolean(1);
        rs.close();
        stmt.close();
        return autocommit;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Connection abort");
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.protocol.commit();
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.protocol.rollback();
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.timeoutExecutor.shutdown();
            this.protocol.close();
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.protocol.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new CommonDatabaseMetaData.Builder(this.protocol.getDatabaseType(), this).url("jdbc:drizzle://" + this.protocol.getHost() + ":" + this.protocol.getPort() + "/" + this.protocol.getDatabase()).username(this.protocol.getUsername()).version(this.protocol.getServerVersion()).databaseProductName(this.protocol.getDatabaseType().getDatabaseName()).build();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.protocol.setReadonly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.protocol.setCatalog(catalog);
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            return this.protocol.getCatalog();
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String query = "SET SESSION TRANSACTION ISOLATION LEVEL";
        switch (level) {
            case 1: {
                query = query + " READ UNCOMMITTED";
                break;
            }
            case 2: {
                query = query + " READ COMMITTED";
                break;
            }
            case 4: {
                query = query + " REPEATABLE READ";
                break;
            }
            case 8: {
                query = query + " SERIALIZABLE";
                break;
            }
            default: {
                throw SQLExceptionMapper.getSQLException("Unsupported transaction isolation level");
            }
        }
        try {
            this.protocol.executeQuery(this.queryFactory.createQuery(query));
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            ResultSet rs = stmt.executeQuery("SELECT @@tx_isolation");
            rs.next();
            String response = rs.getString(1);
            if (response.equals("REPEATABLE-READ")) {
                int n = 4;
                return n;
            }
            if (response.equals("READ-UNCOMMITTED")) {
                int n = 1;
                return n;
            }
            if (response.equals("READ-COMMITTED")) {
                int n = 2;
                return n;
            }
            if (response.equals("SERIALIZABLE")) {
                int n = 8;
                return n;
            }
        }
        finally {
            stmt.close();
        }
        throw SQLExceptionMapper.getSQLException("Could not get transaction isolation level");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Stored procedures not supported");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 1) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Only holding cursors over commit is supported");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint("unnamed");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        DrizzleSavepoint drizzleSavepoint = new DrizzleSavepoint(name, this.savepointCount++);
        try {
            this.protocol.setSavepoint(((Object)drizzleSavepoint).toString());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
        return drizzleSavepoint;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.protocol.rollback(savepoint.toString());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.protocol.releaseSavepoint(savepoint.toString());
        }
        catch (QueryException e) {
            throw SQLExceptionMapper.get(e);
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Only read-only result sets allowed");
        }
        if (resultSetHoldability != 1) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors are always kept when sending commit (they are only client-side)");
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Only read-only result sets allowed");
        }
        if (resultSetHoldability != 1) {
            throw SQLExceptionMapper.getFeatureNotSupportedException("Cursors are always kept when sending commit (they are only client-side)");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Prepared statements are not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes != null && columnIndexes.length == 1 && columnIndexes[0] == 1) {
            return this.prepareStatement(sql);
        }
        throw SQLExceptionMapper.getSQLException("Only one auto generated key is supported, and it is on position 1");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames != null && columnNames.length == 1 && columnNames[0].equals("insert_id")) {
            return this.prepareStatement(sql);
        }
        throw SQLExceptionMapper.getSQLException("Only one auto generated key is supported, and it is called insert_id");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        return new DrizzleBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("NClobs not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Negative timeout supplied");
        }
        try {
            return this.protocol.ping();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfoProperties.setProperty(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        for (String key : properties.stringPropertyNames()) {
            this.clientInfoProperties.setProperty(key, properties.getProperty(key));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfoProperties.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfoProperties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Not yet supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public String getUsername() {
        return this.protocol.getUsername();
    }

    public String getPassword() {
        return this.protocol.getPassword();
    }

    public String getHostname() {
        return this.protocol.getHost();
    }

    public int getPort() {
        return this.protocol.getPort();
    }

    public String getDatabase() {
        return this.protocol.getDatabase();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw SQLExceptionMapper.getFeatureNotSupportedException("Connection setNetworkTimeout");
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public List<RawPacket> startBinlogDump(int position, String logfile) throws SQLException {
        try {
            return this.protocol.startBinlogDump(position, logfile);
        }
        catch (BinlogDumpException e) {
            throw SQLExceptionMapper.getSQLException("Could not dump binlog", e);
        }
    }

    public void setBatchQueryHandlerFactory(ParameterizedBatchHandlerFactory batchHandlerFactory) {
        this.parameterizedBatchHandlerFactory = batchHandlerFactory;
    }

    protected ScheduledExecutorService getTimeoutExecutor() {
        return this.timeoutExecutor;
    }
}

