/*
 *  Copyright 2007-2008, Plutext Pty Ltd.
 *   
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


package org.docx4j.vml.spreadsheetDrawing;

import java.math.BigInteger;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlRegistry;
import javax.xml.namespace.QName;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the org.docx4j.vml.spreadsheetDrawing package. 
 * <p>An ObjectFactory allows you to programatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {

    private final static QName _ClientData_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ClientData");
    private final static QName _CTClientDataDx_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Dx");
    private final static QName _CTClientDataDismiss_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Dismiss");
    private final static QName _CTClientDataDDE_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "DDE");
    private final static QName _CTClientDataCamera_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Camera");
    private final static QName _CTClientDataDefault_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Default");
    private final static QName _CTClientDataLCT_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "LCT");
    private final static QName _CTClientDataTextVAlign_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "TextVAlign");
    private final static QName _CTClientDataUIObj_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "UIObj");
    private final static QName _CTClientDataFirstButton_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "FirstButton");
    private final static QName _CTClientDataLocked_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Locked");
    private final static QName _CTClientDataChecked_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Checked");
    private final static QName _CTClientDataScriptLocation_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ScriptLocation");
    private final static QName _CTClientDataRow_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Row");
    private final static QName _CTClientDataFmlaTxbx_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "FmlaTxbx");
    private final static QName _CTClientDataAnchor_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Anchor");
    private final static QName _CTClientDataDefaultSize_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "DefaultSize");
    private final static QName _CTClientDataColumn_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Column");
    private final static QName _CTClientDataRecalcAlways_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "RecalcAlways");
    private final static QName _CTClientDataListItem_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ListItem");
    private final static QName _CTClientDataVisible_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Visible");
    private final static QName _CTClientDataPrintObject_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "PrintObject");
    private final static QName _CTClientDataAutoFill_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "AutoFill");
    private final static QName _CTClientDataDropLines_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "DropLines");
    private final static QName _CTClientDataAutoPict_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "AutoPict");
    private final static QName _CTClientDataSizeWithCells_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "SizeWithCells");
    private final static QName _CTClientDataMin_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Min");
    private final static QName _CTClientDataFmlaGroup_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "FmlaGroup");
    private final static QName _CTClientDataRowHidden_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "RowHidden");
    private final static QName _CTClientDataScriptExtended_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ScriptExtended");
    private final static QName _CTClientDataNoThreeD2_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "NoThreeD2");
    private final static QName _CTClientDataPage_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Page");
    private final static QName _CTClientDataDisabled_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Disabled");
    private final static QName _CTClientDataAccel_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Accel");
    private final static QName _CTClientDataVTEdit_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "VTEdit");
    private final static QName _CTClientDataInc_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Inc");
    private final static QName _CTClientDataFmlaPict_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "FmlaPict");
    private final static QName _CTClientDataSelType_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "SelType");
    private final static QName _CTClientDataSel_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Sel");
    private final static QName _CTClientDataHoriz_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Horiz");
    private final static QName _CTClientDataTextHAlign_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "TextHAlign");
    private final static QName _CTClientDataJustLastX_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "JustLastX");
    private final static QName _CTClientDataVal_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Val");
    private final static QName _CTClientDataAutoLine_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "AutoLine");
    private final static QName _CTClientDataCF_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "CF");
    private final static QName _CTClientDataDropStyle_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "DropStyle");
    private final static QName _CTClientDataNoThreeD_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "NoThreeD");
    private final static QName _CTClientDataFmlaRange_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "FmlaRange");
    private final static QName _CTClientDataAccel2_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Accel2");
    private final static QName _CTClientDataColHidden_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ColHidden");
    private final static QName _CTClientDataMoveWithCells_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "MoveWithCells");
    private final static QName _CTClientDataMapOCX_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "MapOCX");
    private final static QName _CTClientDataSecretEdit_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "SecretEdit");
    private final static QName _CTClientDataFmlaLink_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "FmlaLink");
    private final static QName _CTClientDataVScroll_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "VScroll");
    private final static QName _CTClientDataFmlaMacro_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "FmlaMacro");
    private final static QName _CTClientDataMultiLine_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "MultiLine");
    private final static QName _CTClientDataLockText_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "LockText");
    private final static QName _CTClientDataColored_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Colored");
    private final static QName _CTClientDataAutoScale_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "AutoScale");
    private final static QName _CTClientDataMax_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Max");
    private final static QName _CTClientDataCancel_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Cancel");
    private final static QName _CTClientDataScriptText_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ScriptText");
    private final static QName _CTClientDataWidthMin_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "WidthMin");
    private final static QName _CTClientDataScriptLanguage_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ScriptLanguage");
    private final static QName _CTClientDataMultiSel_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "MultiSel");
    private final static QName _CTClientDataValidIds_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "ValidIds");
    private final static QName _CTClientDataHelp_QNAME = new QName("urn:schemas-microsoft-com:office:excel", "Help");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.docx4j.vml.spreadsheetDrawing
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link CTClientData }
     * 
     */
    public CTClientData createCTClientData() {
        return new CTClientData();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CTClientData }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ClientData")
    public JAXBElement<CTClientData> createClientData(CTClientData value) {
        return new JAXBElement<CTClientData>(_ClientData_QNAME, CTClientData.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Dx", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataDx(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataDx_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Dismiss", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataDismiss(String value) {
        return new JAXBElement<String>(_CTClientDataDismiss_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "DDE", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataDDE(String value) {
        return new JAXBElement<String>(_CTClientDataDDE_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Camera", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataCamera(String value) {
        return new JAXBElement<String>(_CTClientDataCamera_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Default", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataDefault(String value) {
        return new JAXBElement<String>(_CTClientDataDefault_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "LCT", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataLCT(String value) {
        return new JAXBElement<String>(_CTClientDataLCT_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "TextVAlign", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataTextVAlign(String value) {
        return new JAXBElement<String>(_CTClientDataTextVAlign_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "UIObj", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataUIObj(String value) {
        return new JAXBElement<String>(_CTClientDataUIObj_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "FirstButton", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataFirstButton(String value) {
        return new JAXBElement<String>(_CTClientDataFirstButton_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Locked", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataLocked(String value) {
        return new JAXBElement<String>(_CTClientDataLocked_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Checked", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataChecked(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataChecked_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ScriptLocation", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataScriptLocation(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataScriptLocation_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Row", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataRow(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataRow_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "FmlaTxbx", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataFmlaTxbx(String value) {
        return new JAXBElement<String>(_CTClientDataFmlaTxbx_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Anchor", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataAnchor(String value) {
        return new JAXBElement<String>(_CTClientDataAnchor_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "DefaultSize", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataDefaultSize(String value) {
        return new JAXBElement<String>(_CTClientDataDefaultSize_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Column", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataColumn(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataColumn_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "RecalcAlways", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataRecalcAlways(String value) {
        return new JAXBElement<String>(_CTClientDataRecalcAlways_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ListItem", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataListItem(String value) {
        return new JAXBElement<String>(_CTClientDataListItem_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Visible", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataVisible(String value) {
        return new JAXBElement<String>(_CTClientDataVisible_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "PrintObject", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataPrintObject(String value) {
        return new JAXBElement<String>(_CTClientDataPrintObject_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "AutoFill", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataAutoFill(String value) {
        return new JAXBElement<String>(_CTClientDataAutoFill_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "DropLines", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataDropLines(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataDropLines_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "AutoPict", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataAutoPict(String value) {
        return new JAXBElement<String>(_CTClientDataAutoPict_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "SizeWithCells", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataSizeWithCells(String value) {
        return new JAXBElement<String>(_CTClientDataSizeWithCells_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Min", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataMin(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataMin_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "FmlaGroup", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataFmlaGroup(String value) {
        return new JAXBElement<String>(_CTClientDataFmlaGroup_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "RowHidden", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataRowHidden(String value) {
        return new JAXBElement<String>(_CTClientDataRowHidden_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ScriptExtended", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataScriptExtended(String value) {
        return new JAXBElement<String>(_CTClientDataScriptExtended_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "NoThreeD2", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataNoThreeD2(String value) {
        return new JAXBElement<String>(_CTClientDataNoThreeD2_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Page", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataPage(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataPage_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Disabled", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataDisabled(String value) {
        return new JAXBElement<String>(_CTClientDataDisabled_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Accel", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataAccel(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataAccel_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "VTEdit", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataVTEdit(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataVTEdit_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Inc", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataInc(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataInc_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "FmlaPict", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataFmlaPict(String value) {
        return new JAXBElement<String>(_CTClientDataFmlaPict_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "SelType", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataSelType(String value) {
        return new JAXBElement<String>(_CTClientDataSelType_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Sel", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataSel(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataSel_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Horiz", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataHoriz(String value) {
        return new JAXBElement<String>(_CTClientDataHoriz_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "TextHAlign", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataTextHAlign(String value) {
        return new JAXBElement<String>(_CTClientDataTextHAlign_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "JustLastX", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataJustLastX(String value) {
        return new JAXBElement<String>(_CTClientDataJustLastX_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Val", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataVal(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataVal_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "AutoLine", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataAutoLine(String value) {
        return new JAXBElement<String>(_CTClientDataAutoLine_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link STCF }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "CF", scope = CTClientData.class)
    public JAXBElement<STCF> createCTClientDataCF(STCF value) {
        return new JAXBElement<STCF>(_CTClientDataCF_QNAME, STCF.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "DropStyle", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataDropStyle(String value) {
        return new JAXBElement<String>(_CTClientDataDropStyle_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "NoThreeD", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataNoThreeD(String value) {
        return new JAXBElement<String>(_CTClientDataNoThreeD_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "FmlaRange", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataFmlaRange(String value) {
        return new JAXBElement<String>(_CTClientDataFmlaRange_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Accel2", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataAccel2(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataAccel2_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ColHidden", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataColHidden(String value) {
        return new JAXBElement<String>(_CTClientDataColHidden_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "MoveWithCells", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataMoveWithCells(String value) {
        return new JAXBElement<String>(_CTClientDataMoveWithCells_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "MapOCX", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataMapOCX(String value) {
        return new JAXBElement<String>(_CTClientDataMapOCX_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "SecretEdit", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataSecretEdit(String value) {
        return new JAXBElement<String>(_CTClientDataSecretEdit_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "FmlaLink", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataFmlaLink(String value) {
        return new JAXBElement<String>(_CTClientDataFmlaLink_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "VScroll", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataVScroll(String value) {
        return new JAXBElement<String>(_CTClientDataVScroll_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "FmlaMacro", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataFmlaMacro(String value) {
        return new JAXBElement<String>(_CTClientDataFmlaMacro_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "MultiLine", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataMultiLine(String value) {
        return new JAXBElement<String>(_CTClientDataMultiLine_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "LockText", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataLockText(String value) {
        return new JAXBElement<String>(_CTClientDataLockText_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Colored", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataColored(String value) {
        return new JAXBElement<String>(_CTClientDataColored_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "AutoScale", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataAutoScale(String value) {
        return new JAXBElement<String>(_CTClientDataAutoScale_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Max", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataMax(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataMax_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Cancel", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataCancel(String value) {
        return new JAXBElement<String>(_CTClientDataCancel_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ScriptText", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataScriptText(String value) {
        return new JAXBElement<String>(_CTClientDataScriptText_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "WidthMin", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataWidthMin(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataWidthMin_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link BigInteger }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ScriptLanguage", scope = CTClientData.class)
    public JAXBElement<BigInteger> createCTClientDataScriptLanguage(BigInteger value) {
        return new JAXBElement<BigInteger>(_CTClientDataScriptLanguage_QNAME, BigInteger.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "MultiSel", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataMultiSel(String value) {
        return new JAXBElement<String>(_CTClientDataMultiSel_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "ValidIds", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataValidIds(String value) {
        return new JAXBElement<String>(_CTClientDataValidIds_QNAME, String.class, CTClientData.class, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link String }{@code >}}
     * 
     */
    @XmlElementDecl(namespace = "urn:schemas-microsoft-com:office:excel", name = "Help", scope = CTClientData.class)
    public JAXBElement<String> createCTClientDataHelp(String value) {
        return new JAXBElement<String>(_CTClientDataHelp_QNAME, String.class, CTClientData.class, value);
    }

}
