/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.XSLFO;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.configuration.Configuration;
import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.fo.renderers.FORendererApacheFOP;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XSLFOExporterNonXSLT {
    private static Logger log = LoggerFactory.getLogger(XSLFOExporterNonXSLT.class);
    protected static final int DEFAULT_OUTPUT_SIZE = 102400;
    FOSettings foSettings = null;

    public XSLFOExporterNonXSLT(WordprocessingMLPackage wmlPackage, FOSettings pdfSettings) {
        this.foSettings = pdfSettings;
        if (this.foSettings.getOpcPackage() == null && wmlPackage != null) {
            this.foSettings.setOpcPackage((OpcPackage)wmlPackage);
        }
    }

    public Document export() throws Docx4JException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(102400);
        Document ret = null;
        this.foSettings.setApacheFopMime("application/xml-fo");
        try {
            Docx4J.toFO((FOSettings)this.foSettings, (OutputStream)outStream, (int)2);
            ret = XmlUtils.getNewDocumentBuilder().parse(new ByteArrayInputStream(outStream.toByteArray()));
        }
        catch (Docx4JException e) {
            log.error("Exception exporting document: " + e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            log.error("Exception parsing document: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error("Exception parsing document: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    public void output(Document xslfo, OutputStream os, Configuration fopConfigZZZ) throws Docx4JException {
        FORenderer renderer = FORendererApacheFOP.getInstance();
        String foDocument = XmlUtils.w3CDomNodeToString((Node)xslfo);
        renderer.render(foDocument, this.foSettings, false, null, os);
    }
}

