/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.utils;

import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEventHandler;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.wml.P;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathAwareCloner {
    private static Logger log = LoggerFactory.getLogger(XPathAwareCloner.class);
    Object jaxbElement;
    private Binder<Node> binder;

    public Object deepCopy(Object o) {
        return this.deepCopy(o, Context.jc);
    }

    public Object deepCopy(Object o, JAXBContext jc) {
        if (o == null) {
            throw new IllegalArgumentException("Can't clone a null argument");
        }
        try {
            Document doc = XmlUtils.marshaltoW3CDomDocument(o, jc);
            this.binder = jc.createBinder();
            JaxbValidationEventHandler eventHandler = new JaxbValidationEventHandler();
            eventHandler.setContinue(false);
            this.binder.setEventHandler((ValidationEventHandler)eventHandler);
            this.jaxbElement = this.binder.unmarshal((Object)doc);
            return this.jaxbElement;
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public Binder<Node> getBinder() {
        return this.binder;
    }

    public List<Object> getJAXBNodesViaXPath(String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        return XmlUtils.getJAXBNodesViaXPath(this.binder, this.jaxbElement, xpathExpr, refreshXmlFirst);
    }

    public static void main(String[] args) throws JAXBException, XPathBinderAssociationIsPartialException {
        String pString = "<w:p xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:r><w:t xml:space=\"preserve\">Here is some text.</w:t></w:r><w:r><w:rPr><w:i/></w:rPr><w:t>An italic run.</w:t></w:r><w:r><w:rPr><w:i/></w:rPr><w:t xml:space=\"preserve\"></w:t></w:r><w:r><w:t>More stuff.</w:t></w:r><w:r><w:t xml:space=\"preserve\"></w:t></w:r><w:r><w:rPr><w:b/></w:rPr><w:t>More stuff.</w:t></w:r><w:r><w:t xml:space=\"preserve\"></w:t></w:r><w:r><w:t xml:space=\"preserve\">The run we are seeking.</w:t></w:r><w:r><w:rPr><w:b/></w:rPr><w:t>More stuff.</w:t></w:r><w:r><w:t xml:space=\"preserve\"></w:t></w:r><w:r><w:t>More stuff.</w:t></w:r></w:p>";
        P pIn = (P)XmlUtils.unmarshalString(pString);
        XPathAwareCloner cloner = new XPathAwareCloner();
        P clonedP = (P)cloner.deepCopy(pIn);
        List<Object> results = cloner.getJAXBNodesViaXPath("//w:r[contains( w:t, 'seeking')]", false);
        int i = 1;
        for (Object result : results) {
            System.out.println("\n\r" + i + ": " + XmlUtils.marshaltoString(result, true, true));
            ++i;
        }
    }
}

