/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.writer;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.writer.AbstractFldSimpleWriter;
import org.docx4j.convert.out.common.writer.AbstractHyperlinkWriterModel;
import org.docx4j.convert.out.common.writer.HyperlinkUtil;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractPagerefHandler
implements AbstractFldSimpleWriter.FldSimpleNodeWriterHandler {
    protected int outputType = -1;

    protected AbstractPagerefHandler(int outputType) {
        this.outputType = outputType;
    }

    @Override
    public String getName() {
        return "PAGEREF";
    }

    @Override
    public int getProcessType() {
        return 0;
    }

    @Override
    public Node toNode(AbstractWmlConversionContext context, FldSimpleModel model, Document doc) throws TransformerException {
        String bookmarkId = model.getFldParameters().get(0);
        Node content = model.getContent();
        Node literalNode = null;
        AbstractHyperlinkWriterModel hyperlinkModel = null;
        DocumentFragment docFrag = null;
        String textcontent = null;
        List<String> textcontentitems = null;
        String textcontentitem = null;
        if (FormattingSwitchHelper.hasSwitch("\\p", model.getFldParameters())) {
            textcontent = this.getTextcontent(content);
            textcontentitems = this.splitTextcontent(textcontent);
            if (textcontentitems != null) {
                docFrag = doc.createDocumentFragment();
                for (int i = 0; i < textcontentitems.size(); ++i) {
                    textcontentitem = textcontentitems.get(i);
                    if ("#".equals(textcontentitem)) {
                        docFrag.appendChild(this.createPageref(context, doc, bookmarkId));
                        continue;
                    }
                    literalNode = doc.createDocumentFragment();
                    XmlUtils.treeCopy(content, literalNode);
                    literalNode = literalNode.getFirstChild();
                    this.setTextcontent(literalNode, textcontentitem);
                    docFrag.appendChild(literalNode);
                }
                content = docFrag;
            }
        } else {
            content = doc.createDocumentFragment();
            content.appendChild(this.createPageref(context, doc, bookmarkId));
        }
        if (FormattingSwitchHelper.hasSwitch("\\h", model.getFldParameters())) {
            hyperlinkModel = new AbstractHyperlinkWriterModel();
            hyperlinkModel.build(context, model, content);
            content = HyperlinkUtil.toNode(this.outputType, context, hyperlinkModel, content, doc);
        }
        return content;
    }

    protected List<String> splitTextcontent(String textcontent) {
        ArrayList<String> ret = null;
        int endPos = -1;
        if (textcontent != null && textcontent.length() > 0) {
            int startPos;
            for (startPos = 0; startPos < textcontent.length() && !Character.isDigit(textcontent.charAt(startPos)); ++startPos) {
            }
            for (endPos = startPos + 1; endPos < textcontent.length() && Character.isDigit(textcontent.charAt(endPos)); ++endPos) {
            }
            if (startPos < endPos && endPos <= textcontent.length()) {
                ret = new ArrayList<String>();
                if (startPos > 0) {
                    ret.add(textcontent.substring(0, startPos));
                }
                ret.add("#");
                if (endPos < textcontent.length()) {
                    ret.add(textcontent.substring(endPos));
                }
            }
        }
        return ret;
    }

    protected String getTextcontent(Node root) {
        Node textNode = this.findTextNode(root);
        return textNode != null ? textNode.getNodeValue() : null;
    }

    protected void setTextcontent(Node root, String text) {
        Node textNode = this.findTextNode(root);
        if (textNode != null) {
            if (text.charAt(text.length() - 1) == ' ') {
                text = text.substring(0, text.length() - 1) + '\u00a0';
            }
            if (text.charAt(0) == ' ') {
                text = text.length() > 1 ? '\u00a0' + text.substring(1) : Character.toString('\u00a0');
            }
            textNode.setNodeValue(text);
        }
    }

    protected Node findTextNode(Node root) {
        Node ret = null;
        NodeList childNodes = null;
        Object childNode = null;
        switch (root.getNodeType()) {
            case 3: {
                ret = root.getNodeValue() != null && root.getNodeValue().length() > 0 ? root : null;
                break;
            }
            case 1: 
            case 9: 
            case 11: {
                childNodes = root.getChildNodes();
                for (int i = 0; ret == null && i < childNodes.getLength(); ++i) {
                    ret = this.findTextNode(childNodes.item(i));
                }
                break;
            }
        }
        return ret;
    }

    protected abstract Node createPageref(AbstractWmlConversionContext var1, Document var2, String var3);
}

