/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.packages;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.ProtectionSettings;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.org.apache.poi.poifs.crypt.HashAlgorithm;
import org.docx4j.utils.CompoundTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.STDocProtect;
import org.docx4j.wml.Tbl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectDocument
extends ProtectionSettings {
    protected static Logger log = LoggerFactory.getLogger(ProtectDocument.class);

    public ProtectDocument(WordprocessingMLPackage pkg) {
        super(pkg);
    }

    private WordprocessingMLPackage getPkg() {
        return (WordprocessingMLPackage)this.pkg;
    }

    public void restrictFormatting(List<String> allowedStyleNames, boolean removedNotAllowedFormatting, boolean autoFormatOverride, boolean styleLockTheme, boolean styleLockQFSet) throws Docx4JException {
        this.restrictFormatting(allowedStyleNames, removedNotAllowedFormatting, autoFormatOverride, styleLockTheme, styleLockQFSet, null, null);
    }

    public void restrictFormatting(List<String> allowedStyleNames, boolean removedNotAllowedFormatting, boolean autoFormatOverride, boolean styleLockTheme, boolean styleLockQFSet, String password) throws Docx4JException {
        this.restrictFormatting(allowedStyleNames, removedNotAllowedFormatting, autoFormatOverride, styleLockTheme, styleLockQFSet, password, HashAlgorithm.sha1);
    }

    public void restrictFormatting(List<String> allowedStyleNames, boolean removedNotAllowedFormatting, boolean autoFormatOverride, boolean styleLockTheme, boolean styleLockQFSet, String password, HashAlgorithm hashAlgo) throws Docx4JException {
        if (this.getPkg().getMainDocumentPart() == null) {
            throw new Docx4JException("No MainDocumentPart in this WordprocessingMLPackage");
        }
        if (this.getPkg().getMainDocumentPart().getStyleDefinitionsPart() == null) {
            throw new Docx4JException("No StyleDefinitionsPart in this WordprocessingMLPackage");
        }
        Set<String> stylesInUse = this.getPkg().getMainDocumentPart().getStylesInUse();
        StyleDefinitionsPart sdp = this.getPkg().getMainDocumentPart().getStyleDefinitionsPart();
        sdp.protectRestrictFormatting(allowedStyleNames, removedNotAllowedFormatting, stylesInUse);
        if (removedNotAllowedFormatting) {
            ArrayList<TraversalUtilVisitor> visitors = new ArrayList<TraversalUtilVisitor>();
            visitors.add(new VisitorRemovePFormatting(sdp, allowedStyleNames));
            visitors.add(new VisitorRemoveRFormatting(sdp, allowedStyleNames));
            visitors.add(new VisitorRemoveTableFormatting(sdp, allowedStyleNames));
            CompoundTraversalUtilVisitorCallback compound = new CompoundTraversalUtilVisitorCallback(visitors);
            for (Part p : this.getPkg().getParts().getParts().values()) {
                if (!(p instanceof ContentAccessor)) continue;
                compound.walkJAXBElements(((ContentAccessor)p).getContent());
            }
        }
        DocumentSettingsPart documentSettingsPart = this.getPkg().getMainDocumentPart().getDocumentSettingsPart(true);
        documentSettingsPart.protectRestrictFormatting(autoFormatOverride, styleLockTheme, styleLockQFSet, password, hashAlgo);
        if (this.pkg.getDocPropsExtendedPart() == null) {
            this.pkg.addDocPropsExtendedPart();
        }
        this.setDocSecurity(0);
    }

    public boolean isRestrictEditingWith(STDocProtect editValue) {
        DocumentSettingsPart documentSettingsPart = this.getPkg().getMainDocumentPart().getDocumentSettingsPart();
        if (documentSettingsPart == null) {
            return false;
        }
        return documentSettingsPart.isRestrictEditingWith(editValue);
    }

    public void restrictEditing(STDocProtect editValue) {
        this.restrictEditing(editValue, null, null);
    }

    public void restrictEditing(STDocProtect editValue, String password) {
        this.restrictEditing(editValue, password, HashAlgorithm.sha512);
    }

    public void restrictEditing(STDocProtect editValue, String password, HashAlgorithm hashAlgo) {
        DocumentSettingsPart documentSettingsPart = null;
        try {
            documentSettingsPart = this.getPkg().getMainDocumentPart().getDocumentSettingsPart(true);
        }
        catch (InvalidFormatException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        documentSettingsPart.protectRestrictEditing(editValue, password, hashAlgo);
        if (this.pkg.getDocPropsExtendedPart() == null) {
            this.pkg.addDocPropsExtendedPart();
        }
        if (editValue == STDocProtect.COMMENTS) {
            this.setDocSecurity(8);
        } else if (editValue == STDocProtect.FORMS) {
            this.setDocSecurity(0);
        } else if (editValue == STDocProtect.NONE) {
            this.setDocSecurity(0);
        } else if (editValue == STDocProtect.READ_ONLY) {
            this.setDocSecurity(8);
        } else if (editValue == STDocProtect.TRACKED_CHANGES) {
            this.setDocSecurity(0);
        }
    }

    public boolean validateProtectionPassword(String password) {
        DocumentSettingsPart documentSettingsPart = this.getPkg().getMainDocumentPart().getDocumentSettingsPart();
        if (documentSettingsPart == null) {
            return false;
        }
        return documentSettingsPart.validateProtectionPassword(password);
    }

    public void removeEnforcement() {
        DocumentSettingsPart documentSettingsPart = this.getPkg().getMainDocumentPart().getDocumentSettingsPart();
        if (documentSettingsPart == null) {
            return;
        }
        documentSettingsPart.removeEnforcement();
    }

    private static class VisitorRemoveTableFormatting
    extends TraversalUtilVisitor<Tbl> {
        StyleDefinitionsPart sdp;
        List<String> allowedStyleNames;

        VisitorRemoveTableFormatting(StyleDefinitionsPart sdp, List<String> allowedStyleNames) {
            this.sdp = sdp;
            this.allowedStyleNames = allowedStyleNames;
        }

        @Override
        public void apply(Tbl table, Object parent, List<Object> siblings) {
            if (table.getTblPr() != null && table.getTblPr().getTblStyle() != null && !this.allowedStyleNames.contains(this.sdp.getNameForStyleID(table.getTblPr().getTblStyle().getVal()))) {
                table.getTblPr().setTblStyle(null);
            }
        }
    }

    private static class VisitorRemoveRFormatting
    extends TraversalUtilVisitor<R> {
        StyleDefinitionsPart sdp;
        List<String> allowedStyleNames;

        VisitorRemoveRFormatting(StyleDefinitionsPart sdp, List<String> allowedStyleNames) {
            this.sdp = sdp;
            this.allowedStyleNames = allowedStyleNames;
        }

        @Override
        public void apply(R r, Object parent, List<Object> siblings) {
            if (r.getRPr() != null && r.getRPr().getRStyle() != null && !this.allowedStyleNames.contains(this.sdp.getNameForStyleID(r.getRPr().getRStyle().getVal()))) {
                r.getRPr().setRStyle(null);
            }
        }
    }

    private static class VisitorRemovePFormatting
    extends TraversalUtilVisitor<P> {
        StyleDefinitionsPart sdp;
        List<String> allowedStyleNames;

        VisitorRemovePFormatting(StyleDefinitionsPart sdp, List<String> allowedStyleNames) {
            this.sdp = sdp;
            this.allowedStyleNames = allowedStyleNames;
        }

        @Override
        public void apply(P p, Object parent, List<Object> siblings) {
            if (p.getPPr() != null && p.getPPr().getPStyle() != null && !this.allowedStyleNames.contains(this.sdp.getNameForStyleID(p.getPPr().getPStyle().getVal()))) {
                p.getPPr().setPStyle(null);
            }
        }
    }
}

