/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.jaxb;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.docx4j.jaxb.BinderListenerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinderListenerUtils {
    private static Logger log = LoggerFactory.getLogger(BinderListenerUtils.class);
    private static JAXBContext testContext;
    private static BinderListenerInterface binderListener;
    private static boolean haveTried;

    public static synchronized BinderListenerInterface getBinderListener() throws JAXBException {
        Class<?> c;
        if (binderListener != null) {
            return binderListener;
        }
        if (haveTried) {
            return null;
        }
        haveTried = true;
        if (testContext == null) {
            ClassLoader classLoader = BinderListenerUtils.class.getClassLoader();
            testContext = JAXBContext.newInstance((String)"org.docx4j.relationships", (ClassLoader)classLoader);
        }
        if (testContext == null) {
            throw new JAXBException("Couldn't create context for org.docx4j.relationships.  Everything is broken!");
        }
        if (log.isDebugEnabled()) {
            log.debug("testContext: " + testContext.getClass().getName());
        }
        if (testContext.getClass().getName().equals("org.eclipse.persistence.jaxb.JAXBContext")) {
            log.info("Using MOXy NamespacePrefixMapper");
            try {
                c = Class.forName("org.docx4j.jaxb.moxy.BinderListener");
                binderListener = (BinderListenerInterface)c.newInstance();
                return binderListener;
            }
            catch (Exception e) {
                throw new JAXBException("Can't create org.docx4j.jaxb.moxy.BinderListener", (Throwable)e);
            }
        }
        if (testContext.getClass().getName().equals("com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl")) {
            log.info("Using com.sun.xml.internal BinderListener");
            try {
                c = Class.forName("org.docx4j.jaxb.suninternal.BinderListener");
                binderListener = (BinderListenerInterface)c.newInstance();
                return binderListener;
            }
            catch (Exception e) {
                throw new JAXBException("Can't create org.docx4j.jaxb.suninternal.BinderListener", (Throwable)e);
            }
        }
        Marshaller m = testContext.createMarshaller();
        return BinderListenerUtils.tryUsingRI(m);
    }

    private static BinderListenerInterface tryUsingRI(Marshaller m) throws JAXBException {
        try {
            Class<?> c = Class.forName("org.docx4j.jaxb.ri.BinderListener");
            binderListener = (BinderListenerInterface)c.newInstance();
            log.info("Using ri.BinderListener, which is suitable for the JAXB RI");
            return binderListener;
        }
        catch (Exception e) {
            throw new JAXBException("JAXB: Can't instantiate JAXB Reference Implementation", (Throwable)e);
        }
    }

    static {
        haveTried = false;
    }
}

