/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.run;

import java.math.BigInteger;
import org.docx4j.UnitsOfMeasurement;
import org.docx4j.dml.CTTextCharacterProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.properties.run.AbstractRunProperty;
import org.docx4j.wml.CTSignedTwipsMeasure;
import org.docx4j.wml.RPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class Spacing
extends AbstractRunProperty {
    protected static Logger log = LoggerFactory.getLogger(Spacing.class);
    public static final String CSS_NAME = "letter-spacing";
    public static final String FO_NAME = "letter-spacing";

    @Override
    public String getCssName() {
        return "letter-spacing";
    }

    public Spacing(CTSignedTwipsMeasure ctSignedTwipsMeasure) {
        this.setObject(ctSignedTwipsMeasure);
    }

    public Spacing(CSSValue value) {
        int twip;
        this.debug("letter-spacing", value);
        CSSPrimitiveValue cssPrimitiveValue = (CSSPrimitiveValue)value;
        short ignored = 1;
        float fVal = cssPrimitiveValue.getFloatValue(ignored);
        if (fVal == 0.0f) {
            this.setObject(BigInteger.ZERO);
            return;
        }
        short type = cssPrimitiveValue.getPrimitiveType();
        if (8 == type) {
            twip = UnitsOfMeasurement.inchToTwip(fVal);
        } else if (7 == type) {
            twip = UnitsOfMeasurement.mmToTwip(fVal);
        } else if (9 == type) {
            twip = UnitsOfMeasurement.pointToTwip(fVal);
        } else if (3 == type) {
            twip = UnitsOfMeasurement.pxToTwip(16.0f * fVal);
        } else if (4 == type) {
            twip = UnitsOfMeasurement.pxToTwip(8.0f * fVal);
        } else if (5 == type) {
            twip = UnitsOfMeasurement.pxToTwip(fVal);
        } else if (1 == type) {
            log.error("No support for unit: CSS_NUMBER ");
            twip = 0;
        } else {
            log.error("No support for unit " + type);
            twip = 0;
        }
        CTSignedTwipsMeasure spacing = Context.getWmlObjectFactory().createCTSignedTwipsMeasure();
        spacing.setVal(BigInteger.valueOf(twip));
        this.setObject(spacing);
    }

    @Override
    public String getCssProperty() {
        return Spacing.composeCss("letter-spacing", UnitsOfMeasurement.twipToBest(((CTSignedTwipsMeasure)this.getObject()).getVal().intValue()));
    }

    @Override
    public void setXslFO(Element foElement) {
        foElement.setAttribute("letter-spacing", UnitsOfMeasurement.twipToBest(((CTSignedTwipsMeasure)this.getObject()).getVal().intValue()));
    }

    @Override
    public void set(RPr rPr) {
        rPr.setSpacing((CTSignedTwipsMeasure)this.getObject());
    }

    @Override
    public void set(CTTextCharacterProperties rPr) {
    }
}

