/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.InputStream;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.wmf.WmfParser;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.ExternalTarget;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafilePart;
import org.docx4j.utils.BufferUtil;
import org.w3c.dom.Document;

public class MetafileWmfPart
extends MetafilePart {
    public MetafileWmfPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public MetafileWmfPart(ExternalTarget externalTarget) {
        super(externalTarget);
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("image/x-wmf"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
    }

    public SvgDocument toSVG() throws Exception {
        InputStream is = BufferUtil.newInputStream(this.getBuffer());
        return new SvgDocument(is);
    }

    public static class SvgDocument {
        Document doc = null;

        public Document getDomDocument() {
            return this.doc;
        }

        public SvgDocument(InputStream wmfStream) throws Exception {
            WmfParser parser = new WmfParser();
            SvgGdi gdi = new SvgGdi();
            parser.parse(wmfStream, (Gdi)gdi);
            this.doc = gdi.getDocument();
        }
    }
}

