/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.docx4j.XmlUtils;
import org.docx4j.com.google.common.collect.BiMap;
import org.docx4j.com.google.common.collect.HashBiMap;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.McIgnorableNamespaceDeclarator;
import org.docx4j.model.styles.BrokenStyleRemediator;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.JaxbXmlPartXPathAware;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.ResourceUtils;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.Style;
import org.docx4j.wml.Styles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StyleDefinitionsPart
extends JaxbXmlPartXPathAware<Styles> {
    private static Logger log = LoggerFactory.getLogger(StyleDefinitionsPart.class);
    private static Map<String, Style> knownStyles = null;
    private Style defaultCharacterStyle;
    private static final String DEFAULT_CHARACTER_STYLE_DEFAULT = "<w:style w:type=\"character\" w:default=\"1\" w:styleId=\"DefaultParagraphFont\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:name w:val=\"Default Paragraph Font\" /></w:style>";
    private Style defaultParagraphStyle;
    private Style defaultTableStyle;
    static final String wNamespaceDec = " xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"";
    public static final String rPrDefaultsString = "<w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"20\" /><w:szCs w:val=\"20\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr>";
    public static final String pPrDefaultsString = "<w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr>";
    public static final String docDefaultsString = "<w:docDefaults xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:rPrDefault><w:rPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:sz w:val=\"20\" /><w:szCs w:val=\"20\" /><w:lang w:val=\"en-US\" w:eastAsia=\"en-US\" w:bidi=\"ar-SA\" /></w:rPr></w:rPrDefault><w:pPrDefault><w:pPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:spacing w:after=\"200\" w:line=\"276\" w:lineRule=\"auto\" /></w:pPr></w:pPrDefault></w:docDefaults>";
    private String css;
    private BiMap<String, String> styleIdToName;
    private BiMap<String, String> styleNameToId;

    public StyleDefinitionsPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public StyleDefinitionsPart() throws InvalidFormatException {
        super(new PartName("/word/styles.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles");
    }

    @Override
    protected void setMceIgnorable(McIgnorableNamespaceDeclarator namespacePrefixMapper) {
        namespacePrefixMapper.setMcIgnorable(((Styles)this.getJaxbElement()).getIgnorable());
    }

    @Override
    public String getMceIgnorable() {
        return ((Styles)this.getJaxbElement()).getIgnorable();
    }

    @Override
    public void setJaxbElement(Styles jaxbElement) {
        super.setJaxbElement(jaxbElement);
        this.defaultCharacterStyle = null;
        this.defaultParagraphStyle = null;
        this.defaultTableStyle = null;
        this.css = null;
    }

    public Object unmarshalDefaultStyles() throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResourceViaProperty("docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart.DefaultStyles", "org/docx4j/openpackaging/parts/WordprocessingML/styles.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.unmarshal(is);
    }

    private static void initKnownStyles() {
        InputStream is = null;
        try {
            is = ResourceUtils.getResourceViaProperty("docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart.KnownStyles", "org/docx4j/openpackaging/parts/WordprocessingML/KnownStyles.xml");
            JAXBContext jc = Context.jc;
            Unmarshaller u = jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            Styles styles = (Styles)u.unmarshal(is);
            knownStyles = new HashMap<String, Style>();
            for (Style s : styles.getStyle()) {
                knownStyles.put(s.getStyleId(), s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Style> getKnownStyles() {
        if (knownStyles == null) {
            StyleDefinitionsPart.initKnownStyles();
        }
        return knownStyles;
    }

    public Style getStyleById(String id) {
        return StyleDefinitionsPart.getStyleById(((Styles)this.getJaxbElement()).getStyle(), id);
    }

    private static Style getStyleById(List<Style> styles, String id) {
        for (Style s : styles) {
            if (s.getStyleId() == null) {
                BrokenStyleRemediator.remediate(s);
            }
            if (s.getStyleId() == null || !s.getStyleId().equals(id)) continue;
            return s;
        }
        return null;
    }

    public Style getDefaultCharacterStyle() {
        if (this.defaultCharacterStyle == null) {
            this.defaultCharacterStyle = this.getDefaultStyle("character");
        }
        if (this.defaultCharacterStyle == null) {
            try {
                this.defaultCharacterStyle = (Style)XmlUtils.unmarshalString(DEFAULT_CHARACTER_STYLE_DEFAULT);
                ((Styles)this.getJaxbElement()).getStyle().add(this.defaultCharacterStyle);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return this.defaultCharacterStyle;
    }

    public Style getDefaultParagraphStyle() {
        if (this.defaultParagraphStyle == null) {
            this.defaultParagraphStyle = this.getDefaultStyle("paragraph");
        }
        if (this.defaultParagraphStyle == null) {
            for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
                if (!s.getType().equals("paragraph") || s.getName() == null || !s.getName().getVal().equals("Default")) continue;
                log.debug("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style");
                this.defaultParagraphStyle = s;
                break;
            }
        }
        if (this.defaultParagraphStyle == null) {
            for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
                if (!s.getType().equals("paragraph") || !s.getStyleId().equals("style0")) continue;
                log.debug("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style");
                this.defaultParagraphStyle = s;
                break;
            }
        }
        if (this.defaultParagraphStyle == null) {
            log.warn("No default paragraph style defined");
        }
        return this.defaultParagraphStyle;
    }

    public Style getDefaultTableStyle() {
        if (this.defaultTableStyle == null) {
            this.defaultTableStyle = this.getDefaultStyle("table");
        }
        return this.defaultTableStyle;
    }

    private Style getDefaultStyle(String type) {
        for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
            if (!s.isDefault() || !s.getType().equals(type)) continue;
            log.debug("Style with name " + s.getName().getVal() + ", id '" + s.getStyleId() + "' is default " + s.getType() + " style");
            return s;
        }
        return null;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }

    public Style getLinkedStyle(String rStyleVal) {
        Style rStyle = this.getStyleById(rStyleVal);
        if (rStyle == null) {
            log.info("Couldn't find rStyle " + rStyleVal);
            return null;
        }
        Style.Link linkedStyle = rStyle.getLink();
        if (linkedStyle == null) {
            log.info("No linked style for rStyle " + rStyleVal);
            return null;
        }
        String pStyleVal = linkedStyle.getVal();
        log.debug(rStyleVal + " is linked to style " + pStyleVal);
        Style pStyle = this.getStyleById(pStyleVal);
        if (pStyle == null) {
            log.info("Couldn't find linked pStyle " + pStyleVal + " for rStyle " + rStyleVal);
        }
        return pStyle;
    }

    public void protectRestrictFormatting(List<String> allowedStyleNames, boolean removedNotAllowedFormatting, Set<String> stylesInUse) throws Docx4JException {
        Styles.LatentStyles.LsdException lsdEx;
        Styles.LatentStyles.LsdException defaultLsd;
        if (this.getJaxbElement() == null) {
            throw new Docx4JException("StyleDefinitionsPart null content");
        }
        if (((Styles)this.getJaxbElement()).getLatentStyles() == null) {
            throw new Docx4JException("StyleDefinitionsPart content missing latentStyles");
        }
        ((Styles)this.getJaxbElement()).getLatentStyles().setDefLockedState(Boolean.TRUE);
        HashMap<String, Styles.LatentStyles.LsdException> lsdExceptions = new HashMap<String, Styles.LatentStyles.LsdException>();
        for (Styles.LatentStyles.LsdException lsdException : ((Styles)this.getJaxbElement()).getLatentStyles().getLsdException()) {
            lsdExceptions.put(lsdException.getName(), lsdException);
            lsdException.setLocked(Boolean.valueOf(true));
        }
        this.getDefaultParagraphStyle();
        String defaultParagraphStyleName = "Normal";
        if (this.defaultParagraphStyle != null) {
            defaultParagraphStyleName = this.defaultParagraphStyle.getName().getVal();
        }
        if ((defaultLsd = (Styles.LatentStyles.LsdException)lsdExceptions.get(defaultParagraphStyleName)) == null) {
            log.warn("No lsdException for " + defaultParagraphStyleName);
        } else {
            defaultLsd.setLocked(Boolean.valueOf(false));
        }
        for (String styleName : allowedStyleNames) {
            lsdEx = (Styles.LatentStyles.LsdException)lsdExceptions.get(styleName);
            if (lsdEx == null) {
                log.debug("No lsdException for " + styleName);
                continue;
            }
            lsdEx.setLocked(Boolean.valueOf(false));
        }
        for (String styleName : stylesInUse) {
            lsdEx = (Styles.LatentStyles.LsdException)lsdExceptions.get(styleName);
            if (lsdEx == null) {
                log.debug("No lsdException for " + styleName);
                continue;
            }
            lsdEx.setLocked(Boolean.valueOf(false));
            lsdEx.setSemiHidden(Boolean.valueOf(false));
        }
        allowedStyleNames.add(defaultParagraphStyleName);
        ArrayList<Style> deletions = new ArrayList<Style>();
        for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
            if (allowedStyleNames.contains(s.getName().getVal())) continue;
            if (stylesInUse.contains(s.getName().getVal())) {
                s.setLocked(new BooleanDefaultTrue());
                continue;
            }
            deletions.add(s);
        }
        ((Styles)this.getJaxbElement()).getStyle().removeAll(deletions);
    }

    public String getNameForStyleID(String id) {
        if (this.styleIdToName == null) {
            this.refreshNameIdBiMaps();
        }
        return (String)this.styleIdToName.get(id);
    }

    public String getIDForStyleName(String name) {
        if (this.styleIdToName == null) {
            this.refreshNameIdBiMaps();
        }
        return (String)this.styleNameToId.get(name);
    }

    public void refreshNameIdBiMaps() {
        this.styleIdToName = HashBiMap.create();
        for (Style s : ((Styles)this.getJaxbElement()).getStyle()) {
            if (s.getName() == null || s.getName().getVal() == null) {
                log.info("style has no name!");
                continue;
            }
            if (s.getStyleId() == null || s.getStyleId().trim().length() == 0) {
                log.info("style has no id!");
                continue;
            }
            this.styleIdToName.put(s.getStyleId(), s.getName().getVal());
        }
        this.styleNameToId = this.styleIdToName.inverse();
    }
}

