/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.contenttype;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.openpackaging.contenttype.CTDefault;
import org.docx4j.openpackaging.contenttype.CTOverride;
import org.docx4j.openpackaging.contenttype.CTTypes;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ObjectFactory;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.packages.DefaultPackage;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLTemplatePackage;
import org.docx4j.openpackaging.parts.ActiveXControlXmlPart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.DefaultXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.DrawingML.DiagramDrawingPart;
import org.docx4j.openpackaging.parts.DrawingML.JaxbDmlPart;
import org.docx4j.openpackaging.parts.DrawingML.ThemeOverridePart;
import org.docx4j.openpackaging.parts.InkmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.FontDataPart;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.JaxbSmlPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.VMLPart;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsExtendedPart;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.EmbeddedPackagePart;
import org.docx4j.openpackaging.parts.WordprocessingML.EndnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.GlossaryDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageBmpPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageGifPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageJpegPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImagePngPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ImageTiffPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileEmfPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MetafileWmfPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart;
import org.docx4j.openpackaging.parts.WordprocessingML.OleObjectBinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.PeoplePart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.VbaDataPart;
import org.docx4j.openpackaging.parts.WordprocessingML.VbaProjectBinaryPart;
import org.docx4j.openpackaging.parts.WordprocessingML.VbaProjectSignatureBin;
import org.docx4j.openpackaging.parts.WordprocessingML.WebSettingsPart;
import org.docx4j.openpackaging.parts.webextensions.TaskpanesPart;
import org.docx4j.openpackaging.parts.webextensions.WebExtensionPart;
import org.docx4j.relationships.Relationship;
import org.glox4j.openpackaging.packages.GloxPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ContentTypeManager {
    protected static Logger log = LoggerFactory.getLogger(ContentTypeManager.class);
    public static final String CONTENT_TYPES_PART_NAME = "[Content_Types].xml";
    public static final String TYPES_NAMESPACE_URI = "http://schemas.openxmlformats.org/package/2006/content-types";
    private static final String TYPES_TAG_NAME = "Types";
    private static final String DEFAULT_TAG_NAME = "Default";
    private static final String EXTENSION_ATTRIBUTE_NAME = "Extension";
    private static final String CONTENT_TYPE_ATTRIBUTE_NAME = "ContentType";
    private static final String OVERRIDE_TAG_NAME = "Override";
    private static final String PART_NAME_ATTRIBUTE_NAME = "PartName";
    private TreeMap<String, CTDefault> defaultContentType;
    private TreeMap<URI, CTOverride> overrideContentType;
    private static ObjectFactory ctFactory = new ObjectFactory();

    public TreeMap<String, CTDefault> getDefaultContentType() {
        return this.defaultContentType;
    }

    public TreeMap<URI, CTOverride> getOverrideContentType() {
        return this.overrideContentType;
    }

    public ContentTypeManager() {
        this.init();
    }

    private void init() {
        this.defaultContentType = new TreeMap();
        this.overrideContentType = new TreeMap();
    }

    public void addOverrideContentType(URI partUri, CTOverride contentType) {
        log.debug("Registered " + partUri.toString() + " of type " + contentType.getContentType());
        this.overrideContentType.put(partUri, contentType);
    }

    public void addOverrideContentType(URI partUri, String contentType) {
        CTOverride overrideCT = ctFactory.createCTOverride();
        overrideCT.setPartName(partUri.toASCIIString());
        overrideCT.setContentType(contentType);
        this.overrideContentType.put(partUri, overrideCT);
    }

    public URI getPartNameOverridenByContentType(String contentType) {
        for (Map.Entry<URI, CTOverride> e : this.overrideContentType.entrySet()) {
            if (e == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("Inspecting " + e.getValue());
            }
            if (!e.getValue().getContentType().equals(contentType)) continue;
            return e.getKey();
        }
        return null;
    }

    public Part getPart(String partName, Relationship rel) throws URISyntaxException, PartUnrecognisedException, InvalidFormatException {
        CTOverride overrideCT = this.overrideContentType.get(new URI(partName));
        if (overrideCT != null) {
            String contentType = new String(overrideCT.getContentType());
            if (log.isDebugEnabled()) {
                log.debug("Found content type '" + contentType + "' for " + partName);
            }
            Part p = this.newPartForContentType(contentType, partName, rel);
            p.setContentType(new ContentType(contentType));
            return p;
        }
        String ext = new String(partName.substring(partName.indexOf(".") + 1).toLowerCase());
        log.debug("Looking at extension '" + ext);
        CTDefault defaultCT = this.defaultContentType.get(ext);
        if (defaultCT != null) {
            String contentType = defaultCT.getContentType();
            if (log.isDebugEnabled()) {
                log.debug("Found content type '" + contentType + "' for " + partName);
            }
            Part p = this.newPartForContentType(contentType, partName, rel);
            p.setContentType(new ContentType(contentType));
            return p;
        }
        log.error("No content type found for " + partName);
        return null;
    }

    public Part newPartForContentType(String contentType, String partName, Relationship rel) throws InvalidFormatException, PartUnrecognisedException {
        if (rel != null && rel.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/aFChunk")) {
            AlternativeFormatInputPart afip = new AlternativeFormatInputPart(new PartName(partName));
            afip.setContentType(new ContentType(contentType));
            return afip;
        }
        if (rel != null && rel.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/package")) {
            EmbeddedPackagePart epp = new EmbeddedPackagePart(new PartName(partName));
            epp.setContentType(new ContentType(contentType));
            return epp;
        }
        if (rel != null && rel.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject")) {
            OleObjectBinaryPart olePart = new OleObjectBinaryPart(new PartName(partName));
            olePart.setContentType(new ContentType(contentType));
            return olePart;
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml")) {
            return this.CreateMainDocumentPartObject(partName);
        }
        if (contentType.equals("application/vnd.ms-word.document.macroEnabled.main+xml")) {
            return this.CreateMainDocumentPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml")) {
            return this.CreateMainDocumentPartObject(partName);
        }
        if (contentType.equals("application/vnd.ms-word.template.macroEnabledTemplate.main+xml")) {
            return this.CreateMainDocumentPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return this.CreateDocPropsCorePartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.custom-properties+xml")) {
            return this.CreateDocPropsCustomPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.extended-properties+xml")) {
            return this.CreateDocPropsExtendedPartObject(partName);
        }
        if (contentType.equals("application/xml")) {
            return new CustomXmlDataStoragePart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.customXmlProperties+xml")) {
            return this.CreateCustomXmlDataStoragePropertiesPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.obfuscatedFont")) {
            return this.CreateObfuscatedFontPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.oleObject") || contentType.equals("application/vnd.ms-office.activeX")) {
            return new OleObjectBinaryPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.ms-office.activeX+xml")) {
            return new ActiveXControlXmlPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.theme+xml")) {
            return this.CreateThemePartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml")) {
            return this.CreateCommentsPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.commentsExtended+xml")) {
            return new CommentsExtendedPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml")) {
            return this.CreateEndnotesPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml")) {
            return this.CreateFontTablePartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml")) {
            return this.CreateFooterPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml")) {
            return this.CreateFootnotesPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml")) {
            return this.CreateGlossaryDocumentPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml")) {
            return this.CreateHeaderPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml")) {
            return this.CreateNumberingPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml")) {
            return this.CreateDocumentSettingsPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml")) {
            return this.CreateStyleDefinitionsPartObject(partName);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml")) {
            return this.CreateWebSettingsPartObject(partName);
        }
        if (contentType.equals("application/vnd.ms-word.vbaData+xml")) {
            return new VbaDataPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.ms-office.vbaProject")) {
            return new VbaProjectBinaryPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.ms-office.vbaProjectSignature")) {
            return new VbaProjectSignatureBin(new PartName(partName));
        }
        if (contentType.equals("image/jpeg")) {
            return new ImageJpegPart(new PartName(partName));
        }
        if (contentType.equals("image/png")) {
            return new ImagePngPart(new PartName(partName));
        }
        if (contentType.equals("image/gif")) {
            return new ImageGifPart(new PartName(partName));
        }
        if (contentType.equals("image/tiff")) {
            return new ImageTiffPart(new PartName(partName));
        }
        if (contentType.equals("image/bmp")) {
            return new ImageBmpPart(new PartName(partName));
        }
        if (contentType.equals("image/x-emf") || contentType.equals("image/emf")) {
            return new MetafileEmfPart(new PartName(partName));
        }
        if (contentType.equals("image/x-wmf")) {
            return new MetafileWmfPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.people+xml")) {
            return new PeoplePart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.vmlDrawing")) {
            return new VMLPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.ms-office.drawingml.diagramDrawing+xml")) {
            return new DiagramDrawingPart(new PartName(partName));
        }
        if (contentType.startsWith("application/vnd.openxmlformats-officedocument.drawing")) {
            try {
                return JaxbDmlPart.newPartForContentType(contentType, partName);
            }
            catch (Exception e) {
                return new BinaryPart(new PartName(partName));
            }
        }
        if (contentType.startsWith("application/vnd.openxmlformats-officedocument.presentation") || contentType.equals("application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml") || contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.template.main+xml") || contentType.equals("application/vnd.ms-powerpoint.template.macroEnabled.main+xml")) {
            try {
                return JaxbPmlPart.newPartForContentType(contentType, partName);
            }
            catch (Exception e) {
                return new BinaryPart(new PartName(partName));
            }
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml") || contentType.equals("application/vnd.ms-excel.sheet.macroEnabled.main+xml") || contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml") || contentType.equals("application/vnd.ms-excel.template.macroEnabled.main+xml")) {
            try {
                return new WorkbookPart(new PartName(partName));
            }
            catch (Exception e) {
                return new BinaryPart(new PartName(partName));
            }
        }
        if (contentType.startsWith("application/vnd.openxmlformats-officedocument.spreadsheetml")) {
            try {
                return JaxbSmlPart.newPartForContentType(contentType, partName);
            }
            catch (Exception e) {
                return new BinaryPart(new PartName(partName));
            }
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.themeOverride+xml")) {
            return new ThemeOverridePart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml")) {
            try {
                Class<?> xmlSignaturePart = Class.forName("org.docx4j.openpackaging.parts.digitalsignature.XmlSignaturePart");
                Constructor<?> cons = xmlSignaturePart.getConstructor(PartName.class);
                PartName pn = new PartName(partName);
                return (Part)cons.newInstance(pn);
            }
            catch (Exception e) {
                return this.CreateDefaultXmlPartObject(partName);
            }
        }
        if (contentType.equals("application/vnd.openxmlformats-package.digital-signature-origin")) {
            try {
                Class<?> originPart = Class.forName("org.docx4j.openpackaging.parts.digitalsignature.SignatureOriginPart");
                Constructor<?> cons = originPart.getConstructor(PartName.class);
                PartName pn = new PartName(partName);
                return (Part)cons.newInstance(pn);
            }
            catch (Exception e) {
                return new BinaryPart(new PartName(partName));
            }
        }
        if (contentType.equals("application/vnd.ms-office.webextensiontaskpanes+xml")) {
            return new TaskpanesPart(new PartName(partName));
        }
        if (contentType.equals("application/vnd.ms-office.webextension+xml")) {
            return new WebExtensionPart(new PartName(partName));
        }
        if (contentType.equals("application/inkml+xml")) {
            return new InkmlPart(new PartName(partName));
        }
        if (contentType.equals("application/xml") || contentType.equals("image/svg+xml") || partName.endsWith(".xml")) {
            if (contentType.equals("application/vnd.ms-word.stylesWithEffects+xml")) {
                log.debug("DefaultPart used for part '" + partName + "' of content type '" + contentType + "'");
            } else {
                log.warn("DefaultPart used for part '" + partName + "' of content type '" + contentType + "'");
            }
            return this.CreateDefaultXmlPartObject(partName);
        }
        if (contentType.equals("application/x-fontdata")) {
            return new FontDataPart(new PartName(partName));
        }
        log.error("No subclass found for " + partName + "; defaulting to binary");
        return new BinaryPart(new PartName(partName));
    }

    public Part CreateDefaultXmlPartObject(String partName) throws InvalidFormatException {
        return new DefaultXmlPart(new PartName(partName));
    }

    public Part CreateMainDocumentPartObject(String partName) throws InvalidFormatException {
        return new MainDocumentPart(new PartName(partName));
    }

    public Part CreateStyleDefinitionsPartObject(String partName) throws InvalidFormatException {
        return new StyleDefinitionsPart(new PartName(partName));
    }

    public Part CreateDocumentSettingsPartObject(String partName) throws InvalidFormatException {
        return new DocumentSettingsPart(new PartName(partName));
    }

    public Part CreateWebSettingsPartObject(String partName) throws InvalidFormatException {
        return new WebSettingsPart(new PartName(partName));
    }

    public Part CreateFontTablePartObject(String partName) throws InvalidFormatException {
        return new FontTablePart(new PartName(partName));
    }

    public Part CreateThemePartObject(String partName) throws InvalidFormatException {
        return new ThemePart(new PartName(partName));
    }

    public Part CreateDocPropsCorePartObject(String partName) throws InvalidFormatException {
        return new DocPropsCorePart(new PartName(partName));
    }

    public Part CreateDocPropsExtendedPartObject(String partName) throws InvalidFormatException {
        return new DocPropsExtendedPart(new PartName(partName));
    }

    public Part CreateDocPropsCustomPartObject(String partName) throws InvalidFormatException {
        log.info("Using DocPropsCustomPart ...");
        return new DocPropsCustomPart(new PartName(partName));
    }

    public Part CreateCommentsPartObject(String partName) throws InvalidFormatException {
        return new CommentsPart(new PartName(partName));
    }

    public Part CreateCustomXmlDataStoragePropertiesPartObject(String partName) throws InvalidFormatException {
        return new CustomXmlDataStoragePropertiesPart(new PartName(partName));
    }

    public Part CreateEndnotesPartObject(String partName) throws InvalidFormatException {
        return new EndnotesPart(new PartName(partName));
    }

    public Part CreateFooterPartObject(String partName) throws InvalidFormatException {
        return new FooterPart(new PartName(partName));
    }

    public Part CreateFootnotesPartObject(String partName) throws InvalidFormatException {
        return new FootnotesPart(new PartName(partName));
    }

    public Part CreateGlossaryDocumentPartObject(String partName) throws InvalidFormatException {
        return new GlossaryDocumentPart(new PartName(partName));
    }

    public Part CreateHeaderPartObject(String partName) throws InvalidFormatException {
        return new HeaderPart(new PartName(partName));
    }

    public Part CreateNumberingPartObject(String partName) throws InvalidFormatException {
        return new NumberingDefinitionsPart(new PartName(partName));
    }

    public Part CreateObfuscatedFontPartObject(String partName) throws InvalidFormatException {
        return new ObfuscatedFontPart(new PartName(partName));
    }

    public void addDefaultContentType(String extension, CTDefault contentType) {
        log.debug("Registered " + extension);
        this.defaultContentType.put(extension.toLowerCase(), contentType);
    }

    public void addDefaultContentType(String extension, String contentType) {
        CTDefault defaultCT = ctFactory.createCTDefault();
        defaultCT.setExtension(extension.toLowerCase());
        defaultCT.setContentType(contentType);
        log.debug("Registered " + extension);
        this.defaultContentType.put(extension.toLowerCase(), defaultCT);
    }

    public void addOverrideContentType(PartName partName, String contentType) {
        CTOverride defaultCT = ctFactory.createCTOverride();
        defaultCT.setPartName(partName.getName());
        defaultCT.setContentType(contentType);
        this.overrideContentType.put(partName.getURI(), defaultCT);
    }

    @Deprecated
    public void removeContentType(PartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.overrideContentType != null && this.overrideContentType.get(partName.getURI()) != null) {
            this.overrideContentType.remove(partName.getURI());
            return;
        }
        this.defaultContentType.remove(partName.getExtension().toLowerCase());
    }

    public void removeOverrideContentType(PartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.overrideContentType != null && this.overrideContentType.get(partName.getURI()) != null) {
            this.overrideContentType.remove(partName.getURI());
            return;
        }
    }

    public void removeDefaultContentType(String ext) {
        this.defaultContentType.remove(ext.toLowerCase());
    }

    public boolean isContentTypeRegistered(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType");
        }
        return this.defaultContentType.values().contains(contentType);
    }

    public boolean isOverrideContentTypeRegistered(String contentType) {
        if (contentType == null) {
            throw new IllegalArgumentException("contentType");
        }
        return this.overrideContentType != null && this.overrideContentType.values().contains(contentType);
    }

    public String getContentType(PartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.overrideContentType != null && this.overrideContentType.containsKey(partName.getURI())) {
            return this.overrideContentType.get(partName.getURI()).getContentType();
        }
        String extension = partName.getExtension().toLowerCase();
        if (this.defaultContentType.containsKey(extension)) {
            return this.defaultContentType.get(extension).getContentType();
        }
        return null;
    }

    public void clearAll() {
        this.defaultContentType.clear();
        if (this.overrideContentType != null) {
            this.overrideContentType.clear();
        }
    }

    public void clearOverrideContentTypes() {
        if (this.overrideContentType != null) {
            this.overrideContentType.clear();
        }
    }

    public void parseContentTypesFile(InputStream contentTypes) throws InvalidFormatException {
        try {
            XMLInputFactory xif = XMLInputFactory.newInstance();
            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xif.setProperty("javax.xml.stream.supportDTD", false);
            XMLStreamReader xsr = xif.createXMLStreamReader(contentTypes);
            Unmarshaller u = Context.jcContentTypes.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            log.debug("unmarshalling " + this.getClass().getName());
            Object res = XmlUtils.unwrap(u.unmarshal(xsr));
            CTTypes types = (CTTypes)res;
            if (log.isDebugEnabled()) {
                XmlUtils.marshaltoString(res, true, true, Context.jcContentTypes);
            }
            for (Object o : types.getDefaultOrOverride()) {
                if (o instanceof CTDefault) {
                    CTDefault defaultCT = (CTDefault)o;
                    this.addDefaultContentType(defaultCT.getExtension(), defaultCT);
                }
                if (!(o instanceof CTOverride)) continue;
                CTOverride overrideCT = (CTOverride)o;
                URI uri = new URI(overrideCT.getPartName());
                this.addOverrideContentType(uri, overrideCT);
            }
        }
        catch (Exception e) {
            throw new InvalidFormatException("Bad [Content_Types].xml", e);
        }
    }

    private CTTypes buildTypes() {
        ObjectFactory factory = new ObjectFactory();
        CTTypes types = factory.createCTTypes();
        for (Map.Entry<String, CTDefault> entry : this.defaultContentType.entrySet()) {
            types.getDefaultOrOverride().add(entry.getValue());
        }
        if (this.overrideContentType != null) {
            for (Map.Entry<Object, Object> entry : this.overrideContentType.entrySet()) {
                types.getDefaultOrOverride().add(entry.getValue());
            }
        }
        return types;
    }

    public void marshal(Node node) throws JAXBException {
        try {
            Marshaller marshaller = Context.jcContentTypes.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            log.debug("marshalling " + this.getClass().getName() + " ...");
            marshaller.marshal((Object)this.buildTypes(), node);
            log.debug("content types marshalled \n\n");
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void marshal(OutputStream os) throws JAXBException {
        try {
            Marshaller marshaller = Context.jcContentTypes.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            log.debug("marshalling " + this.getClass().getName() + " ...");
            marshaller.marshal((Object)this.buildTypes(), os);
        }
        catch (JAXBException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public OpcPackage createPackage(String pkgContentType) throws InvalidFormatException {
        if (pkgContentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml") || pkgContentType.equals("application/vnd.ms-word.document.macroEnabled.main+xml")) {
            log.info("Detected WordProcessingML package ");
            WordprocessingMLPackage p = new WordprocessingMLPackage(this);
            p.setContentType(new ContentType(pkgContentType));
            return p;
        }
        if (pkgContentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml") || pkgContentType.equals("application/vnd.ms-word.template.macroEnabledTemplate.main+xml")) {
            log.info("Detected WordprocessingMLTemplatePackage package ");
            WordprocessingMLTemplatePackage p = new WordprocessingMLTemplatePackage(this);
            p.setContentType(new ContentType(pkgContentType));
            return p;
        }
        if (pkgContentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml") || pkgContentType.equals("application/vnd.openxmlformats-officedocument.presentationml.template.main+xml") || pkgContentType.equals("application/vnd.ms-powerpoint.template.macroEnabled.main+xml") || pkgContentType.equals("application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml") || pkgContentType.equals("application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml")) {
            log.info("Detected PresentationMLPackage package ");
            PresentationMLPackage p = new PresentationMLPackage(this);
            p.setContentType(new ContentType(pkgContentType));
            return p;
        }
        if (pkgContentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml") || pkgContentType.equals("application/vnd.ms-excel.sheet.macroEnabled.main+xml") || pkgContentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml") || pkgContentType.equals("application/vnd.ms-excel.template.macroEnabled.main+xml")) {
            log.info("Detected SpreadhseetMLPackage package ");
            SpreadsheetMLPackage p = new SpreadsheetMLPackage(this);
            p.setContentType(new ContentType(pkgContentType));
            return p;
        }
        if (pkgContentType.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml")) {
            log.info("Detected Glox file ");
            GloxPackage p = new GloxPackage(this);
            p.setContentType(new ContentType(pkgContentType));
            return p;
        }
        log.error("Couldn't identify package from " + pkgContentType);
        return new DefaultPackage(this);
    }

    public boolean isContentEqual(ContentTypeManager other) throws Docx4JException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
        try {
            this.marshal(baos);
            other.marshal(baos2);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Error marshalling parts", (Exception)((Object)e));
        }
        return Arrays.equals(baos.toByteArray(), baos2.toByteArray());
    }

    public String toString() {
        CTTypes types = this.buildTypes();
        return XmlUtils.marshaltoString(types, true, true, Context.jcContentTypes);
    }
}

