/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc.switches;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.NotImplementedException;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.finders.InstrTextFinder;
import org.docx4j.model.fields.FieldRef;
import org.docx4j.model.fields.FieldsPreprocessor;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.fields.SimpleFieldLocator;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.toc.TocEntry;
import org.docx4j.toc.switches.SelectorSwitch;
import org.docx4j.toc.switches.SwitchProcessorInterface;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.P;
import org.docx4j.wml.Style;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSwitch
extends SelectorSwitch {
    private static Logger log = LoggerFactory.getLogger(CSwitch.class);
    public static final String ID = "\\c";
    private static final int PRIORITY = 7;
    private String itemIdentifier;
    int counter = 1;
    boolean detected = false;

    @Override
    public int getPriority() {
        return 7;
    }

    public String getItemIdentifier() {
        return this.itemIdentifier;
    }

    @Override
    public String parseFieldArgument(String fieldArgument) {
        this.fieldArgument = fieldArgument;
        this.itemIdentifier = this.prepareArgument(fieldArgument);
        return "";
    }

    @Override
    public boolean hasFieldArgument() {
        return true;
    }

    @Override
    public void process(Style s, SwitchProcessorInterface sp) {
        throw new NotImplementedException("For ToC C swtich, don't use this method.");
    }

    public void process(P p, SwitchProcessorInterface sp) {
        String key;
        SimpleFieldLocator fl = new SimpleFieldLocator();
        new TraversalUtil(p, fl);
        for (CTSimpleField simpleField : fl.simpleFields) {
            String fldSimpleName = FormattingSwitchHelper.getFldSimpleName(simpleField.getInstr());
            if (!"SEQ".equals(fldSimpleName)) continue;
            FldSimpleModel fsm = new FldSimpleModel();
            try {
                fsm.build(simpleField.getInstr());
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            key = fsm.getFldParameters().get(0);
            if (log.isDebugEnabled()) {
                log.debug(simpleField.getInstr() + " ----> " + key);
            }
            if (!key.equals(this.getItemIdentifier())) continue;
            TocEntry te = sp.getEntry();
            te.setEntryLevel(1);
            this.detected = true;
            sp.setSelected(true);
            return;
        }
        InstrTextFinder complexFinder = new InstrTextFinder();
        new TraversalUtil(p, complexFinder);
        for (Object o : complexFinder.results) {
            Text t = (Text)XmlUtils.unwrap(o);
            key = t.getValue();
            if (!key.contains("SEQ") || !key.contains(this.getItemIdentifier())) continue;
            TocEntry te = sp.getEntry();
            te.setEntryLevel(1);
            this.detected = true;
            sp.setSelected(true);
            return;
        }
        log.debug("P doesn't contain SEQ");
    }

    public boolean isDetected() {
        return this.detected;
    }

    public P postprocess(P p, WordprocessingMLPackage wordMLPackage) {
        P clonedP = XmlUtils.deepCopy(p);
        ArrayList<FieldRef> fieldRefs = new ArrayList<FieldRef>();
        clonedP = FieldsPreprocessor.canonicalise(clonedP, fieldRefs);
        for (FieldRef fr : fieldRefs) {
            if (log.isDebugEnabled()) {
                log.debug("'" + fr.getFldName() + "'");
            }
            if (!fr.getFldName().equals("SEQ")) continue;
            String instr = CSwitch.extractInstr(fr.getInstructions());
            if (instr == null) {
                log.warn("No instructions found in this field");
                continue;
            }
            System.out.println(instr);
            String identifier = CSwitch.getIdentifierFromInstr(instr);
            if (!this.getItemIdentifier().equals(identifier)) {
                log.debug("'" + identifier + "' does not match sought '" + this.getItemIdentifier() + "'");
                continue;
            }
            FldSimpleModel fsm = new FldSimpleModel();
            Object result = "" + this.counter;
            try {
                fsm.build(instr);
                try {
                    result = FormattingSwitchHelper.applyFormattingSwitch(wordMLPackage, fsm, (String)result);
                }
                catch (Docx4JException e) {
                    e.printStackTrace();
                }
            }
            catch (TransformerException e) {
                log.warn("Can't format the field", (Throwable)e);
            }
            fr.setResult((String)result);
            fr.getParent().getContent().remove(fr.getBeginRun());
            fr.getParent().getContent().remove(fr.getEndRun());
        }
        ++this.counter;
        this.detected = false;
        return clonedP;
    }

    protected static String extractInstr(List<Object> instructions) {
        if (instructions.size() != 1) {
            log.warn("SEQ field contained complex instruction; attempting to process");
            StringBuffer sb = new StringBuffer();
            for (Object i : instructions) {
                if ((i = XmlUtils.unwrap(i)) instanceof Text) {
                    String t = ((Text)i).getValue();
                    log.debug(t);
                    sb.append(t);
                    continue;
                }
                log.warn("Failed: non Text object encountered.");
                log.debug(XmlUtils.marshaltoString(i, true, true));
                return null;
            }
            return sb.toString();
        }
        Object o = XmlUtils.unwrap(instructions.get(0));
        if (o instanceof Text) {
            return ((Text)o).getValue();
        }
        if (log.isErrorEnabled()) {
            log.error("TODO: extract field name from " + o.getClass().getName());
            log.error(XmlUtils.marshaltoString(instructions.get(0), true, true));
        }
        return null;
    }

    protected static String getIdentifierFromInstr(String instr) {
        String tmp = instr.substring(instr.indexOf("SEQ") + 3);
        tmp = tmp.trim();
        String datafieldName = null;
        if (tmp.startsWith("\"")) {
            if (tmp.indexOf("\"", 1) > -1) {
                datafieldName = tmp.substring(1, tmp.indexOf("\"", 1));
            } else {
                log.warn("Quote mismatch in " + instr);
                datafieldName = tmp.indexOf(" ") > -1 ? tmp.substring(1, tmp.indexOf(" ")) : tmp.substring(1);
            }
        } else {
            datafieldName = tmp.indexOf(" ") > -1 ? tmp.substring(0, tmp.indexOf(" ")) : tmp;
        }
        log.info("Key: '" + datafieldName + "'");
        return datafieldName;
    }
}

