package org.docx4j.convert.out.common.writer;

import java.util.HashMap;
import java.util.Map;

public class SymbolMapper {

	//font name -> Map with replacement unicode characters
	private static Map<String,Map<Short,String>> fontMaps = new HashMap<>();

	static {

		//map for 'Wingdings', source: https://www.alanwood.net/demos/wingdings.html
		{
			Map<Short, String> m = new HashMap<>();
			m.put((short)32, "\u0020");
			m.put((short)33, "\uD83D\uDD89");
			m.put((short)34, "\u2702");
			m.put((short)35, "\u2701");
			m.put((short)36, "\uD83D\uDC53");
			m.put((short)37, "\uD83D\uDD6D");
			m.put((short)38, "\uD83D\uDD6E");
			m.put((short)39, "\uD83D\uDD6F");
			m.put((short)40, "\uD83D\uDD7F");
			m.put((short)41, "\u2706");
			m.put((short)42, "\uD83D\uDD82");
			m.put((short)43, "\uD83D\uDD83");
			m.put((short)44, "\uD83D\uDCEA");
			m.put((short)45, "\uD83D\uDCEB");
			m.put((short)46, "\uD83D\uDCEC");
			m.put((short)47, "\uD83D\uDCED");
			m.put((short)48, "\uD83D\uDCC1");
			m.put((short)49, "\uD83D\uDCC2");
			m.put((short)50, "\uD83D\uDCC4");
			m.put((short)51, "\uD83D\uDDCF");
			m.put((short)52, "\uD83D\uDDD0");
			m.put((short)53, "\uD83D\uDDC4");
			m.put((short)54, "\u231B");
			m.put((short)55, "\uD83D\uDDAE");
			m.put((short)56, "\uD83D\uDDB0");
			m.put((short)57, "\uD83D\uDDB2");
			m.put((short)58, "\uD83D\uDDB3");
			m.put((short)59, "\uD83D\uDDB4");
			m.put((short)60, "\uD83D\uDDAB");
			m.put((short)61, "\uD83D\uDDAC");
			m.put((short)62, "\u2707");
			m.put((short)63, "\u270D");
			m.put((short)64, "\uD83D\uDD8E");
			m.put((short)65, "\u270C");
			m.put((short)66, "\uD83D\uDC4C");
			m.put((short)67, "\uD83D\uDC4D");
			m.put((short)68, "\uD83D\uDC4E");
			m.put((short)69, "\u261C");
			m.put((short)70, "\u261E");
			m.put((short)71, "\u261D");
			m.put((short)72, "\u261F");
			m.put((short)73, "\uD83D\uDD90");
			m.put((short)74, "\u263A");
			m.put((short)75, "\uD83D\uDE10");
			m.put((short)76, "\u2639");
			m.put((short)77, "\uD83D\uDCA3");
			m.put((short)78, "\u2620");
			m.put((short)79, "\uD83C\uDFF3");
			m.put((short)80, "\uD83C\uDFF1");
			m.put((short)81, "\u2708");
			m.put((short)82, "\u263C");
			m.put((short)83, "\uD83D\uDCA7");
			m.put((short)84, "\u2744");
			m.put((short)85, "\uD83D\uDD46");
			m.put((short)86, "\u271E");
			m.put((short)87, "\uD83D\uDD48");
			m.put((short)88, "\u2720");
			m.put((short)89, "\u2721");
			m.put((short)90, "\u262A");
			m.put((short)91, "\u262F");
			m.put((short)92, "\u0950");
			m.put((short)93, "\u2638");
			m.put((short)94, "\u2648");
			m.put((short)95, "\u2649");
			m.put((short)96, "\u264A");
			m.put((short)97, "\u264B");
			m.put((short)98, "\u264C");
			m.put((short)99, "\u264D");
			m.put((short)100, "\u264E");
			m.put((short)101, "\u264F");
			m.put((short)102, "\u2650");
			m.put((short)103, "\u2651");
			m.put((short)104, "\u2652");
			m.put((short)105, "\u2653");
			m.put((short)106, "\uD83D\uDE70");
			m.put((short)107, "\uD83D\uDE75");
			m.put((short)108, "\u25CF");
			m.put((short)109, "\uD83D\uDD3E");
			m.put((short)110, "\u25A0");
			m.put((short)111, "\u25A1");
			m.put((short)112, "\uD83D\uDF90");
			m.put((short)113, "\u2751");
			m.put((short)114, "\u2752");
			m.put((short)115, "\u2B27");
			m.put((short)116, "\u29EB");
			m.put((short)117, "\u25C6");
			m.put((short)118, "\u2756");
			m.put((short)119, "\u2B25");
			m.put((short)120, "\u2327");
			m.put((short)121, "\u2BB9");
			m.put((short)122, "\u2318");
			m.put((short)123, "\uD83C\uDFF5");
			m.put((short)124, "\uD83C\uDFF6");
			m.put((short)125, "\uD83D\uDE76");
			m.put((short)126, "\uD83D\uDE77");
			m.put((short)128, "\u24EA");
			m.put((short)129, "\u2460");
			m.put((short)130, "\u2461");
			m.put((short)131, "\u2462");
			m.put((short)132, "\u2463");
			m.put((short)133, "\u2464");
			m.put((short)134, "\u2465");
			m.put((short)135, "\u2466");
			m.put((short)136, "\u2467");
			m.put((short)137, "\u2468");
			m.put((short)138, "\u2469");
			m.put((short)139, "\u24FF");
			m.put((short)140, "\u2776");
			m.put((short)141, "\u2777");
			m.put((short)142, "\u2778");
			m.put((short)143, "\u2779");
			m.put((short)144, "\u277A");
			m.put((short)145, "\u277B");
			m.put((short)146, "\u277C");
			m.put((short)147, "\u277D");
			m.put((short)148, "\u277E");
			m.put((short)149, "\u277F");
			m.put((short)150, "\uD83D\uDE62");
			m.put((short)151, "\uD83D\uDE60");
			m.put((short)152, "\uD83D\uDE61");
			m.put((short)153, "\uD83D\uDE63");
			m.put((short)154, "\uD83D\uDE5E");
			m.put((short)155, "\uD83D\uDE5C");
			m.put((short)156, "\uD83D\uDE5D");
			m.put((short)157, "\uD83D\uDE5F");
			m.put((short)158, "\u00B7");
			m.put((short)159, "\u2022");
			m.put((short)160, "\u25AA");
			m.put((short)161, "\u26AA");
			m.put((short)162, "\uD83D\uDF86");
			m.put((short)163, "\uD83D\uDF88");
			m.put((short)164, "\u25C9");
			m.put((short)165, "\u25CE");
			m.put((short)166, "\uD83D\uDD3F");
			m.put((short)167, "\u25AA");
			m.put((short)168, "\u25FB");
			m.put((short)169, "\uD83D\uDFC2");
			m.put((short)170, "\u2726");
			m.put((short)171, "\u2605");
			m.put((short)172, "\u2736");
			m.put((short)173, "\u2734");
			m.put((short)174, "\u2739");
			m.put((short)175, "\u2735");
			m.put((short)176, "\u2BD0");
			m.put((short)177, "\u2316");
			m.put((short)178, "\u27E1");
			m.put((short)179, "\u2311");
			m.put((short)180, "\u2BD1");
			m.put((short)181, "\u272A");
			m.put((short)182, "\u2730");
			m.put((short)183, "\uD83D\uDD50");
			m.put((short)184, "\uD83D\uDD51");
			m.put((short)185, "\uD83D\uDD52");
			m.put((short)186, "\uD83D\uDD53");
			m.put((short)187, "\uD83D\uDD54");
			m.put((short)188, "\uD83D\uDD55");
			m.put((short)189, "\uD83D\uDD56");
			m.put((short)190, "\uD83D\uDD57");
			m.put((short)191, "\uD83D\uDD58");
			m.put((short)192, "\uD83D\uDD59");
			m.put((short)193, "\uD83D\uDD5A");
			m.put((short)194, "\uD83D\uDD5B");
			m.put((short)195, "\u2BB0");
			m.put((short)196, "\u2BB1");
			m.put((short)197, "\u2BB2");
			m.put((short)198, "\u2BB3");
			m.put((short)199, "\u2BB4");
			m.put((short)200, "\u2BB5");
			m.put((short)201, "\u2BB6");
			m.put((short)202, "\u2BB7");
			m.put((short)203, "\uD83D\uDE6A");
			m.put((short)204, "\uD83D\uDE6B");
			m.put((short)205, "\uD83D\uDD95");
			m.put((short)206, "\uD83D\uDD94");
			m.put((short)207, "\uD83D\uDD97");
			m.put((short)208, "\uD83D\uDD96");
			m.put((short)209, "\uD83D\uDD90");
			m.put((short)210, "\uD83D\uDD91");
			m.put((short)211, "\uD83D\uDD92");
			m.put((short)212, "\uD83D\uDD93");
			m.put((short)213, "\u232B");
			m.put((short)214, "\u2326");
			m.put((short)215, "\u2B98");
			m.put((short)216, "\u2B9A");
			m.put((short)217, "\u2B99");
			m.put((short)218, "\u2B9B");
			m.put((short)219, "\u2B88");
			m.put((short)220, "\u2B8A");
			m.put((short)221, "\u2B89");
			m.put((short)222, "\u2B8B");
			m.put((short)223, "\uD83E\uDC68");
			m.put((short)224, "\uD83E\uDC6A");
			m.put((short)225, "\uD83E\uDC69");
			m.put((short)226, "\uD83E\uDC6B");
			m.put((short)227, "\uD83E\uDC6C");
			m.put((short)228, "\uD83E\uDC6D");
			m.put((short)229, "\uD83E\uDC6F");
			m.put((short)230, "\uD83E\uDC6E");
			m.put((short)231, "\uD83E\uDC78");
			m.put((short)232, "\uD83E\uDC7A");
			m.put((short)233, "\uD83E\uDC79");
			m.put((short)234, "\uD83E\uDC7B");
			m.put((short)235, "\uD83E\uDC7C");
			m.put((short)236, "\uD83E\uDC7D");
			m.put((short)237, "\uD83E\uDC7F");
			m.put((short)238, "\uD83E\uDC7E");
			m.put((short)239, "\u21E6");
			m.put((short)240, "\u21E8");
			m.put((short)241, "\u21E7");
			m.put((short)242, "\u21E9");
			m.put((short)243, "\u2B04");
			m.put((short)244, "\u21F3");
			m.put((short)245, "\u2B00");
			m.put((short)246, "\u2B01");
			m.put((short)247, "\u2B03");
			m.put((short)248, "\u2B02");
			m.put((short)249, "\uD83E\uDC6C");
			m.put((short)250, "\uD83E\uDC6D");
			m.put((short)251, "\uD83D\uDDF6");
			m.put((short)252, "\u2714");
			m.put((short)253, "\uD83D\uDDF7");
			m.put((short)254, "\uD83D\uDDF9");
			m.put((short)255, "\u229E"); // no equivalent for Windows logo, use ⊞ (SQUARED PLUS) \u229E or 🪟 (WINDOW) U+1FA9F

			fontMaps.put("Wingdings", m);
		}

		//map for 'Wingdings 2', source: https://www.alanwood.net/demos/wingdings-2.html
		{
			Map<Short, String> m = new HashMap<>();
			m.put((short)32, "\u0020");
			m.put((short)33, "\uD83D\uDD8A");
			m.put((short)34, "\uD83D\uDD8B");
			m.put((short)35, "\uD83D\uDD8C");
			m.put((short)36, "\uD83D\uDD8D");
			m.put((short)37, "\u2704");
			m.put((short)38, "\u2700");
			m.put((short)39, "\uD83D\uDD7E");
			m.put((short)40, "\uD83D\uDD7D");
			m.put((short)41, "\uD83D\uDDC5");
			m.put((short)42, "\uD83D\uDDC6");
			m.put((short)43, "\uD83D\uDDC7");
			m.put((short)44, "\uD83D\uDDC8");
			m.put((short)45, "\uD83D\uDDC9");
			m.put((short)46, "\uD83D\uDDCA");
			m.put((short)47, "\uD83D\uDDCB");
			m.put((short)48, "\uD83D\uDDCC");
			m.put((short)49, "\uD83D\uDDCD");
			m.put((short)50, "\uD83D\uDCCB");
			m.put((short)51, "\uD83D\uDDD1");
			m.put((short)52, "\uD83D\uDDD4");
			m.put((short)53, "\uD83D\uDDB5");
			m.put((short)54, "\uD83D\uDDB6");
			m.put((short)55, "\uD83D\uDDB7");
			m.put((short)56, "\uD83D\uDDB8");
			m.put((short)57, "\uD83D\uDDAD");
			m.put((short)58, "\uD83D\uDDAF");
			m.put((short)59, "\uD83D\uDDB1");
			m.put((short)60, "\uD83D\uDD92");
			m.put((short)61, "\uD83D\uDD93");
			m.put((short)62, "\uD83D\uDD98");
			m.put((short)63, "\uD83D\uDD99");
			m.put((short)64, "\uD83D\uDD9A");
			m.put((short)65, "\uD83D\uDD9B");
			m.put((short)66, "\uD83D\uDC48");
			m.put((short)67, "\uD83D\uDC49");
			m.put((short)68, "\uD83D\uDD9C");
			m.put((short)69, "\uD83D\uDD9D");
			m.put((short)70, "\uD83D\uDD9E");
			m.put((short)71, "\uD83D\uDD9F");
			m.put((short)72, "\uD83D\uDDA0");
			m.put((short)73, "\uD83D\uDDA1");
			m.put((short)74, "\uD83D\uDC46");
			m.put((short)75, "\uD83D\uDC47");
			m.put((short)76, "\uD83D\uDDA2");
			m.put((short)77, "\uD83D\uDDA3");
			m.put((short)78, "\uD83D\uDD91");
			m.put((short)79, "\uD83D\uDDF4");
			m.put((short)80, "\u2713");
			m.put((short)81, "\uD83D\uDDF5");
			m.put((short)82, "\u2611");
			m.put((short)83, "\u2612");
			m.put((short)84, "\u2612");
			m.put((short)85, "\u2BBE");
			m.put((short)86, "\u2BBF");
			m.put((short)87, "\u29B8");
			m.put((short)88, "\u29B8");
			m.put((short)89, "\uD83D\uDE71");
			m.put((short)90, "\uD83D\uDE74");
			m.put((short)91, "\uD83D\uDE72");
			m.put((short)92, "\uD83D\uDE73");
			m.put((short)93, "\u203D");
			m.put((short)94, "\uD83D\uDE79");
			m.put((short)95, "\uD83D\uDE7A");
			m.put((short)96, "\uD83D\uDE7B");
			m.put((short)97, "\uD83D\uDE66");
			m.put((short)98, "\uD83D\uDE64");
			m.put((short)99, "\uD83D\uDE65");
			m.put((short)100, "\uD83D\uDE67");
			m.put((short)101, "\uD83D\uDE5A");
			m.put((short)102, "\uD83D\uDE58");
			m.put((short)103, "\uD83D\uDE59");
			m.put((short)104, "\uD83D\uDE5B");
			m.put((short)105, "\u24EA");
			m.put((short)106, "\u2460");
			m.put((short)107, "\u2461");
			m.put((short)108, "\u2462");
			m.put((short)109, "\u2463");
			m.put((short)110, "\u2464");
			m.put((short)111, "\u2465");
			m.put((short)112, "\u2466");
			m.put((short)113, "\u2467");
			m.put((short)114, "\u2468");
			m.put((short)115, "\u2469");
			m.put((short)116, "\u24FF");
			m.put((short)117, "\u2776");
			m.put((short)118, "\u2777");
			m.put((short)119, "\u2778");
			m.put((short)120, "\u2779");
			m.put((short)121, "\u277A");
			m.put((short)122, "\u277B");
			m.put((short)123, "\u277C");
			m.put((short)124, "\u277D");
			m.put((short)125, "\u277E");
			m.put((short)126, "\u277F");
			m.put((short)128, "\u2609");
			m.put((short)129, "\uD83C\uDF15");
			m.put((short)130, "\u263D");
			m.put((short)131, "\u263E");
			m.put((short)132, "\u2E3F");
			m.put((short)133, "\u271D");
			m.put((short)134, "\uD83D\uDD47");
			m.put((short)135, "\uD83D\uDD5C");
			m.put((short)136, "\uD83D\uDD5D");
			m.put((short)137, "\uD83D\uDD5E");
			m.put((short)138, "\uD83D\uDD5F");
			m.put((short)139, "\uD83D\uDD60");
			m.put((short)140, "\uD83D\uDD61");
			m.put((short)141, "\uD83D\uDD62");
			m.put((short)142, "\uD83D\uDD63");
			m.put((short)143, "\uD83D\uDD64");
			m.put((short)144, "\uD83D\uDD65");
			m.put((short)145, "\uD83D\uDD66");
			m.put((short)146, "\uD83D\uDD67");
			m.put((short)147, "\uD83D\uDE68");
			m.put((short)148, "\uD83D\uDE69");
			m.put((short)149, "\u2022");
			m.put((short)150, "\u25CF");
			m.put((short)151, "\u26AB");
			m.put((short)152, "\u2B24");
			m.put((short)153, "\uD83D\uDF85");
			m.put((short)154, "\uD83D\uDF86");
			m.put((short)155, "\uD83D\uDF87");
			m.put((short)156, "\uD83D\uDF88");
			m.put((short)157, "\uD83D\uDF8A");
			m.put((short)158, "\u29BF");
			m.put((short)159, "\u25FE");
			m.put((short)160, "\u25A0");
			m.put((short)161, "\u25FC");
			m.put((short)162, "\u2B1B");
			m.put((short)163, "\u2B1C");
			m.put((short)164, "\uD83D\uDF91");
			m.put((short)165, "\uD83D\uDF92");
			m.put((short)166, "\uD83D\uDF93");
			m.put((short)167, "\uD83D\uDF94");
			m.put((short)168, "\u25A3");
			m.put((short)169, "\uD83D\uDF95");
			m.put((short)170, "\uD83D\uDF96");
			m.put((short)171, "\uD83D\uDF97");
			m.put((short)172, "\u2B29");
			m.put((short)173, "\u2B25");
			m.put((short)174, "\u25C6");
			m.put((short)175, "\u25C7");
			m.put((short)176, "\uD83D\uDF9A");
			m.put((short)177, "\u25C8");
			m.put((short)178, "\uD83D\uDF9B");
			m.put((short)179, "\uD83D\uDF9C");
			m.put((short)180, "\uD83D\uDF9D");
			m.put((short)181, "\u2B2A");
			m.put((short)182, "\u2B27");
			m.put((short)183, "\u29EB");
			m.put((short)184, "\u25CA");
			m.put((short)185, "\uD83D\uDFA0");
			m.put((short)186, "\u25D6");
			m.put((short)187, "\u25D7");
			m.put((short)188, "\u2BCA");
			m.put((short)189, "\u2BCB");
			m.put((short)190, "\u25FC");
			m.put((short)191, "\u2B25");
			m.put((short)192, "\u2B1F");
			m.put((short)193, "\u2BC2");
			m.put((short)194, "\u2B23");
			m.put((short)195, "\u2B22");
			m.put((short)196, "\u2BC3");
			m.put((short)197, "\u2BC4");
			m.put((short)198, "\uD83D\uDFA1");
			m.put((short)199, "\uD83D\uDFA2");
			m.put((short)200, "\uD83D\uDFA3");
			m.put((short)201, "\uD83D\uDFA4");
			m.put((short)202, "\uD83D\uDFA5");
			m.put((short)203, "\uD83D\uDFA6");
			m.put((short)204, "\uD83D\uDFA7");
			m.put((short)205, "\uD83D\uDFA8");
			m.put((short)206, "\uD83D\uDFA9");
			m.put((short)207, "\uD83D\uDFAA");
			m.put((short)208, "\uD83D\uDFAB");
			m.put((short)209, "\uD83D\uDFAC");
			m.put((short)210, "\uD83D\uDFAD");
			m.put((short)211, "\uD83D\uDFAE");
			m.put((short)212, "\uD83D\uDFAF");
			m.put((short)213, "\uD83D\uDFB0");
			m.put((short)214, "\uD83D\uDFB1");
			m.put((short)215, "\uD83D\uDFB2");
			m.put((short)216, "\uD83D\uDFB3");
			m.put((short)217, "\uD83D\uDFB4");
			m.put((short)218, "\uD83D\uDFB5");
			m.put((short)219, "\uD83D\uDFB6");
			m.put((short)220, "\uD83D\uDFB7");
			m.put((short)221, "\uD83D\uDFB8");
			m.put((short)222, "\uD83D\uDFB9");
			m.put((short)223, "\uD83D\uDFBA");
			m.put((short)224, "\uD83D\uDFBB");
			m.put((short)225, "\uD83D\uDFBC");
			m.put((short)226, "\uD83D\uDFBD");
			m.put((short)227, "\uD83D\uDFBE");
			m.put((short)228, "\uD83D\uDFBF");
			m.put((short)229, "\uD83D\uDFC0");
			m.put((short)230, "\uD83D\uDFC2");
			m.put((short)231, "\uD83D\uDFC4");
			m.put((short)232, "\u2726");
			m.put((short)233, "\uD83D\uDFC9");
			m.put((short)234, "\u2605");
			m.put((short)235, "\u2736");
			m.put((short)236, "\uD83D\uDFCB");
			m.put((short)237, "\u2737");
			m.put((short)238, "\uD83D\uDFCF");
			m.put((short)239, "\uD83D\uDFD2");
			m.put((short)240, "\u2739");
			m.put((short)241, "\uD83D\uDFC3");
			m.put((short)242, "\uD83D\uDFC7");
			m.put((short)243, "\u272F");
			m.put((short)244, "\uD83D\uDFCD");
			m.put((short)245, "\uD83D\uDFD4");
			m.put((short)246, "\u2BCC");
			m.put((short)247, "\u2BCD");
			m.put((short)248, "\u203B");
			m.put((short)249, "\u2042");
			fontMaps.put("Wingdings 2", m);
		}

		//map for 'Wingdings 3', source: https://www.alanwood.net/demos/wingdings-3.html
		{
			Map<Short, String> m = new HashMap<>();
			m.put((short)32, "\u0020");
			m.put((short)33, "\u2B60");
			m.put((short)34, "\u2B62");
			m.put((short)35, "\u2B61");
			m.put((short)36, "\u2B63");
			m.put((short)37, "\u2B66");
			m.put((short)38, "\u2B67");
			m.put((short)39, "\u2B69");
			m.put((short)40, "\u2B68");
			m.put((short)41, "\u2B70");
			m.put((short)42, "\u2B72");
			m.put((short)43, "\u2B71");
			m.put((short)44, "\u2B73");
			m.put((short)45, "\u2B76");
			m.put((short)46, "\u2B78");
			m.put((short)47, "\u2B7B");
			m.put((short)48, "\u2B7D");
			m.put((short)49, "\u2B64");
			m.put((short)50, "\u2B65");
			m.put((short)51, "\u2B6A");
			m.put((short)52, "\u2B6C");
			m.put((short)53, "\u2B6B");
			m.put((short)54, "\u2B6D");
			m.put((short)55, "\u2B4D");
			m.put((short)56, "\u2BA0");
			m.put((short)57, "\u2BA1");
			m.put((short)58, "\u2BA2");
			m.put((short)59, "\u2BA3");
			m.put((short)60, "\u2BA4");
			m.put((short)61, "\u2BA5");
			m.put((short)62, "\u2BA6");
			m.put((short)63, "\u2BA7");
			m.put((short)64, "\u2B90");
			m.put((short)65, "\u2B91");
			m.put((short)66, "\u2B92");
			m.put((short)67, "\u2B93");
			m.put((short)68, "\u2B80");
			m.put((short)69, "\u2B83");
			m.put((short)70, "\u2B7E");
			m.put((short)71, "\u2B7F");
			m.put((short)72, "\u2B84");
			m.put((short)73, "\u2B86");
			m.put((short)74, "\u2B85");
			m.put((short)75, "\u2B87");
			m.put((short)76, "\u2B8F");
			m.put((short)77, "\u2B8D");
			m.put((short)78, "\u2B8E");
			m.put((short)79, "\u2B8C");
			m.put((short)80, "\u2B6E");
			m.put((short)81, "\u2B6F");
			m.put((short)82, "\u238B");
			m.put((short)83, "\u2324");
			m.put((short)84, "\u2303");
			m.put((short)85, "\u2325");
			m.put((short)86, "\u23B5");
			m.put((short)87, "\u237D");
			m.put((short)88, "\u21EA");
			m.put((short)89, "\u2BB8");
			m.put((short)90, "\uD83E\uDCA0");
			m.put((short)91, "\uD83E\uDCA1");
			m.put((short)92, "\uD83E\uDCA2");
			m.put((short)93, "\uD83E\uDCA3");
			m.put((short)94, "\uD83E\uDCA4");
			m.put((short)95, "\uD83E\uDCA5");
			m.put((short)96, "\uD83E\uDCA6");
			m.put((short)97, "\uD83E\uDCA7");
			m.put((short)98, "\uD83E\uDCA8");
			m.put((short)99, "\uD83E\uDCA9");
			m.put((short)100, "\uD83E\uDCAA");
			m.put((short)101, "\uD83E\uDCAB");
			m.put((short)102, "\u2190");
			m.put((short)103, "\u2192");
			m.put((short)104, "\u2191");
			m.put((short)105, "\u2193");
			m.put((short)106, "\u2196");
			m.put((short)107, "\u2197");
			m.put((short)108, "\u2199");
			m.put((short)109, "\u2198");
			m.put((short)110, "\uD83E\uDC58");
			m.put((short)111, "\uD83E\uDC59");
			m.put((short)112, "\u25B2");
			m.put((short)113, "\u25BC");
			m.put((short)114, "\u25B3");
			m.put((short)115, "\u25BD");
			m.put((short)116, "\u25C4");
			m.put((short)117, "\u25BA");
			m.put((short)118, "\u25C1");
			m.put((short)119, "\u25B7");
			m.put((short)120, "\u25E3");
			m.put((short)121, "\u25E2");
			m.put((short)122, "\u25E4");
			m.put((short)123, "\u25E5");
			m.put((short)124, "\uD83D\uDF80");
			m.put((short)125, "\uD83D\uDF82");
			m.put((short)126, "\uD83D\uDF81");
			m.put((short)128, "\uD83D\uDF83");
			m.put((short)129, "\u25B2");
			m.put((short)130, "\u25BC");
			m.put((short)131, "\u25C0");
			m.put((short)132, "\u25B6");
			m.put((short)133, "\u2B9C");
			m.put((short)134, "\u2B9E");
			m.put((short)135, "\u2B9D");
			m.put((short)136, "\u2B9F");
			m.put((short)137, "\uD83E\uDC10");
			m.put((short)138, "\uD83E\uDC12");
			m.put((short)139, "\uD83E\uDC11");
			m.put((short)140, "\uD83E\uDC13");
			m.put((short)141, "\uD83E\uDC14");
			m.put((short)142, "\uD83E\uDC16");
			m.put((short)143, "\uD83E\uDC15");
			m.put((short)144, "\uD83E\uDC17");
			m.put((short)145, "\uD83E\uDC18");
			m.put((short)146, "\uD83E\uDC1A");
			m.put((short)147, "\uD83E\uDC19");
			m.put((short)148, "\uD83E\uDC1B");
			m.put((short)149, "\uD83E\uDC1C");
			m.put((short)150, "\uD83E\uDC1E");
			m.put((short)151, "\uD83E\uDC1D");
			m.put((short)152, "\uD83E\uDC1F");
			m.put((short)153, "\uD83E\uDC00");
			m.put((short)154, "\uD83E\uDC02");
			m.put((short)155, "\uD83E\uDC01");
			m.put((short)156, "\uD83E\uDC03");
			m.put((short)157, "\uD83E\uDC04");
			m.put((short)158, "\uD83E\uDC06");
			m.put((short)159, "\uD83E\uDC05");
			m.put((short)160, "\uD83E\uDC07");
			m.put((short)161, "\uD83E\uDC08");
			m.put((short)162, "\uD83E\uDC0A");
			m.put((short)163, "\uD83E\uDC09");
			m.put((short)164, "\uD83E\uDC0B");
			m.put((short)165, "\uD83E\uDC20");
			m.put((short)166, "\uD83E\uDC22");
			m.put((short)167, "\uD83E\uDC24");
			m.put((short)168, "\uD83E\uDC26");
			m.put((short)169, "\uD83E\uDC28");
			m.put((short)170, "\uD83E\uDC2A");
			m.put((short)171, "\uD83E\uDC2C");
			m.put((short)172, "\uD83E\uDC9C");
			m.put((short)173, "\uD83E\uDC9D");
			m.put((short)174, "\uD83E\uDC9E");
			m.put((short)175, "\uD83E\uDC9F");
			m.put((short)176, "\uD83E\uDC2E");
			m.put((short)177, "\uD83E\uDC30");
			m.put((short)178, "\uD83E\uDC32");
			m.put((short)179, "\uD83E\uDC34");
			m.put((short)180, "\uD83E\uDC36");
			m.put((short)181, "\uD83E\uDC38");
			m.put((short)182, "\uD83E\uDC3A");
			m.put((short)183, "\uD83E\uDC39");
			m.put((short)184, "\uD83E\uDC3B");
			m.put((short)185, "\uD83E\uDC98");
			m.put((short)186, "\uD83E\uDC9A");
			m.put((short)187, "\uD83E\uDC99");
			m.put((short)188, "\uD83E\uDC9B");
			m.put((short)189, "\uD83E\uDC3C");
			m.put((short)190, "\uD83E\uDC3E");
			m.put((short)191, "\uD83E\uDC3D");
			m.put((short)192, "\uD83E\uDC3F");
			m.put((short)193, "\uD83E\uDC40");
			m.put((short)194, "\uD83E\uDC42");
			m.put((short)195, "\uD83E\uDC41");
			m.put((short)196, "\uD83E\uDC43");
			m.put((short)197, "\uD83E\uDC44");
			m.put((short)198, "\uD83E\uDC46");
			m.put((short)199, "\uD83E\uDC45");
			m.put((short)200, "\uD83E\uDC47");
			m.put((short)201, "\u2BA8");
			m.put((short)202, "\u2BA9");
			m.put((short)203, "\u2BAA");
			m.put((short)204, "\u2BAB");
			m.put((short)205, "\u2BAC");
			m.put((short)206, "\u2BAD");
			m.put((short)207, "\u2BAE");
			m.put((short)208, "\u2BAF");
			m.put((short)209, "\uD83E\uDC60");
			m.put((short)210, "\uD83E\uDC62");
			m.put((short)211, "\uD83E\uDC61");
			m.put((short)212, "\uD83E\uDC63");
			m.put((short)213, "\uD83E\uDC64");
			m.put((short)214, "\uD83E\uDC65");
			m.put((short)215, "\uD83E\uDC67");
			m.put((short)216, "\uD83E\uDC66");
			m.put((short)217, "\uD83E\uDC70");
			m.put((short)218, "\uD83E\uDC72");
			m.put((short)219, "\uD83E\uDC71");
			m.put((short)220, "\uD83E\uDC73");
			m.put((short)221, "\uD83E\uDC74");
			m.put((short)222, "\uD83E\uDC75");
			m.put((short)223, "\uD83E\uDC77");
			m.put((short)224, "\uD83E\uDC76");
			m.put((short)225, "\uD83E\uDC80");
			m.put((short)226, "\uD83E\uDC82");
			m.put((short)227, "\uD83E\uDC81");
			m.put((short)228, "\uD83E\uDC83");
			m.put((short)229, "\uD83E\uDC84");
			m.put((short)230, "\uD83E\uDC85");
			m.put((short)231, "\uD83E\uDC87");
			m.put((short)232, "\uD83E\uDC86");
			m.put((short)233, "\uD83E\uDC90");
			m.put((short)234, "\uD83E\uDC92");
			m.put((short)235, "\uD83E\uDC91");
			m.put((short)236, "\uD83E\uDC93");
			m.put((short)237, "\uD83E\uDC94");
			m.put((short)238, "\uD83E\uDC96");
			m.put((short)239, "\uD83E\uDC95");
			m.put((short)240, "\uD83E\uDC97");
			fontMaps.put("Wingdings 3", m);
		}

		//map for 'Webdings', source: https://www.alanwood.net/demos/webdings.html
		{
			Map<Short, String> m = new HashMap<>();
			m.put((short)32, "\u0020");
			m.put((short)33, "\uD83D\uDD77");
			m.put((short)34, "\uD83D\uDD78");
			m.put((short)35, "\uD83D\uDD72");
			m.put((short)36, "\uD83D\uDD76");
			m.put((short)37, "\uD83C\uDFC6");
			m.put((short)38, "\uD83C\uDF96");
			m.put((short)39, "\uD83D\uDD87");
			m.put((short)40, "\uD83D\uDDE8");
			m.put((short)41, "\uD83D\uDDE9");
			m.put((short)42, "\uD83D\uDDF0");
			m.put((short)43, "\uD83D\uDDF1");
			m.put((short)44, "\uD83C\uDF36");
			m.put((short)45, "\uD83C\uDF97");
			m.put((short)46, "\uD83D\uDE7E");
			m.put((short)47, "\uD83D\uDE7C");
			m.put((short)48, "\uD83D\uDDD5");
			m.put((short)49, "\uD83D\uDDD6");
			m.put((short)50, "\uD83D\uDDD7");
			m.put((short)51, "\u23F4");
			m.put((short)52, "\u23F5");
			m.put((short)53, "\u23F6");
			m.put((short)54, "\u23F7");
			m.put((short)55, "\u23EA");
			m.put((short)56, "\u23E9");
			m.put((short)57, "\u23EE");
			m.put((short)58, "\u23ED");
			m.put((short)59, "\u23F8");
			m.put((short)60, "\u23F9");
			m.put((short)61, "\u23FA");
			m.put((short)62, "\uD83D\uDDDA");
			m.put((short)63, "\uD83D\uDDF3");
			m.put((short)64, "\uD83D\uDEE0");
			m.put((short)65, "\uD83C\uDFD7");
			m.put((short)66, "\uD83C\uDFD8");
			m.put((short)67, "\uD83C\uDFD9");
			m.put((short)68, "\uD83C\uDFDA");
			m.put((short)69, "\uD83C\uDFDC");
			m.put((short)70, "\uD83C\uDFED");
			m.put((short)71, "\uD83C\uDFDB");
			m.put((short)72, "\uD83C\uDFE0");
			m.put((short)73, "\uD83C\uDFD6");
			m.put((short)74, "\uD83C\uDFDD");
			m.put((short)75, "\uD83D\uDEE3");
			m.put((short)76, "\uD83D\uDD0D");
			m.put((short)77, "\uD83C\uDFD4");
			m.put((short)78, "\uD83D\uDC41");
			m.put((short)79, "\uD83D\uDC42");
			m.put((short)80, "\uD83C\uDFDE");
			m.put((short)81, "\uD83C\uDFD5");
			m.put((short)82, "\uD83D\uDEE4");
			m.put((short)83, "\uD83C\uDFDF");
			m.put((short)84, "\uD83D\uDEF3");
			m.put((short)85, "\uD83D\uDD6C");
			m.put((short)86, "\uD83D\uDD6B");
			m.put((short)87, "\uD83D\uDD68");
			m.put((short)88, "\uD83D\uDD08");
			m.put((short)89, "\uD83C\uDF94");
			m.put((short)90, "\uD83C\uDF95");
			m.put((short)91, "\uD83D\uDDEC");
			m.put((short)92, "\uD83D\uDE7D");
			m.put((short)93, "\uD83D\uDDED");
			m.put((short)94, "\uD83D\uDDEA");
			m.put((short)95, "\uD83D\uDDEB");
			m.put((short)96, "\u2B94");
			m.put((short)97, "\u2714");
			m.put((short)98, "\uD83D\uDEB2");
			m.put((short)99, "\u25A1");
			m.put((short)100, "\uD83D\uDEE1");
			m.put((short)101, "\uD83D\uDCE6");
			m.put((short)102, "\uD83D\uDEF1");
			m.put((short)103, "\u25A0");
			m.put((short)104, "\uD83D\uDE91");
			m.put((short)105, "\uD83D\uDEC8");
			m.put((short)106, "\uD83D\uDEE9");
			m.put((short)107, "\uD83D\uDEF0");
			m.put((short)108, "\uD83D\uDFC8");
			m.put((short)109, "\uD83D\uDD74");
			m.put((short)110, "\u26AB");
			m.put((short)111, "\uD83D\uDEE5");
			m.put((short)112, "\uD83D\uDE94");
			m.put((short)113, "\uD83D\uDDD8");
			m.put((short)114, "\uD83D\uDDD9");
			m.put((short)115, "\u2753");
			m.put((short)116, "\uD83D\uDEF2");
			m.put((short)117, "\uD83D\uDE87");
			m.put((short)118, "\uD83D\uDE8D");
			m.put((short)119, "\u26F3");
			m.put((short)120, "\uD83D\uDEC7");
			m.put((short)121, "\u2296");
			m.put((short)122, "\uD83D\uDEAD");
			m.put((short)123, "\uD83D\uDDEE");
			m.put((short)124, "\u007C");
			m.put((short)125, "\uD83D\uDDEF");
			m.put((short)126, "\uD83D\uDDF2");
			m.put((short)128, "\uD83D\uDEB9");
			m.put((short)129, "\uD83D\uDEBA");
			m.put((short)130, "\uD83D\uDEC9");
			m.put((short)131, "\uD83D\uDECA");
			m.put((short)132, "\uD83D\uDEBC");
			m.put((short)133, "\uD83D\uDC7D");
			m.put((short)134, "\uD83C\uDFCB");
			m.put((short)135, "\u26F7");
			m.put((short)136, "\uD83C\uDFC2");
			m.put((short)137, "\uD83C\uDFCC");
			m.put((short)138, "\uD83C\uDFCA");
			m.put((short)139, "\uD83C\uDFC4");
			m.put((short)140, "\uD83C\uDFCD");
			m.put((short)141, "\uD83C\uDFCE");
			m.put((short)142, "\uD83D\uDE98");
			m.put((short)143, "\uD83D\uDDE0");
			m.put((short)144, "\uD83D\uDEE2");
			m.put((short)145, "\uD83D\uDCB0");
			m.put((short)146, "\uD83C\uDFF7");
			m.put((short)147, "\uD83D\uDCB3");
			m.put((short)148, "\uD83D\uDC6A");
			m.put((short)149, "\uD83D\uDDE1");
			m.put((short)150, "\uD83D\uDDE2");
			m.put((short)151, "\uD83D\uDDE3");
			m.put((short)152, "\u272F");
			m.put((short)153, "\uD83D\uDD84");
			m.put((short)154, "\uD83D\uDD85");
			m.put((short)155, "\uD83D\uDD83");
			m.put((short)156, "\uD83D\uDD86");
			m.put((short)157, "\uD83D\uDDB9");
			m.put((short)158, "\uD83D\uDDBA");
			m.put((short)159, "\uD83D\uDDBB");
			m.put((short)160, "\uD83D\uDD75");
			m.put((short)161, "\uD83D\uDD70");
			m.put((short)162, "\uD83D\uDDBD");
			m.put((short)163, "\uD83D\uDDBE");
			m.put((short)164, "\uD83D\uDCCB");
			m.put((short)165, "\uD83D\uDDD2");
			m.put((short)166, "\uD83D\uDDD3");
			m.put((short)167, "\uD83D\uDCD6");
			m.put((short)168, "\uD83D\uDCDA");
			m.put((short)169, "\uD83D\uDDDE");
			m.put((short)170, "\uD83D\uDDDF");
			m.put((short)171, "\uD83D\uDDC3");
			m.put((short)172, "\uD83D\uDDC2");
			m.put((short)173, "\uD83D\uDDBC");
			m.put((short)174, "\uD83C\uDFAD");
			m.put((short)175, "\uD83C\uDF9C");
			m.put((short)176, "\uD83C\uDF98");
			m.put((short)177, "\uD83C\uDF99");
			m.put((short)178, "\uD83C\uDFA7");
			m.put((short)179, "\uD83D\uDCBF");
			m.put((short)180, "\uD83C\uDF9E");
			m.put((short)181, "\uD83D\uDCF7");
			m.put((short)182, "\uD83C\uDF9F");
			m.put((short)183, "\uD83C\uDFAC");
			m.put((short)184, "\uD83D\uDCFD");
			m.put((short)185, "\uD83D\uDCF9");
			m.put((short)186, "\uD83D\uDCFE");
			m.put((short)187, "\uD83D\uDCFB");
			m.put((short)188, "\uD83C\uDF9A");
			m.put((short)189, "\uD83C\uDF9B");
			m.put((short)190, "\uD83D\uDCFA");
			m.put((short)191, "\uD83D\uDCBB");
			m.put((short)192, "\uD83D\uDDA5");
			m.put((short)193, "\uD83D\uDDA6");
			m.put((short)194, "\uD83D\uDDA7");
			m.put((short)195, "\uD83D\uDD79");
			m.put((short)196, "\uD83C\uDFAE");
			m.put((short)197, "\uD83D\uDD7B");
			m.put((short)198, "\uD83D\uDD7C");
			m.put((short)199, "\uD83D\uDCDF");
			m.put((short)200, "\uD83D\uDD81");
			m.put((short)201, "\uD83D\uDD80");
			m.put((short)202, "\uD83D\uDDA8");
			m.put((short)203, "\uD83D\uDDA9");
			m.put((short)204, "\uD83D\uDDBF");
			m.put((short)205, "\uD83D\uDDAA");
			m.put((short)206, "\uD83D\uDDDC");
			m.put((short)207, "\uD83D\uDD12");
			m.put((short)208, "\uD83D\uDD13");
			m.put((short)209, "\uD83D\uDDDD");
			m.put((short)210, "\uD83D\uDCE5");
			m.put((short)211, "\uD83D\uDCE4");
			m.put((short)212, "\uD83D\uDD73");
			m.put((short)213, "\uD83C\uDF23");
			m.put((short)214, "\uD83C\uDF24");
			m.put((short)215, "\uD83C\uDF25");
			m.put((short)216, "\uD83C\uDF26");
			m.put((short)217, "\u2601");
			m.put((short)218, "\uD83C\uDF27");
			m.put((short)219, "\uD83C\uDF28");
			m.put((short)220, "\uD83C\uDF29");
			m.put((short)221, "\uD83C\uDF2A");
			m.put((short)222, "\uD83C\uDF2C");
			m.put((short)223, "\uD83C\uDF2B");
			m.put((short)224, "\uD83C\uDF1C");
			m.put((short)225, "\uD83C\uDF21");
			m.put((short)226, "\uD83D\uDECB");
			m.put((short)227, "\uD83D\uDECF");
			m.put((short)228, "\uD83C\uDF7D");
			m.put((short)229, "\uD83C\uDF78");
			m.put((short)230, "\uD83D\uDECE");
			m.put((short)231, "\uD83D\uDECD");
			m.put((short)232, "\u24C5");
			m.put((short)233, "\u267F");
			m.put((short)234, "\uD83D\uDEC6");
			m.put((short)235, "\uD83D\uDD88");
			m.put((short)236, "\uD83C\uDF93");
			m.put((short)237, "\uD83D\uDDE4");
			m.put((short)238, "\uD83D\uDDE5");
			m.put((short)239, "\uD83D\uDDE6");
			m.put((short)240, "\uD83D\uDDE7");
			m.put((short)241, "\uD83D\uDEEA");
			m.put((short)242, "\uD83D\uDC3F");
			m.put((short)243, "\uD83D\uDC26");
			m.put((short)244, "\uD83D\uDC1F");
			m.put((short)245, "\uD83D\uDC15");
			m.put((short)246, "\uD83D\uDC08");
			m.put((short)247, "\uD83D\uDE6C");
			m.put((short)248, "\uD83D\uDE6E");
			m.put((short)249, "\uD83D\uDE6D");
			m.put((short)250, "\uD83D\uDE6F");
			m.put((short)251, "\uD83D\uDDFA");
			m.put((short)252, "\uD83C\uDF0D");
			m.put((short)253, "\uD83C\uDF0F");
			m.put((short)254, "\uD83C\uDF0E");
			m.put((short)255, "\uD83D\uDD4A");
			fontMaps.put("Webdings", m);
		}
		
		//map for 'Symbol', source: https://www.alanwood.net/demos/symbol.html
		{
	        Map<Short, String> m = new HashMap<>();
	        m.put((short)32, "\u0020");
	        m.put((short)33, "\u0021");
	        m.put((short)34, "\u2200");
	        m.put((short)35, "\u0023");
	        m.put((short)36, "\u2203");
	        m.put((short)37, "\u0025");
	        m.put((short)38, "\u0026");
	        m.put((short)39, "\u220D");
	        m.put((short)40, "\u0028");
	        m.put((short)41, "\u0029");
	        m.put((short)42, "\u2217");
	        m.put((short)43, "\u002B");
	        m.put((short)44, "\u002C");
	        m.put((short)45, "\u2212");
	        m.put((short)46, "\u002E");
	        m.put((short)47, "\u002F");
	        m.put((short)48, "\u0030");
	        m.put((short)49, "\u0031");
	        m.put((short)50, "\u0032");
	        m.put((short)51, "\u0033");
	        m.put((short)52, "\u0034");
	        m.put((short)53, "\u0035");
	        m.put((short)54, "\u0036");
	        m.put((short)55, "\u0037");
	        m.put((short)56, "\u0038");
	        m.put((short)57, "\u0039");
	        m.put((short)58, "\u003A");
	        m.put((short)59, "\u003B");
	        m.put((short)60, "\u003C");
	        m.put((short)61, "\u003D");
	        m.put((short)62, "\u003E");
	        m.put((short)63, "\u003F");
	        m.put((short)64, "\u2245");
	        m.put((short)65, "\u0391");
	        m.put((short)66, "\u0392");
	        m.put((short)67, "\u03A7");
	        m.put((short)68, "\u0394");
	        m.put((short)69, "\u0395");
	        m.put((short)70, "\u03A6");
	        m.put((short)71, "\u0393");
	        m.put((short)72, "\u0397");
	        m.put((short)73, "\u0399");
	        m.put((short)74, "\u03D1");
	        m.put((short)75, "\u039A");
	        m.put((short)76, "\u039B");
	        m.put((short)77, "\u039C");
	        m.put((short)78, "\u039D");
	        m.put((short)79, "\u039F");
	        m.put((short)80, "\u03A0");
	        m.put((short)81, "\u0398");
	        m.put((short)82, "\u03A1");
	        m.put((short)83, "\u03A3");
	        m.put((short)84, "\u03A4");
	        m.put((short)85, "\u03A5");
	        m.put((short)86, "\u03C2");
	        m.put((short)87, "\u03A9");
	        m.put((short)88, "\u039E");
	        m.put((short)89, "\u03A8");
	        m.put((short)90, "\u0396");
	        m.put((short)91, "\u005B");
	        m.put((short)92, "\u2234");
	        m.put((short)93, "\u005D");
	        m.put((short)94, "\u22A5");
	        m.put((short)95, "\u005F");
	        m.put((short)97, "\u03B1");
	        m.put((short)98, "\u03B2");
	        m.put((short)99, "\u03C7");
	        m.put((short)100, "\u03B4");
	        m.put((short)101, "\u03B5");
	        m.put((short)102, "\u03C6");
	        m.put((short)103, "\u03B3");
	        m.put((short)104, "\u03B7");
	        m.put((short)105, "\u03B9");
	        m.put((short)106, "\u03D5");
	        m.put((short)107, "\u03BA");
	        m.put((short)108, "\u03BB");
	        m.put((short)109, "\u03BC");
	        m.put((short)110, "\u03BD");
	        m.put((short)111, "\u03BF");
	        m.put((short)112, "\u03C0");
	        m.put((short)113, "\u03B8");
	        m.put((short)114, "\u03C1");
	        m.put((short)115, "\u03C3");
	        m.put((short)116, "\u03C4");
	        m.put((short)117, "\u03C5");
	        m.put((short)118, "\u03D6");
	        m.put((short)119, "\u03C9");
	        m.put((short)120, "\u03BE");
	        m.put((short)121, "\u03C8");
	        m.put((short)122, "\u03B6");
	        m.put((short)123, "\u007B");
	        m.put((short)124, "\u007C");
	        m.put((short)125, "\u007D");
	        m.put((short)126, "\u223C");
	        m.put((short)161, "\u03D2");
	        m.put((short)162, "\u2032");
	        m.put((short)163, "\u2264");
	        m.put((short)164, "\u2044");
	        m.put((short)165, "\u221E");
	        m.put((short)166, "\u0192");
	        m.put((short)167, "\u2663");
	        m.put((short)168, "\u2666");
	        m.put((short)169, "\u2665");
	        m.put((short)170, "\u2660");
	        m.put((short)171, "\u2194");
	        m.put((short)172, "\u2190");
	        m.put((short)173, "\u2191");
	        m.put((short)174, "\u2192");
	        m.put((short)175, "\u2193");
	        m.put((short)176, "\u00B0");
	        m.put((short)177, "\u00B1");
	        m.put((short)178, "\u2033");
	        m.put((short)179, "\u2265");
	        m.put((short)180, "\u00D7");
	        m.put((short)181, "\u221D");
	        m.put((short)182, "\u2202");
	        m.put((short)183, "\u2022");
	        m.put((short)184, "\u00F7");
	        m.put((short)185, "\u2260");
	        m.put((short)186, "\u2261");
	        m.put((short)187, "\u2248");
	        m.put((short)188, "\u2026");
	        m.put((short)189, "\u23D0");
	        m.put((short)190, "\u23AF");
	        m.put((short)191, "\u21B5");
	        m.put((short)192, "\u2135");
	        m.put((short)193, "\u2111");
	        m.put((short)194, "\u211C");
	        m.put((short)195, "\u2118");
	        m.put((short)196, "\u2297");
	        m.put((short)197, "\u2295");
	        m.put((short)198, "\u2205");
	        m.put((short)199, "\u2229");
	        m.put((short)200, "\u222A");
	        m.put((short)201, "\u2283");
	        m.put((short)202, "\u2287");
	        m.put((short)203, "\u2284");
	        m.put((short)204, "\u2282");
	        m.put((short)205, "\u2286");
	        m.put((short)206, "\u2208");
	        m.put((short)207, "\u2209");
	        m.put((short)208, "\u2220");
	        m.put((short)209, "\u2207");
	        m.put((short)210, "\u00AE");
	        m.put((short)211, "\u00A9");
	        m.put((short)212, "\u2122");
	        m.put((short)213, "\u220F");
	        m.put((short)214, "\u221A");
	        m.put((short)215, "\u22C5");
	        m.put((short)216, "\u00AC");
	        m.put((short)217, "\u2227");
	        m.put((short)218, "\u2228");
	        m.put((short)219, "\u21D4");
	        m.put((short)220, "\u21D0");
	        m.put((short)221, "\u21D1");
	        m.put((short)222, "\u21D2");
	        m.put((short)223, "\u21D3");
	        m.put((short)224, "\u25CA");
	        m.put((short)225, "\u2329");
	        m.put((short)226, "\u00AE");
	        m.put((short)227, "\u00A9");
	        m.put((short)228, "\u2122");
	        m.put((short)229, "\u2211");
	        m.put((short)230, "\u239B");
	        m.put((short)231, "\u239C");
	        m.put((short)232, "\u239D");
	        m.put((short)233, "\u23A1");
	        m.put((short)234, "\u23A2");
	        m.put((short)235, "\u23A3");
	        m.put((short)236, "\u23A7");
	        m.put((short)237, "\u23A8");
	        m.put((short)238, "\u23A9");
	        m.put((short)239, "\u23AA");
	        m.put((short)240, "\u20AC");
	        m.put((short)241, "\u232A");
	        m.put((short)242, "\u222B");
	        m.put((short)243, "\u2320");
	        m.put((short)244, "\u23AE");
	        m.put((short)245, "\u2321");
	        m.put((short)246, "\u239E");
	        m.put((short)247, "\u239F");
	        m.put((short)248, "\u23A0");
	        m.put((short)249, "\u23A4");
	        m.put((short)250, "\u23A5");
	        m.put((short)251, "\u23A6");
	        m.put((short)252, "\u23AB");
	        m.put((short)253, "\u23AC");
	        m.put((short)254, "\u23AD");
	        fontMaps.put("Symbol", m);
		}
	}

	public static String getUnicodeReplacementChar(String fontName, short value) {

		Map<Short,String> fontMap = fontMaps.get(fontName);
		if (fontMap==null) {
			return null;
		}
		return fontMap.get(value);
	}
}
