/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts;

import java.awt.font.NumericShaper;
import java.util.concurrent.ExecutionException;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.writer.SymbolMapper;
import org.docx4j.fonts.CJKToEnglish;
import org.docx4j.fonts.GlyphCheck;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.properties.Property;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTLanguage;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.PPr;
import org.docx4j.wml.RFonts;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STHint;
import org.docx4j.wml.Style;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class RunFontSelector {
    protected static Logger log = LoggerFactory.getLogger(RunFontSelector.class);
    private WordprocessingMLPackage wordMLPackage;
    private RunFontCharacterVisitor vis;
    private RunFontActionType outputType;
    String fallbackFont = null;
    CTLanguage themeFontLang = null;
    public static final String CSS_NAME = "font-family";
    public static final String FO_NAME = "font-family";
    private Style defaultParagraphStyle;
    private String defaultFont = null;
    private boolean spacePreserve;
    private static String EMOJI_FONT = null;
    private static NumericShaper numericShaperArabicIndic = null;
    private static NativeDigitsSetting nativeDigitsSetting = null;
    private static MicrosoftWordNumeralOption microsoftWordNumeralOption = null;

    public RunFontSelector(WordprocessingMLPackage wordMLPackage, RunFontCharacterVisitor visitor, RunFontActionType outputType) {
        this.wordMLPackage = wordMLPackage;
        this.vis = visitor;
        this.outputType = outputType;
        this.vis.setRunFontSelector(this);
        this.fallbackFont = this.getPhysicalFont(this.getDefaultFont());
        if (this.fallbackFont == null) {
            this.fallbackFont = this.getDefaultFont();
            if (outputType != RunFontActionType.DISCOVERY) {
                log.warn(this.getDefaultFont() + " is not mapped!");
            }
        }
        this.vis.setFallbackFont(this.fallbackFont);
        if (wordMLPackage.getMainDocumentPart().getDocumentSettingsPart() != null) {
            try {
                this.themeFontLang = ((CTSettings)wordMLPackage.getMainDocumentPart().getDocumentSettingsPart().getContents()).getThemeFontLang();
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getCssName() {
        return "font-family";
    }

    private ThemePart getThemePart() {
        return this.wordMLPackage.getMainDocumentPart().getThemePart();
    }

    private Style getDefaultPStyle() {
        if (this.defaultParagraphStyle == null) {
            this.defaultParagraphStyle = this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false) != null ? this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle() : null;
        }
        return this.defaultParagraphStyle;
    }

    public String getDefaultFont() {
        if (this.defaultFont == null) {
            PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
            RFonts rFonts = propertyResolver.getDocumentDefaultRPr().getRFonts();
            if (rFonts == null) {
                log.info("No styles/docDefaults/rPrDefault/rPr/rFonts - default to Times New Roman");
                this.defaultFont = "Times New Roman";
            } else if (rFonts.getAsciiTheme() == null) {
                if (rFonts.getAscii() == null) {
                    log.error("Neither ascii or asciTheme.  What to do? ");
                    this.defaultFont = "Times New Roman";
                } else {
                    log.info("rPrDefault/rFonts referenced " + rFonts.getAscii());
                    this.defaultFont = rFonts.getAscii();
                }
            } else if (this.getThemePart() == null) {
                log.info("No theme part - default to Calibri");
                this.defaultFont = "Calibri";
            } else {
                String font = null;
                try {
                    font = this.getThemePart().getFont(rFonts.getAsciiTheme(), this.themeFontLang);
                }
                catch (Docx4JException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                if (font != null) {
                    this.defaultFont = font;
                } else {
                    log.info("No minorFont/latin in theme part - default to Calibri");
                    this.defaultFont = "Calibri";
                }
            }
        }
        return this.defaultFont;
    }

    private DocumentFragment nullRPr(Document document, String text) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            this.vis.fontAction(this.getDefaultFont());
            return null;
        }
        Element span = this.createElement(document);
        if (span != null) {
            document.appendChild(span);
            this.setAttribute(span, this.getDefaultFont());
            span.setTextContent(text);
        }
        return this.result(document);
    }

    private DocumentFragment result(Document document) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return null;
        }
        DocumentFragment docfrag = document.createDocumentFragment();
        docfrag.appendChild(document.getDocumentElement());
        return docfrag;
    }

    public Element createElement(Document document) {
        Element el = null;
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return null;
        }
        if (this.outputType == RunFontActionType.XHTML) {
            el = document.createElement("span");
        } else if (this.outputType == RunFontActionType.XSL_FO) {
            el = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
        }
        return el;
    }

    public void setAttribute(Element el, String fontName) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return;
        }
        if (this.outputType == RunFontActionType.XHTML) {
            if (this.spacePreserve) {
                el.setAttribute("style", this.getCssProperty(fontName) + "white-space:pre-wrap;");
            } else {
                el.setAttribute("style", this.getCssProperty(fontName));
            }
        } else if (this.outputType == RunFontActionType.XSL_FO) {
            String val = this.getPhysicalFont(fontName);
            if (val == null) {
                el.setAttribute("font-family", this.fallbackFont);
            } else {
                el.setAttribute("font-family", val);
            }
        }
    }

    public void symbolSetAttribute(Element el, String fontName, String textValue) {
        if (this.outputType == RunFontActionType.DISCOVERY) {
            return;
        }
        if (this.outputType == RunFontActionType.XHTML) {
            if (this.spacePreserve) {
                el.setAttribute("style", Property.composeCss("font-family", "'Arial, Helvetica, sans-serif'") + "white-space:pre-wrap;");
            } else {
                el.setAttribute("style", Property.composeCss("font-family", "'Arial, Helvetica, sans-serif'"));
            }
        } else if (this.outputType == RunFontActionType.XSL_FO) {
            PhysicalFont pf = null;
            PhysicalFont pf2 = null;
            if (fontName.equals("Webdings") || fontName.equals("Wingdings") || fontName.equals("Wingdings 2") || fontName.equals("Wingdings 3")) {
                pf = PhysicalFonts.getWDingsFont();
                pf2 = PhysicalFonts.getWDingsFont2();
            } else if (fontName.equals("Symbol")) {
                pf = PhysicalFonts.getSymbolFont();
            }
            try {
                if (!GlyphCheck.hasCodepoint(pf, textValue.codePointAt(0))) {
                    if (pf2 != null && GlyphCheck.hasCodepoint(pf2, textValue.codePointAt(0))) {
                        pf = pf2;
                        log.debug("For " + fontName + " mapped to " + textValue.codePointAt(0) + ", using 2nd substitute font " + pf2.getName());
                    } else {
                        log.warn("Missing symbol " + fontName + " " + textValue);
                    }
                }
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            String val = null;
            val = pf == null ? this.getPhysicalFont(fontName) : pf.getName();
            if (val == null) {
                el.setAttribute("font-family", this.fallbackFont);
            } else {
                el.setAttribute("font-family", val);
            }
        }
    }

    public Object fontSelector(PPr pPr, RPr rPr, Text wmlText) {
        String text = null;
        if (wmlText == null) {
            log.debug("Null Text object");
        } else {
            text = wmlText.getValue();
            this.spacePreserve = wmlText.getSpace() != null && wmlText.getSpace().equals("preserve");
        }
        return this.fontSelector(pPr, rPr, text);
    }

    public Object fontSelector(PPr pPr, RPr rPr, String text) {
        String actualFontName;
        if (text == null) {
            log.debug("w:t with null value");
            if (this.outputType != RunFontActionType.DISCOVERY) {
                return null;
            }
        } else {
            log.debug(text);
        }
        PropertyResolver propertyResolver = this.wordMLPackage.getMainDocumentPart().getPropertyResolver();
        String pStyleId = null;
        RPr pRPr = null;
        if (pPr == null || pPr.getPStyle() == null) {
            if (this.getDefaultPStyle() == null) {
                log.warn("getDefaultPStyle() returned null");
            } else {
                pStyleId = this.getDefaultPStyle().getStyleId();
            }
        } else {
            pStyleId = pPr.getPStyle().getVal();
        }
        if (pStyleId != null && this.wordMLPackage.getMainDocumentPart().getStyleDefinitionsPart(false) != null) {
            pRPr = propertyResolver.getEffectiveRPr(pStyleId);
        }
        rPr = propertyResolver.getEffectiveRPrUsingPStyleRPr(rPr, pRPr);
        if (log.isDebugEnabled()) {
            log.debug("effective\n" + XmlUtils.marshaltoString(rPr));
        }
        Document document = XmlUtils.getNewDocumentBuilder().newDocument();
        if (rPr == null) {
            log.warn("effective rPr is null");
            return this.nullRPr(document, text);
        }
        RFonts rFonts = rPr.getRFonts();
        if (rFonts == null) {
            return this.nullRPr(document, text);
        }
        if (rFonts.getHAnsi() != null && ((actualFontName = rFonts.getHAnsi()).equals("Symbol") || actualFontName.equals("Webdings") || actualFontName.equals("Wingdings") || actualFontName.equals("Wingdings 2") || actualFontName.equals("Wingdings 3"))) {
            Element span = this.createElement(document);
            if (span != null) {
                document.appendChild(span);
                StringBuffer sb = new StringBuffer();
                text.codePoints().forEach(cp -> {
                    String valStr = null;
                    if (cp > 255) {
                        cp = this.translateUnicode2SingleByte(cp);
                    }
                    if (cp > 255) {
                        log.info("Encountered unexpected char: " + actualFontName + " " + (short)cp + " Hex " + Integer.toHexString(cp));
                        valStr = SymbolMapper.getUnicodeReplacementChar(actualFontName, (short)cp);
                    } else {
                        valStr = SymbolMapper.getUnicodeReplacementChar(actualFontName, (short)cp);
                    }
                    if (valStr == null) {
                        sb.append("\u25a1");
                        log.warn(actualFontName + " " + (short)cp + " Hex " + Integer.toHexString(cp) + " has no replacement.");
                    } else {
                        sb.append(valStr);
                    }
                });
                span.setTextContent(sb.toString());
                this.symbolSetAttribute(span, actualFontName, span.getTextContent());
            }
            if (this.outputType == RunFontActionType.DISCOVERY) {
                // empty if block
            }
            return this.result(document);
        }
        if (pPr != null && pPr.getBidi() != null && pPr.getBidi().isVal()) {
            text = this.arabicNumbering(text, rPr.getRtl(), rPr.getCs(), this.themeFontLang);
        }
        if (rPr.getCs() != null || rPr.getRtl() != null) {
            String fontName;
            if (rFonts.getCstheme() != null) {
                Element span;
                fontName = null;
                if (this.getThemePart() != null) {
                    try {
                        fontName = this.getThemePart().getFont(rFonts.getCstheme(), this.themeFontLang);
                    }
                    catch (Docx4JException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                if (fontName == null) {
                    fontName = rFonts.getCs();
                }
                if (fontName == null) {
                    if (log.isWarnEnabled()) {
                        log.warn("font name is null, for " + text);
                        log.warn(XmlUtils.marshaltoString((Object)rPr, true, true));
                    }
                    new Throwable().printStackTrace();
                }
                if ((span = this.createElement(document)) != null) {
                    document.appendChild(span);
                    this.setAttribute(span, fontName);
                    span.setTextContent(text);
                }
                if (this.outputType == RunFontActionType.DISCOVERY) {
                    this.vis.fontAction(fontName);
                }
                return this.result(document);
            }
            if (rFonts.getCs() != null) {
                fontName = rFonts.getCs();
                Element span = this.createElement(document);
                if (span != null) {
                    document.appendChild(span);
                    this.setAttribute(span, fontName);
                    span.setTextContent(text);
                }
                if (this.outputType == RunFontActionType.DISCOVERY) {
                    this.vis.fontAction(fontName);
                }
                return this.result(document);
            }
        }
        String eastAsia = null;
        String ascii = null;
        String hAnsi = null;
        STHint hint = rFonts.getHint();
        if (rFonts.getEastAsiaTheme() != null && this.getThemePart() != null) {
            try {
                eastAsia = this.getThemePart().getFont(rFonts.getEastAsiaTheme(), this.themeFontLang);
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (eastAsia == null) {
                log.info("theme font for lang " + this.themeFontLang + " is " + eastAsia + ", but we don't have that");
                eastAsia = rFonts.getEastAsia();
            }
        } else {
            eastAsia = rFonts.getEastAsia();
        }
        if (rFonts.getAsciiTheme() != null && this.getThemePart() != null) {
            try {
                ascii = this.getThemePart().getFont(rFonts.getAsciiTheme(), this.themeFontLang);
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            ascii = rFonts.getAscii();
        }
        if (rFonts.getHAnsiTheme() != null && this.getThemePart() != null) {
            try {
                hAnsi = this.getThemePart().getFont(rFonts.getHAnsiTheme(), this.themeFontLang);
            }
            catch (Docx4JException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            hAnsi = rFonts.getHAnsi();
        }
        if ("Times New Roman".equals(eastAsia) && ascii != null && ascii.equals(hAnsi)) {
            Element span = this.createElement(document);
            if (span != null) {
                document.appendChild(span);
            }
            if (this.outputType == RunFontActionType.DISCOVERY) {
                this.vis.fontAction(ascii);
                return null;
            }
            this.setAttribute(span, ascii);
            span.setTextContent(text);
            return this.result(document);
        }
        if (ascii == null) {
            log.debug("No value for ascii, using default font");
            ascii = this.getDefaultFont();
        }
        if (hAnsi == null) {
            log.debug("No value for hAnsi, using default font");
            hAnsi = this.getDefaultFont();
        }
        String langEastAsia = null;
        if (rPr.getLang() != null) {
            langEastAsia = rPr.getLang().getEastAsia();
        }
        this.vis.setDocument(document);
        return this.unicodeRangeToFont(text, hint, langEastAsia, eastAsia, ascii, hAnsi);
    }

    private int translateUnicode2SingleByte(int cp) {
        switch (cp) {
            case 8364: {
                return 128;
            }
            case 8218: {
                return 130;
            }
            case 402: {
                return 131;
            }
            case 8222: {
                return 132;
            }
            case 8230: {
                return 133;
            }
            case 8224: {
                return 134;
            }
            case 8225: {
                return 135;
            }
            case 710: {
                return 136;
            }
            case 8240: {
                return 137;
            }
            case 352: {
                return 138;
            }
            case 8249: {
                return 139;
            }
            case 338: {
                return 140;
            }
            case 381: {
                return 142;
            }
            case 8216: {
                return 145;
            }
            case 8217: {
                return 146;
            }
            case 8220: {
                return 147;
            }
            case 8221: {
                return 148;
            }
            case 8226: {
                return 149;
            }
            case 8211: {
                return 150;
            }
            case 8212: {
                return 151;
            }
            case 732: {
                return 152;
            }
            case 8482: {
                return 153;
            }
            case 353: {
                return 154;
            }
            case 8250: {
                return 155;
            }
            case 339: {
                return 156;
            }
            case 382: {
                return 158;
            }
            case 376: {
                return 159;
            }
        }
        return cp;
    }

    private boolean contains(String langEastAsia, String lang) {
        if (langEastAsia == null) {
            return false;
        }
        return langEastAsia.contains(lang);
    }

    private static String getEmojiFont() {
        if (EMOJI_FONT == null) {
            EMOJI_FONT = Docx4jProperties.getProperty("docx4j.fonts.RunFontSelector.EmojiFont");
        }
        return EMOJI_FONT;
    }

    private Object unicodeRangeToFont(String text, STHint hint, String langEastAsia, String eastAsia, String ascii, String hAnsi) {
        int currentRangeLower = 0;
        int currentRangeUpper = 0;
        if (text == null) {
            return null;
        }
        int i = 0;
        while (i < text.length()) {
            int c = text.charAt(i);
            if (Character.isHighSurrogate((char)c)) {
                block94: {
                    this.vis.finishPrevious();
                    this.vis.createNew();
                    this.vis.setMustCreateNewFlag(false);
                    if (RunFontSelector.getEmojiFont() == null) {
                        this.vis.fontAction(hAnsi);
                    } else if (c == 55357 || c == 55357 || c == 55358) {
                        log.debug("assuming emoji " + Integer.toHexString(c));
                        try {
                            if (GlyphCheck.hasChar(hAnsi, (char)c)) {
                                log.debug("present in " + hAnsi);
                                this.vis.fontAction(hAnsi);
                                break block94;
                            }
                            this.vis.fontAction(RunFontSelector.getEmojiFont());
                        }
                        catch (ExecutionException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                }
                this.vis.addCodePointToCurrent(text.codePointAt(i));
                log.debug("added as code point");
                currentRangeLower = 0;
                currentRangeUpper = 0;
            } else if (this.vis.isReusable() && (c == 32 || c >= currentRangeLower && c <= currentRangeUpper)) {
                this.vis.addCharacterToCurrent((char)c);
            } else {
                this.vis.finishPrevious();
                this.vis.createNew();
                this.vis.setMustCreateNewFlag(false);
                if (c >= 0 && c <= 127) {
                    this.vis.fontAction(ascii);
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 0;
                    currentRangeUpper = 127;
                } else if (c >= 160 && c <= 255) {
                    if (hint == STHint.EAST_ASIA && eastAsia != null) {
                        if (c == 161 || c == 164 || c >= 167 && c <= 168 || c == 170 || c == 173 || c == 175 || c >= 176 && c <= 180 || c >= 182 && c <= 186 || c >= 188 && c <= 191 || c == 215 || c == 247) {
                            this.vis.fontAction(eastAsia);
                        } else if (this.contains(langEastAsia, "zh") && (c >= 224 && c <= 225 || c >= 232 && c <= 234 || c >= 236 && c <= 237 || c >= 242 && c <= 243 || c >= 249 && c <= 250 || c == 252)) {
                            this.vis.fontAction(eastAsia);
                        } else if (hAnsi != null) {
                            this.vis.fontAction(hAnsi);
                        } else {
                            this.vis.fontAction(this.getDefaultFont());
                        }
                    } else if (hAnsi != null) {
                        this.vis.fontAction(hAnsi);
                    } else {
                        this.vis.fontAction(this.getDefaultFont());
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    this.vis.setMustCreateNewFlag(false);
                    currentRangeLower = 0;
                    currentRangeUpper = 127;
                } else if (c >= 256 && c <= 687) {
                    if (hint == STHint.EAST_ASIA) {
                        if (this.contains(langEastAsia, "zh")) {
                            this.vis.fontAction(eastAsia);
                            this.vis.setMustCreateNewFlag(true);
                        } else {
                            this.vis.fontAction(hAnsi);
                            this.vis.setMustCreateNewFlag(true);
                        }
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 256;
                    currentRangeUpper = 687;
                } else if (c >= 688 && c <= 1279) {
                    if (hint == STHint.EAST_ASIA) {
                        this.vis.fontAction(eastAsia);
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 688;
                    currentRangeUpper = 1279;
                } else if (c >= 1424 && c <= 1983) {
                    try {
                        if (GlyphCheck.hasChar("Times New Roman", (char)c)) {
                            this.vis.fontAction("Times New Roman");
                        }
                    }
                    catch (ExecutionException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 1424;
                    currentRangeUpper = 1983;
                } else if (c >= 4352 && c <= 4607) {
                    if (eastAsia == null) {
                        this.vis.fontAction("Gungsuh");
                    } else {
                        this.vis.fontAction(eastAsia);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 4352;
                    currentRangeUpper = 4607;
                } else if (c >= 7680 && c <= 7935) {
                    if (hint == STHint.EAST_ASIA) {
                        if (this.contains(langEastAsia, "zh")) {
                            this.vis.fontAction(eastAsia);
                        } else {
                            this.vis.fontAction(hAnsi);
                        }
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 7680;
                    currentRangeUpper = 7935;
                } else if (c >= 8192 && c <= 12031) {
                    if (hint == STHint.EAST_ASIA) {
                        this.vis.fontAction(eastAsia);
                    } else if (hAnsi == null) {
                        log.warn("TODO: how to handle char '" + (char)c + "' lacking hAnsi?");
                    } else {
                        try {
                            if (GlyphCheck.hasChar(hAnsi, (char)c)) {
                                this.vis.fontAction(hAnsi);
                            } else {
                                String FONT_WORD_2016_USES = "Segoe UI Symbol";
                                Mapper fontMapper = this.wordMLPackage.getFontMapper();
                                PhysicalFont gothicSubs = fontMapper.get("Segoe UI Symbol");
                                if (gothicSubs != null && GlyphCheck.hasChar(gothicSubs, (char)c)) {
                                    this.vis.fontAction("Segoe UI Symbol");
                                } else {
                                    log.warn("TODO: how to handle char '" + (char)c + "' in range c>='\\u2000' && c<='\\u2EFF'?");
                                }
                            }
                        }
                        catch (ExecutionException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 8192;
                    currentRangeUpper = 12031;
                } else if (c >= 12032 && c <= 57343) {
                    if (eastAsia == null) {
                        this.vis.fontAction(hAnsi);
                        this.debugCheckGlyph(hAnsi, (char)c);
                    } else {
                        this.vis.fontAction(eastAsia);
                        this.debugCheckGlyph(eastAsia, (char)c);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 12032;
                    currentRangeUpper = 57343;
                } else if (c >= 57344 && c <= 63743) {
                    if (hint == STHint.EAST_ASIA) {
                        this.vis.fontAction(eastAsia);
                    } else if (hAnsi == null) {
                        log.warn("TODO: how to handle char '" + (char)c + "' (0x" + Integer.toHexString(c) + ") lacking hAnsi?");
                    } else {
                        this.vis.fontAction(hAnsi);
                        this.debugCheckGlyph(hAnsi, (char)c);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 57344;
                    currentRangeUpper = 63743;
                } else if (c >= 63744 && c <= 64255) {
                    this.vis.fontAction(eastAsia);
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 63744;
                    currentRangeUpper = 64255;
                } else if (c >= 64256 && c <= 64335) {
                    if (hint == STHint.EAST_ASIA) {
                        if (c >= 64256 && c <= 64284) {
                            this.vis.fontAction(eastAsia);
                            this.vis.setMustCreateNewFlag(true);
                        } else {
                            this.vis.fontAction(hAnsi);
                        }
                    } else if (c >= 64285 && c <= 64335) {
                        this.vis.fontAction(ascii);
                        this.vis.setMustCreateNewFlag(true);
                    } else {
                        this.vis.fontAction(hAnsi);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 64256;
                    currentRangeUpper = 64335;
                } else if (c >= 64336 && c <= 65023) {
                    this.vis.fontAction(ascii);
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 64336;
                    currentRangeUpper = 65023;
                } else if (c >= 65072 && c <= 65135) {
                    this.vis.fontAction(eastAsia);
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 65072;
                    currentRangeUpper = 65135;
                } else if (c >= 65136 && c <= 65278) {
                    this.vis.fontAction(ascii);
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 65136;
                    currentRangeUpper = 65278;
                } else if (c >= 65280 && c <= 65519) {
                    if (eastAsia == null) {
                        this.vis.fontAction(hAnsi);
                    } else {
                        this.vis.fontAction(eastAsia);
                    }
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 65280;
                    currentRangeUpper = 65519;
                } else {
                    String hex = String.format("%04x", c);
                    log.debug("Defaulting to hAnsi for char " + hex);
                    this.vis.fontAction(hAnsi);
                    this.debugCheckGlyph(hAnsi, (char)c);
                    this.vis.addCharacterToCurrent((char)c);
                    currentRangeLower = 0;
                    currentRangeUpper = 0;
                }
            }
            i = text.offsetByCodePoints(i, 1);
        }
        this.vis.finishPrevious();
        return this.vis.getResult();
    }

    private void debugCheckGlyph(String fontName, char c) {
        if (log.isDebugEnabled()) {
            try {
                if (!GlyphCheck.hasChar(fontName, c)) {
                    log.debug(fontName + "'s PhysicalFont is missing char " + c);
                }
            }
            catch (ExecutionException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getCssProperty(String fontName) {
        String font;
        if (log.isDebugEnabled() && fontName == null) {
            Throwable t = new Throwable();
            t.printStackTrace();
        }
        if ((font = this.getPhysicalFont(fontName)) != null) {
            return Property.composeCss("font-family", "'" + font + "'");
        }
        log.info("No physical font for " + fontName);
        return "";
    }

    private String getPhysicalFont(String fontName) {
        log.debug("looking for: " + fontName);
        PhysicalFont pf = this.wordMLPackage.getFontMapper().get(fontName);
        if (pf != null) {
            log.debug("Font '" + fontName + "' maps to " + pf.getName());
            return pf.getName();
        }
        String englishFromCJK = CJKToEnglish.toEnglish(fontName);
        if (englishFromCJK == null) {
            if (this.wordMLPackage.getFontMapper().size() > 0) {
                log.warn("Font '" + fontName + "' is not mapped to a physical font. ");
            }
            return null;
        }
        pf = this.wordMLPackage.getFontMapper().get(englishFromCJK);
        if (pf == null) {
            if (this.wordMLPackage.getFontMapper().size() > 0) {
                log.warn("Font '" + englishFromCJK + "' is not mapped to a physical font. ");
            }
            return null;
        }
        return pf.getName();
    }

    private static NumericShaper getNumericShaperArabicIndic() {
        if (numericShaperArabicIndic == null) {
            numericShaperArabicIndic = NumericShaper.getShaper(2);
        }
        return numericShaperArabicIndic;
    }

    private static NativeDigitsSetting getNativeDigitsSetting() {
        if (nativeDigitsSetting == null) {
            nativeDigitsSetting = NativeDigitsSetting.valueOf(Docx4jProperties.getProperty("docx4j.MicrosoftWindows.Region.Format.Numbers.NativeDigits", "National"));
        }
        return nativeDigitsSetting;
    }

    private static MicrosoftWordNumeralOption getMicrosoftWordNumeralOption() {
        if (microsoftWordNumeralOption == null) {
            microsoftWordNumeralOption = MicrosoftWordNumeralOption.valueOf(Docx4jProperties.getProperty("docx4j.MicrosoftWord.Numeral", "Arabic"));
        }
        return microsoftWordNumeralOption;
    }

    private String shapeAsArabicIndic(String text) {
        char[] chars = text.toCharArray();
        RunFontSelector.getNumericShaperArabicIndic().shape(chars, 0, chars.length);
        return new String(chars);
    }

    private String arabicNumbering(String text, BooleanDefaultTrue rtl, BooleanDefaultTrue cs, CTLanguage themeFontLang) {
        if (themeFontLang == null || themeFontLang.getBidi() == null || !themeFontLang.getBidi().equals("ar-SA")) {
            return text;
        }
        if (rtl != null && rtl.isVal() || cs != null && cs.isVal()) {
            if (RunFontSelector.getMicrosoftWordNumeralOption().equals((Object)MicrosoftWordNumeralOption.Arabic)) {
                return text;
            }
            return this.shapeAsArabicIndic(text);
        }
        if (RunFontSelector.getNativeDigitsSetting().equals((Object)NativeDigitsSetting.National)) {
            return this.shapeAsArabicIndic(text);
        }
        if (RunFontSelector.getMicrosoftWordNumeralOption().equals((Object)MicrosoftWordNumeralOption.Hindi)) {
            return this.shapeAsArabicIndic(text);
        }
        return text;
    }

    public static interface RunFontCharacterVisitor {
        public void setRunFontSelector(RunFontSelector var1);

        public void setDocument(Document var1);

        public void addCharacterToCurrent(char var1);

        public void addCodePointToCurrent(int var1);

        public void finishPrevious();

        public void createNew();

        public void setMustCreateNewFlag(boolean var1);

        public boolean isReusable();

        public void fontAction(String var1);

        public void setFallbackFont(String var1);

        public Object getResult();
    }

    public static enum RunFontActionType {
        XSL_FO,
        XHTML,
        DISCOVERY;

    }

    static enum NativeDigitsSetting {
        National,
        Context;

    }

    static enum MicrosoftWordNumeralOption {
        Hindi,
        Context,
        Arabic,
        System;

    }
}

