/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.DrawingML;

import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import org.docx4j.dml.diagram.CTStyleDefinition;
import org.docx4j.dml.diagram.CTStyleLabel;
import org.docx4j.dml.diagram.ObjectFactory;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.DrawingML.JaxbDmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiagramStylePart
extends JaxbDmlPart<CTStyleDefinition> {
    private static Logger log = LoggerFactory.getLogger(DiagramStylePart.class);

    public DiagramStylePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public DiagramStylePart() throws InvalidFormatException {
        super(new PartName("/word/diagrams/quickStyle1.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramQuickStyle");
    }

    public Object unmarshal(String filename) throws JAXBException {
        InputStream is = null;
        try {
            is = ResourceUtils.getResource("org/docx4j/openpackaging/parts/DrawingML/" + filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.unmarshal(is);
    }

    public void CreateMinimalContent(String uniqueId) {
        ObjectFactory factory = new ObjectFactory();
        CTStyleDefinition styleDef = factory.createCTStyleDefinition();
        styleDef.setUniqueId(uniqueId);
        CTStyleLabel styleLabel = factory.createCTStyleLabel();
        styleLabel.setName("node0");
        styleDef.getStyleLbl().add(styleLabel);
        this.setJaxbElement(styleDef);
    }
}

