/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.base14;

import java.awt.Rectangle;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.docx4j.fonts.fop.fonts.Base14Font;
import org.docx4j.fonts.fop.fonts.CodePointMapping;
import org.docx4j.fonts.fop.fonts.FontType;

public class TimesRoman
extends Base14Font {
    private static final URI fontFileURI;
    private static final String fontName = "Times-Roman";
    private static final String fullName = "Times Roman";
    private static final Set familyNames;
    private static final int underlinePosition = -100;
    private static final int underlineThickness = 50;
    private static final String encoding = "WinAnsiEncoding";
    private static final int capHeight = 662;
    private static final int xHeight = 450;
    private static final int ascender = 683;
    private static final int descender = -217;
    private static final int firstChar = 32;
    private static final int lastChar = 255;
    private static final int[] width;
    private static final Rectangle[] boundingBoxes;
    private final CodePointMapping mapping = CodePointMapping.getMapping("WinAnsiEncoding");
    private static final Map kerning;
    private boolean enableKerning;

    public TimesRoman() {
        this(false);
    }

    public TimesRoman(boolean enableKerning) {
        this.enableKerning = enableKerning;
    }

    @Override
    public String getEncodingName() {
        return encoding;
    }

    @Override
    public URI getFontURI() {
        return fontFileURI;
    }

    @Override
    public String getFontName() {
        return fontName;
    }

    @Override
    public String getEmbedFontName() {
        return this.getFontName();
    }

    @Override
    public String getFullName() {
        return fullName;
    }

    public Set getFamilyNames() {
        return familyNames;
    }

    @Override
    public FontType getFontType() {
        return FontType.TYPE1;
    }

    @Override
    public int getAscender(int size) {
        return size * 683;
    }

    @Override
    public int getCapHeight(int size) {
        return size * 662;
    }

    @Override
    public int getDescender(int size) {
        return size * -217;
    }

    @Override
    public int getXHeight(int size) {
        return size * 450;
    }

    @Override
    public int getUnderlinePosition(int size) {
        return size * -100;
    }

    @Override
    public int getUnderlineThickness(int size) {
        return size * 50;
    }

    public int getFirstChar() {
        return 32;
    }

    public int getLastChar() {
        return 255;
    }

    @Override
    public int getWidth(int i, int size) {
        return size * width[i];
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        Rectangle bbox = boundingBoxes[glyphIndex];
        return new Rectangle(bbox.x * size, bbox.y * size, bbox.width * size, bbox.height * size);
    }

    @Override
    public int[] getWidths() {
        int[] arr = new int[this.getLastChar() - this.getFirstChar() + 1];
        System.arraycopy(width, this.getFirstChar(), arr, 0, this.getLastChar() - this.getFirstChar() + 1);
        return arr;
    }

    @Override
    public boolean hasKerningInfo() {
        return this.enableKerning;
    }

    public Map getKerningInfo() {
        return kerning;
    }

    @Override
    public char mapChar(char c) {
        this.notifyMapOperation();
        char d = this.mapping.mapChar(c);
        if (d != '\u0000') {
            return d;
        }
        this.warnMissingGlyph(c);
        return '#';
    }

    @Override
    public boolean hasChar(char c) {
        return this.mapping.mapChar(c) > '\u0000';
    }

    static {
        URI uri = null;
        try {
            uri = new URI("base14:" + fontName.toLowerCase());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        fontFileURI = uri;
        width = new int[256];
        boundingBoxes = new Rectangle[256];
        TimesRoman.width[65] = 722;
        TimesRoman.boundingBoxes[65] = new Rectangle(15, 0, 691, 674);
        TimesRoman.width[198] = 889;
        TimesRoman.boundingBoxes[198] = new Rectangle(0, 0, 863, 662);
        TimesRoman.width[193] = 722;
        TimesRoman.boundingBoxes[193] = new Rectangle(15, 0, 691, 890);
        TimesRoman.width[194] = 722;
        TimesRoman.boundingBoxes[194] = new Rectangle(15, 0, 691, 886);
        TimesRoman.width[196] = 722;
        TimesRoman.boundingBoxes[196] = new Rectangle(15, 0, 691, 835);
        TimesRoman.width[192] = 722;
        TimesRoman.boundingBoxes[192] = new Rectangle(15, 0, 691, 890);
        TimesRoman.width[197] = 722;
        TimesRoman.boundingBoxes[197] = new Rectangle(15, 0, 691, 898);
        TimesRoman.width[195] = 722;
        TimesRoman.boundingBoxes[195] = new Rectangle(15, 0, 691, 850);
        TimesRoman.width[66] = 667;
        TimesRoman.boundingBoxes[66] = new Rectangle(17, 0, 576, 662);
        TimesRoman.width[67] = 667;
        TimesRoman.boundingBoxes[67] = new Rectangle(28, -14, 605, 690);
        TimesRoman.width[199] = 667;
        TimesRoman.boundingBoxes[199] = new Rectangle(28, -215, 605, 891);
        TimesRoman.width[68] = 722;
        TimesRoman.boundingBoxes[68] = new Rectangle(16, 0, 669, 662);
        TimesRoman.width[69] = 611;
        TimesRoman.boundingBoxes[69] = new Rectangle(12, 0, 585, 662);
        TimesRoman.width[201] = 611;
        TimesRoman.boundingBoxes[201] = new Rectangle(12, 0, 585, 890);
        TimesRoman.width[202] = 611;
        TimesRoman.boundingBoxes[202] = new Rectangle(12, 0, 585, 886);
        TimesRoman.width[203] = 611;
        TimesRoman.boundingBoxes[203] = new Rectangle(12, 0, 585, 835);
        TimesRoman.width[200] = 611;
        TimesRoman.boundingBoxes[200] = new Rectangle(12, 0, 585, 890);
        TimesRoman.width[208] = 722;
        TimesRoman.boundingBoxes[208] = new Rectangle(16, 0, 669, 662);
        TimesRoman.width[128] = 500;
        TimesRoman.boundingBoxes[128] = new Rectangle(0, 0, 0, 0);
        TimesRoman.width[70] = 556;
        TimesRoman.boundingBoxes[70] = new Rectangle(12, 0, 534, 662);
        TimesRoman.width[71] = 722;
        TimesRoman.boundingBoxes[71] = new Rectangle(32, -14, 677, 690);
        TimesRoman.width[72] = 722;
        TimesRoman.boundingBoxes[72] = new Rectangle(19, 0, 683, 662);
        TimesRoman.width[73] = 333;
        TimesRoman.boundingBoxes[73] = new Rectangle(18, 0, 297, 662);
        TimesRoman.width[205] = 333;
        TimesRoman.boundingBoxes[205] = new Rectangle(18, 0, 299, 890);
        TimesRoman.width[206] = 333;
        TimesRoman.boundingBoxes[206] = new Rectangle(11, 0, 311, 886);
        TimesRoman.width[207] = 333;
        TimesRoman.boundingBoxes[207] = new Rectangle(18, 0, 297, 835);
        TimesRoman.width[204] = 333;
        TimesRoman.boundingBoxes[204] = new Rectangle(18, 0, 297, 890);
        TimesRoman.width[74] = 389;
        TimesRoman.boundingBoxes[74] = new Rectangle(10, -14, 360, 676);
        TimesRoman.width[75] = 722;
        TimesRoman.boundingBoxes[75] = new Rectangle(34, 0, 689, 662);
        TimesRoman.width[76] = 611;
        TimesRoman.boundingBoxes[76] = new Rectangle(12, 0, 586, 662);
        TimesRoman.width[77] = 889;
        TimesRoman.boundingBoxes[77] = new Rectangle(12, 0, 851, 662);
        TimesRoman.width[78] = 722;
        TimesRoman.boundingBoxes[78] = new Rectangle(12, -11, 695, 673);
        TimesRoman.width[209] = 722;
        TimesRoman.boundingBoxes[209] = new Rectangle(12, -11, 695, 861);
        TimesRoman.width[79] = 722;
        TimesRoman.boundingBoxes[79] = new Rectangle(34, -14, 654, 690);
        TimesRoman.width[140] = 889;
        TimesRoman.boundingBoxes[140] = new Rectangle(30, -6, 855, 674);
        TimesRoman.width[211] = 722;
        TimesRoman.boundingBoxes[211] = new Rectangle(34, -14, 654, 904);
        TimesRoman.width[212] = 722;
        TimesRoman.boundingBoxes[212] = new Rectangle(34, -14, 654, 900);
        TimesRoman.width[214] = 722;
        TimesRoman.boundingBoxes[214] = new Rectangle(34, -14, 654, 849);
        TimesRoman.width[210] = 722;
        TimesRoman.boundingBoxes[210] = new Rectangle(34, -14, 654, 904);
        TimesRoman.width[216] = 722;
        TimesRoman.boundingBoxes[216] = new Rectangle(34, -80, 654, 814);
        TimesRoman.width[213] = 722;
        TimesRoman.boundingBoxes[213] = new Rectangle(34, -14, 654, 864);
        TimesRoman.width[80] = 556;
        TimesRoman.boundingBoxes[80] = new Rectangle(16, 0, 526, 662);
        TimesRoman.width[81] = 722;
        TimesRoman.boundingBoxes[81] = new Rectangle(34, -178, 667, 854);
        TimesRoman.width[82] = 667;
        TimesRoman.boundingBoxes[82] = new Rectangle(17, 0, 642, 662);
        TimesRoman.width[83] = 556;
        TimesRoman.boundingBoxes[83] = new Rectangle(42, -14, 449, 690);
        TimesRoman.width[138] = 556;
        TimesRoman.boundingBoxes[138] = new Rectangle(42, -14, 449, 900);
        TimesRoman.width[84] = 611;
        TimesRoman.boundingBoxes[84] = new Rectangle(17, 0, 576, 662);
        TimesRoman.width[222] = 556;
        TimesRoman.boundingBoxes[222] = new Rectangle(16, 0, 526, 662);
        TimesRoman.width[85] = 722;
        TimesRoman.boundingBoxes[85] = new Rectangle(14, -14, 691, 676);
        TimesRoman.width[218] = 722;
        TimesRoman.boundingBoxes[218] = new Rectangle(14, -14, 691, 904);
        TimesRoman.width[219] = 722;
        TimesRoman.boundingBoxes[219] = new Rectangle(14, -14, 691, 900);
        TimesRoman.width[220] = 722;
        TimesRoman.boundingBoxes[220] = new Rectangle(14, -14, 691, 849);
        TimesRoman.width[217] = 722;
        TimesRoman.boundingBoxes[217] = new Rectangle(14, -14, 691, 904);
        TimesRoman.width[86] = 722;
        TimesRoman.boundingBoxes[86] = new Rectangle(16, -11, 681, 673);
        TimesRoman.width[87] = 944;
        TimesRoman.boundingBoxes[87] = new Rectangle(5, -11, 927, 673);
        TimesRoman.width[88] = 722;
        TimesRoman.boundingBoxes[88] = new Rectangle(10, 0, 694, 662);
        TimesRoman.width[89] = 722;
        TimesRoman.boundingBoxes[89] = new Rectangle(22, 0, 681, 662);
        TimesRoman.width[221] = 722;
        TimesRoman.boundingBoxes[221] = new Rectangle(22, 0, 681, 890);
        TimesRoman.width[159] = 722;
        TimesRoman.boundingBoxes[159] = new Rectangle(22, 0, 681, 835);
        TimesRoman.width[90] = 611;
        TimesRoman.boundingBoxes[90] = new Rectangle(9, 0, 588, 662);
        TimesRoman.width[142] = 611;
        TimesRoman.boundingBoxes[142] = new Rectangle(9, 0, 588, 886);
        TimesRoman.width[97] = 444;
        TimesRoman.boundingBoxes[97] = new Rectangle(37, -10, 405, 470);
        TimesRoman.width[225] = 444;
        TimesRoman.boundingBoxes[225] = new Rectangle(37, -10, 405, 688);
        TimesRoman.width[226] = 444;
        TimesRoman.boundingBoxes[226] = new Rectangle(37, -10, 405, 684);
        TimesRoman.width[180] = 333;
        TimesRoman.boundingBoxes[180] = new Rectangle(93, 507, 224, 171);
        TimesRoman.width[228] = 444;
        TimesRoman.boundingBoxes[228] = new Rectangle(37, -10, 405, 633);
        TimesRoman.width[230] = 667;
        TimesRoman.boundingBoxes[230] = new Rectangle(38, -10, 594, 470);
        TimesRoman.width[224] = 444;
        TimesRoman.boundingBoxes[224] = new Rectangle(37, -10, 405, 688);
        TimesRoman.width[38] = 778;
        TimesRoman.boundingBoxes[38] = new Rectangle(42, -13, 708, 689);
        TimesRoman.width[229] = 444;
        TimesRoman.boundingBoxes[229] = new Rectangle(37, -10, 405, 721);
        TimesRoman.width[94] = 469;
        TimesRoman.boundingBoxes[94] = new Rectangle(24, 297, 422, 365);
        TimesRoman.width[126] = 541;
        TimesRoman.boundingBoxes[126] = new Rectangle(40, 183, 462, 140);
        TimesRoman.width[42] = 500;
        TimesRoman.boundingBoxes[42] = new Rectangle(69, 265, 363, 411);
        TimesRoman.width[64] = 921;
        TimesRoman.boundingBoxes[64] = new Rectangle(116, -14, 693, 690);
        TimesRoman.width[227] = 444;
        TimesRoman.boundingBoxes[227] = new Rectangle(37, -10, 405, 648);
        TimesRoman.width[98] = 500;
        TimesRoman.boundingBoxes[98] = new Rectangle(3, -10, 465, 693);
        TimesRoman.width[92] = 278;
        TimesRoman.boundingBoxes[92] = new Rectangle(-9, -14, 296, 690);
        TimesRoman.width[124] = 200;
        TimesRoman.boundingBoxes[124] = new Rectangle(67, -218, 66, 1000);
        TimesRoman.width[123] = 480;
        TimesRoman.boundingBoxes[123] = new Rectangle(100, -181, 250, 861);
        TimesRoman.width[125] = 480;
        TimesRoman.boundingBoxes[125] = new Rectangle(130, -181, 250, 861);
        TimesRoman.width[91] = 333;
        TimesRoman.boundingBoxes[91] = new Rectangle(88, -156, 211, 818);
        TimesRoman.width[93] = 333;
        TimesRoman.boundingBoxes[93] = new Rectangle(34, -156, 211, 818);
        TimesRoman.width[166] = 200;
        TimesRoman.boundingBoxes[166] = new Rectangle(67, -143, 66, 850);
        TimesRoman.width[149] = 350;
        TimesRoman.boundingBoxes[149] = new Rectangle(40, 196, 270, 270);
        TimesRoman.width[99] = 444;
        TimesRoman.boundingBoxes[99] = new Rectangle(25, -10, 387, 470);
        TimesRoman.width[231] = 444;
        TimesRoman.boundingBoxes[231] = new Rectangle(25, -215, 387, 675);
        TimesRoman.width[184] = 333;
        TimesRoman.boundingBoxes[184] = new Rectangle(52, -215, 209, 215);
        TimesRoman.width[162] = 500;
        TimesRoman.boundingBoxes[162] = new Rectangle(53, -138, 395, 717);
        TimesRoman.width[136] = 333;
        TimesRoman.boundingBoxes[136] = new Rectangle(11, 507, 311, 167);
        TimesRoman.width[58] = 278;
        TimesRoman.boundingBoxes[58] = new Rectangle(81, -11, 111, 470);
        TimesRoman.width[44] = 250;
        TimesRoman.boundingBoxes[44] = new Rectangle(56, -141, 139, 243);
        TimesRoman.width[169] = 760;
        TimesRoman.boundingBoxes[169] = new Rectangle(38, -14, 684, 690);
        TimesRoman.width[164] = 500;
        TimesRoman.boundingBoxes[164] = new Rectangle(-22, 58, 544, 544);
        TimesRoman.width[100] = 500;
        TimesRoman.boundingBoxes[100] = new Rectangle(27, -10, 464, 693);
        TimesRoman.width[134] = 500;
        TimesRoman.boundingBoxes[134] = new Rectangle(59, -149, 383, 825);
        TimesRoman.width[135] = 500;
        TimesRoman.boundingBoxes[135] = new Rectangle(58, -153, 384, 829);
        TimesRoman.width[176] = 400;
        TimesRoman.boundingBoxes[176] = new Rectangle(57, 390, 286, 286);
        TimesRoman.width[168] = 333;
        TimesRoman.boundingBoxes[168] = new Rectangle(18, 581, 297, 100);
        TimesRoman.width[247] = 564;
        TimesRoman.boundingBoxes[247] = new Rectangle(30, -10, 504, 526);
        TimesRoman.width[36] = 500;
        TimesRoman.boundingBoxes[36] = new Rectangle(44, -87, 413, 814);
        TimesRoman.width[101] = 444;
        TimesRoman.boundingBoxes[101] = new Rectangle(25, -10, 399, 470);
        TimesRoman.width[233] = 444;
        TimesRoman.boundingBoxes[233] = new Rectangle(25, -10, 399, 688);
        TimesRoman.width[234] = 444;
        TimesRoman.boundingBoxes[234] = new Rectangle(25, -10, 399, 684);
        TimesRoman.width[235] = 444;
        TimesRoman.boundingBoxes[235] = new Rectangle(25, -10, 399, 633);
        TimesRoman.width[232] = 444;
        TimesRoman.boundingBoxes[232] = new Rectangle(25, -10, 399, 688);
        TimesRoman.width[56] = 500;
        TimesRoman.boundingBoxes[56] = new Rectangle(56, -14, 389, 690);
        TimesRoman.width[133] = 1000;
        TimesRoman.boundingBoxes[133] = new Rectangle(111, -11, 777, 111);
        TimesRoman.width[151] = 1000;
        TimesRoman.boundingBoxes[151] = new Rectangle(0, 201, 1000, 49);
        TimesRoman.width[150] = 500;
        TimesRoman.boundingBoxes[150] = new Rectangle(0, 201, 500, 49);
        TimesRoman.width[61] = 564;
        TimesRoman.boundingBoxes[61] = new Rectangle(30, 120, 504, 266);
        TimesRoman.width[240] = 500;
        TimesRoman.boundingBoxes[240] = new Rectangle(29, -10, 442, 696);
        TimesRoman.width[33] = 333;
        TimesRoman.boundingBoxes[33] = new Rectangle(130, -9, 108, 685);
        TimesRoman.width[161] = 333;
        TimesRoman.boundingBoxes[161] = new Rectangle(97, -218, 108, 685);
        TimesRoman.width[102] = 333;
        TimesRoman.boundingBoxes[102] = new Rectangle(20, 0, 363, 683);
        TimesRoman.width[53] = 500;
        TimesRoman.boundingBoxes[53] = new Rectangle(32, -14, 406, 702);
        TimesRoman.width[131] = 500;
        TimesRoman.boundingBoxes[131] = new Rectangle(7, -189, 483, 865);
        TimesRoman.width[52] = 500;
        TimesRoman.boundingBoxes[52] = new Rectangle(12, 0, 460, 676);
        TimesRoman.width[103] = 500;
        TimesRoman.boundingBoxes[103] = new Rectangle(28, -218, 442, 678);
        TimesRoman.width[223] = 500;
        TimesRoman.boundingBoxes[223] = new Rectangle(12, -9, 456, 692);
        TimesRoman.width[96] = 333;
        TimesRoman.boundingBoxes[96] = new Rectangle(19, 507, 223, 171);
        TimesRoman.width[62] = 564;
        TimesRoman.boundingBoxes[62] = new Rectangle(28, -8, 508, 522);
        TimesRoman.width[171] = 500;
        TimesRoman.boundingBoxes[171] = new Rectangle(42, 33, 414, 383);
        TimesRoman.width[187] = 500;
        TimesRoman.boundingBoxes[187] = new Rectangle(44, 33, 414, 383);
        TimesRoman.width[139] = 333;
        TimesRoman.boundingBoxes[139] = new Rectangle(63, 33, 222, 383);
        TimesRoman.width[155] = 333;
        TimesRoman.boundingBoxes[155] = new Rectangle(48, 33, 222, 383);
        TimesRoman.width[104] = 500;
        TimesRoman.boundingBoxes[104] = new Rectangle(9, 0, 478, 683);
        TimesRoman.width[45] = 333;
        TimesRoman.boundingBoxes[45] = new Rectangle(39, 194, 246, 63);
        TimesRoman.width[105] = 278;
        TimesRoman.boundingBoxes[105] = new Rectangle(16, 0, 237, 683);
        TimesRoman.width[237] = 278;
        TimesRoman.boundingBoxes[237] = new Rectangle(16, 0, 274, 678);
        TimesRoman.width[238] = 278;
        TimesRoman.boundingBoxes[238] = new Rectangle(-16, 0, 311, 674);
        TimesRoman.width[239] = 278;
        TimesRoman.boundingBoxes[239] = new Rectangle(-9, 0, 297, 623);
        TimesRoman.width[236] = 278;
        TimesRoman.boundingBoxes[236] = new Rectangle(-8, 0, 261, 678);
        TimesRoman.width[106] = 278;
        TimesRoman.boundingBoxes[106] = new Rectangle(-70, -218, 264, 901);
        TimesRoman.width[107] = 500;
        TimesRoman.boundingBoxes[107] = new Rectangle(7, 0, 498, 683);
        TimesRoman.width[108] = 278;
        TimesRoman.boundingBoxes[108] = new Rectangle(19, 0, 238, 683);
        TimesRoman.width[60] = 564;
        TimesRoman.boundingBoxes[60] = new Rectangle(28, -8, 508, 522);
        TimesRoman.width[172] = 564;
        TimesRoman.boundingBoxes[172] = new Rectangle(30, 108, 504, 278);
        TimesRoman.width[109] = 778;
        TimesRoman.boundingBoxes[109] = new Rectangle(16, 0, 759, 460);
        TimesRoman.width[175] = 333;
        TimesRoman.boundingBoxes[175] = new Rectangle(11, 547, 311, 54);
        TimesRoman.width[181] = 500;
        TimesRoman.boundingBoxes[181] = new Rectangle(36, -218, 476, 668);
        TimesRoman.width[215] = 564;
        TimesRoman.boundingBoxes[215] = new Rectangle(38, 8, 489, 489);
        TimesRoman.width[110] = 500;
        TimesRoman.boundingBoxes[110] = new Rectangle(16, 0, 469, 460);
        TimesRoman.width[57] = 500;
        TimesRoman.boundingBoxes[57] = new Rectangle(30, -22, 429, 698);
        TimesRoman.width[241] = 500;
        TimesRoman.boundingBoxes[241] = new Rectangle(16, 0, 469, 638);
        TimesRoman.width[35] = 500;
        TimesRoman.boundingBoxes[35] = new Rectangle(5, 0, 491, 662);
        TimesRoman.width[111] = 500;
        TimesRoman.boundingBoxes[111] = new Rectangle(29, -10, 441, 470);
        TimesRoman.width[243] = 500;
        TimesRoman.boundingBoxes[243] = new Rectangle(29, -10, 441, 688);
        TimesRoman.width[244] = 500;
        TimesRoman.boundingBoxes[244] = new Rectangle(29, -10, 441, 684);
        TimesRoman.width[246] = 500;
        TimesRoman.boundingBoxes[246] = new Rectangle(29, -10, 441, 633);
        TimesRoman.width[156] = 722;
        TimesRoman.boundingBoxes[156] = new Rectangle(30, -10, 660, 470);
        TimesRoman.width[242] = 500;
        TimesRoman.boundingBoxes[242] = new Rectangle(29, -10, 441, 688);
        TimesRoman.width[49] = 500;
        TimesRoman.boundingBoxes[49] = new Rectangle(111, 0, 283, 676);
        TimesRoman.width[189] = 750;
        TimesRoman.boundingBoxes[189] = new Rectangle(31, -14, 715, 690);
        TimesRoman.width[188] = 750;
        TimesRoman.boundingBoxes[188] = new Rectangle(37, -14, 681, 690);
        TimesRoman.width[185] = 300;
        TimesRoman.boundingBoxes[185] = new Rectangle(57, 270, 191, 406);
        TimesRoman.width[170] = 276;
        TimesRoman.boundingBoxes[170] = new Rectangle(4, 394, 266, 282);
        TimesRoman.width[186] = 310;
        TimesRoman.boundingBoxes[186] = new Rectangle(6, 394, 298, 282);
        TimesRoman.width[248] = 500;
        TimesRoman.boundingBoxes[248] = new Rectangle(29, -112, 441, 663);
        TimesRoman.width[245] = 500;
        TimesRoman.boundingBoxes[245] = new Rectangle(29, -10, 441, 648);
        TimesRoman.width[112] = 500;
        TimesRoman.boundingBoxes[112] = new Rectangle(5, -217, 465, 677);
        TimesRoman.width[182] = 453;
        TimesRoman.boundingBoxes[182] = new Rectangle(-22, -154, 472, 816);
        TimesRoman.width[40] = 333;
        TimesRoman.boundingBoxes[40] = new Rectangle(48, -177, 256, 853);
        TimesRoman.width[41] = 333;
        TimesRoman.boundingBoxes[41] = new Rectangle(29, -177, 256, 853);
        TimesRoman.width[37] = 833;
        TimesRoman.boundingBoxes[37] = new Rectangle(61, -13, 711, 689);
        TimesRoman.width[46] = 250;
        TimesRoman.boundingBoxes[46] = new Rectangle(70, -11, 111, 111);
        TimesRoman.width[183] = 250;
        TimesRoman.boundingBoxes[183] = new Rectangle(70, 199, 111, 111);
        TimesRoman.width[137] = 1000;
        TimesRoman.boundingBoxes[137] = new Rectangle(7, -19, 987, 725);
        TimesRoman.width[43] = 564;
        TimesRoman.boundingBoxes[43] = new Rectangle(30, 0, 504, 506);
        TimesRoman.width[177] = 564;
        TimesRoman.boundingBoxes[177] = new Rectangle(30, 0, 504, 506);
        TimesRoman.width[113] = 500;
        TimesRoman.boundingBoxes[113] = new Rectangle(24, -217, 464, 677);
        TimesRoman.width[63] = 444;
        TimesRoman.boundingBoxes[63] = new Rectangle(68, -8, 346, 684);
        TimesRoman.width[191] = 444;
        TimesRoman.boundingBoxes[191] = new Rectangle(30, -218, 346, 684);
        TimesRoman.width[34] = 408;
        TimesRoman.boundingBoxes[34] = new Rectangle(77, 431, 254, 245);
        TimesRoman.width[132] = 444;
        TimesRoman.boundingBoxes[132] = new Rectangle(45, -141, 371, 243);
        TimesRoman.width[147] = 444;
        TimesRoman.boundingBoxes[147] = new Rectangle(43, 433, 371, 243);
        TimesRoman.width[148] = 444;
        TimesRoman.boundingBoxes[148] = new Rectangle(30, 433, 371, 243);
        TimesRoman.width[145] = 333;
        TimesRoman.boundingBoxes[145] = new Rectangle(115, 433, 139, 243);
        TimesRoman.width[146] = 333;
        TimesRoman.boundingBoxes[146] = new Rectangle(79, 433, 139, 243);
        TimesRoman.width[130] = 333;
        TimesRoman.boundingBoxes[130] = new Rectangle(79, -141, 139, 243);
        TimesRoman.width[39] = 180;
        TimesRoman.boundingBoxes[39] = new Rectangle(48, 431, 85, 245);
        TimesRoman.width[114] = 333;
        TimesRoman.boundingBoxes[114] = new Rectangle(5, 0, 330, 460);
        TimesRoman.width[174] = 760;
        TimesRoman.boundingBoxes[174] = new Rectangle(38, -14, 684, 690);
        TimesRoman.width[115] = 389;
        TimesRoman.boundingBoxes[115] = new Rectangle(51, -10, 297, 470);
        TimesRoman.width[154] = 389;
        TimesRoman.boundingBoxes[154] = new Rectangle(39, -10, 311, 684);
        TimesRoman.width[167] = 500;
        TimesRoman.boundingBoxes[167] = new Rectangle(70, -148, 356, 824);
        TimesRoman.width[59] = 278;
        TimesRoman.boundingBoxes[59] = new Rectangle(80, -141, 139, 600);
        TimesRoman.width[55] = 500;
        TimesRoman.boundingBoxes[55] = new Rectangle(20, -8, 429, 670);
        TimesRoman.width[54] = 500;
        TimesRoman.boundingBoxes[54] = new Rectangle(34, -14, 434, 698);
        TimesRoman.width[47] = 278;
        TimesRoman.boundingBoxes[47] = new Rectangle(-9, -14, 296, 690);
        TimesRoman.width[32] = 250;
        TimesRoman.boundingBoxes[32] = new Rectangle(0, 0, 0, 0);
        TimesRoman.width[163] = 500;
        TimesRoman.boundingBoxes[163] = new Rectangle(12, -8, 478, 684);
        TimesRoman.width[116] = 278;
        TimesRoman.boundingBoxes[116] = new Rectangle(13, -10, 266, 589);
        TimesRoman.width[254] = 500;
        TimesRoman.boundingBoxes[254] = new Rectangle(5, -217, 465, 900);
        TimesRoman.width[51] = 500;
        TimesRoman.boundingBoxes[51] = new Rectangle(43, -14, 388, 690);
        TimesRoman.width[190] = 750;
        TimesRoman.boundingBoxes[190] = new Rectangle(15, -14, 703, 690);
        TimesRoman.width[179] = 300;
        TimesRoman.boundingBoxes[179] = new Rectangle(15, 262, 276, 414);
        TimesRoman.width[152] = 333;
        TimesRoman.boundingBoxes[152] = new Rectangle(1, 532, 330, 106);
        TimesRoman.width[153] = 980;
        TimesRoman.boundingBoxes[153] = new Rectangle(30, 256, 927, 406);
        TimesRoman.width[50] = 500;
        TimesRoman.boundingBoxes[50] = new Rectangle(30, 0, 445, 676);
        TimesRoman.width[178] = 300;
        TimesRoman.boundingBoxes[178] = new Rectangle(1, 270, 295, 406);
        TimesRoman.width[117] = 500;
        TimesRoman.boundingBoxes[117] = new Rectangle(9, -10, 470, 460);
        TimesRoman.width[250] = 500;
        TimesRoman.boundingBoxes[250] = new Rectangle(9, -10, 470, 688);
        TimesRoman.width[251] = 500;
        TimesRoman.boundingBoxes[251] = new Rectangle(9, -10, 470, 684);
        TimesRoman.width[252] = 500;
        TimesRoman.boundingBoxes[252] = new Rectangle(9, -10, 470, 633);
        TimesRoman.width[249] = 500;
        TimesRoman.boundingBoxes[249] = new Rectangle(9, -10, 470, 688);
        TimesRoman.width[95] = 500;
        TimesRoman.boundingBoxes[95] = new Rectangle(0, -125, 500, 50);
        TimesRoman.width[118] = 500;
        TimesRoman.boundingBoxes[118] = new Rectangle(19, -14, 458, 464);
        TimesRoman.width[119] = 722;
        TimesRoman.boundingBoxes[119] = new Rectangle(21, -14, 673, 464);
        TimesRoman.width[120] = 500;
        TimesRoman.boundingBoxes[120] = new Rectangle(17, 0, 462, 450);
        TimesRoman.width[121] = 500;
        TimesRoman.boundingBoxes[121] = new Rectangle(14, -218, 461, 668);
        TimesRoman.width[253] = 500;
        TimesRoman.boundingBoxes[253] = new Rectangle(14, -218, 461, 896);
        TimesRoman.width[255] = 500;
        TimesRoman.boundingBoxes[255] = new Rectangle(14, -218, 461, 841);
        TimesRoman.width[165] = 500;
        TimesRoman.boundingBoxes[165] = new Rectangle(-53, 0, 565, 662);
        TimesRoman.width[122] = 444;
        TimesRoman.boundingBoxes[122] = new Rectangle(27, 0, 391, 450);
        TimesRoman.width[158] = 444;
        TimesRoman.boundingBoxes[158] = new Rectangle(27, 0, 391, 674);
        TimesRoman.width[48] = 500;
        TimesRoman.boundingBoxes[48] = new Rectangle(24, -14, 452, 690);
        familyNames = new HashSet();
        familyNames.add("Times");
        kerning = new HashMap();
        Integer first = 79;
        Map<Integer, Integer> pairs = (HashMap<Integer, Integer>)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap<Integer, Integer>();
            kerning.put(first, pairs);
        }
        Integer second = 65;
        pairs.put(second, -35);
        second = 87;
        pairs.put(second, -35);
        second = 89;
        pairs.put(second, -50);
        second = 84;
        pairs.put(second, -40);
        second = 46;
        pairs.put(second, 0);
        second = 86;
        pairs.put(second, -50);
        second = 88;
        pairs.put(second, -40);
        second = 44;
        pairs.put(second, 0);
        first = 107;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -10);
        second = 121;
        pairs.put(second, -15);
        second = 101;
        pairs.put(second, -10);
        first = 112;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 121;
        pairs.put(second, -10);
        first = 80;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, -15);
        second = 65;
        pairs.put(second, -92);
        second = 46;
        pairs.put(second, -111);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -111);
        first = 86;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -129);
        second = 79;
        pairs.put(second, -40);
        second = 58;
        pairs.put(second, -74);
        second = 71;
        pairs.put(second, -15);
        second = 44;
        pairs.put(second, -129);
        second = 59;
        pairs.put(second, -74);
        second = 45;
        pairs.put(second, -100);
        second = 105;
        pairs.put(second, -60);
        second = 65;
        pairs.put(second, -135);
        second = 97;
        pairs.put(second, -111);
        second = 117;
        pairs.put(second, -75);
        second = 46;
        pairs.put(second, -129);
        second = 101;
        pairs.put(second, -111);
        first = 118;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -20);
        second = 97;
        pairs.put(second, -25);
        second = 46;
        pairs.put(second, -65);
        second = 101;
        pairs.put(second, -15);
        second = 44;
        pairs.put(second, -65);
        first = 32;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -55);
        second = 87;
        pairs.put(second, -30);
        second = 147;
        pairs.put(second, 0);
        second = 89;
        pairs.put(second, -90);
        second = 84;
        pairs.put(second, -18);
        second = 145;
        pairs.put(second, 0);
        second = 86;
        pairs.put(second, -50);
        first = 97;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -15);
        second = 116;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 112;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, 0);
        second = 98;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, -20);
        first = 70;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -15);
        second = 105;
        pairs.put(second, 0);
        second = 114;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, -15);
        second = 65;
        pairs.put(second, -74);
        second = 46;
        pairs.put(second, -80);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -80);
        first = 85;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -40);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 100;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 100;
        pairs.put(second, 0);
        second = 119;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 83;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 122;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        first = 68;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -40);
        second = 87;
        pairs.put(second, -30);
        second = 89;
        pairs.put(second, -55);
        second = 46;
        pairs.put(second, 0);
        second = 86;
        pairs.put(second, -40);
        second = 44;
        pairs.put(second, 0);
        first = 146;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, 0);
        second = 100;
        pairs.put(second, -50);
        second = 32;
        pairs.put(second, -74);
        second = 146;
        pairs.put(second, -74);
        second = 114;
        pairs.put(second, -50);
        second = 116;
        pairs.put(second, -18);
        second = 108;
        pairs.put(second, -10);
        second = 115;
        pairs.put(second, -55);
        second = 118;
        pairs.put(second, -50);
        first = 58;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 32;
        pairs.put(second, 0);
        first = 119;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -10);
        second = 97;
        pairs.put(second, -10);
        second = 104;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -65);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -65);
        first = 75;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -35);
        second = 79;
        pairs.put(second, -30);
        second = 117;
        pairs.put(second, -15);
        second = 121;
        pairs.put(second, -25);
        second = 101;
        pairs.put(second, -25);
        first = 82;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 79;
        pairs.put(second, -40);
        second = 87;
        pairs.put(second, -55);
        second = 85;
        pairs.put(second, -40);
        second = 89;
        pairs.put(second, -65);
        second = 84;
        pairs.put(second, -60);
        second = 86;
        pairs.put(second, -80);
        first = 145;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -80);
        second = 145;
        pairs.put(second, -74);
        first = 103;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 105;
        pairs.put(second, 0);
        second = 114;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, -5);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 66;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -35);
        second = 85;
        pairs.put(second, -10);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 98;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, -20);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -40);
        second = 108;
        pairs.put(second, 0);
        second = 98;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, -15);
        second = 44;
        pairs.put(second, 0);
        first = 81;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 85;
        pairs.put(second, -10);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 44;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, -70);
        second = 32;
        pairs.put(second, 0);
        second = 146;
        pairs.put(second, -70);
        first = 102;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, 0);
        second = 111;
        pairs.put(second, 0);
        second = 105;
        pairs.put(second, -20);
        second = 146;
        pairs.put(second, 55);
        second = 97;
        pairs.put(second, -10);
        second = 102;
        pairs.put(second, -25);
        second = 46;
        pairs.put(second, 0);
        second = 108;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 84;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -80);
        second = 79;
        pairs.put(second, -18);
        second = 119;
        pairs.put(second, -80);
        second = 58;
        pairs.put(second, -50);
        second = 114;
        pairs.put(second, -35);
        second = 104;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -74);
        second = 59;
        pairs.put(second, -55);
        second = 45;
        pairs.put(second, -92);
        second = 105;
        pairs.put(second, -35);
        second = 65;
        pairs.put(second, -93);
        second = 97;
        pairs.put(second, -80);
        second = 117;
        pairs.put(second, -45);
        second = 121;
        pairs.put(second, -80);
        second = 46;
        pairs.put(second, -74);
        second = 101;
        pairs.put(second, -70);
        first = 121;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -65);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -65);
        first = 120;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 101;
        pairs.put(second, -15);
        first = 101;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -25);
        second = 121;
        pairs.put(second, -15);
        second = 112;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, -15);
        second = 98;
        pairs.put(second, 0);
        second = 120;
        pairs.put(second, -15);
        second = 118;
        pairs.put(second, -25);
        second = 44;
        pairs.put(second, 0);
        first = 99;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 107;
        pairs.put(second, 0);
        second = 104;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, -15);
        second = 46;
        pairs.put(second, 0);
        second = 108;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 87;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -80);
        second = 79;
        pairs.put(second, -10);
        second = 58;
        pairs.put(second, -37);
        second = 104;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -92);
        second = 59;
        pairs.put(second, -37);
        second = 45;
        pairs.put(second, -65);
        second = 105;
        pairs.put(second, -40);
        second = 65;
        pairs.put(second, -120);
        second = 97;
        pairs.put(second, -80);
        second = 117;
        pairs.put(second, -50);
        second = 121;
        pairs.put(second, -73);
        second = 46;
        pairs.put(second, -92);
        second = 101;
        pairs.put(second, -80);
        first = 104;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 121;
        pairs.put(second, -5);
        first = 71;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 105;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 118;
        pairs.put(second, -25);
        first = 65;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 79;
        pairs.put(second, -55);
        second = 146;
        pairs.put(second, -111);
        second = 119;
        pairs.put(second, -92);
        second = 87;
        pairs.put(second, -90);
        second = 67;
        pairs.put(second, -40);
        second = 112;
        pairs.put(second, 0);
        second = 81;
        pairs.put(second, -55);
        second = 71;
        pairs.put(second, -40);
        second = 86;
        pairs.put(second, -135);
        second = 118;
        pairs.put(second, -74);
        second = 148;
        pairs.put(second, 0);
        second = 85;
        pairs.put(second, -55);
        second = 117;
        pairs.put(second, 0);
        second = 89;
        pairs.put(second, -105);
        second = 121;
        pairs.put(second, -92);
        second = 84;
        pairs.put(second, -111);
        first = 147;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -80);
        second = 145;
        pairs.put(second, 0);
        first = 78;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 65;
        pairs.put(second, -35);
        second = 46;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 115;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, 0);
        first = 111;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -25);
        second = 121;
        pairs.put(second, -10);
        second = 103;
        pairs.put(second, 0);
        second = 120;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, -15);
        first = 114;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 100;
        pairs.put(second, 0);
        second = 107;
        pairs.put(second, 0);
        second = 114;
        pairs.put(second, 0);
        second = 99;
        pairs.put(second, 0);
        second = 112;
        pairs.put(second, 0);
        second = 103;
        pairs.put(second, -18);
        second = 108;
        pairs.put(second, 0);
        second = 113;
        pairs.put(second, 0);
        second = 118;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, -40);
        second = 45;
        pairs.put(second, -20);
        second = 105;
        pairs.put(second, 0);
        second = 109;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, 0);
        second = 117;
        pairs.put(second, 0);
        second = 116;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, -55);
        second = 110;
        pairs.put(second, 0);
        second = 115;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        first = 108;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 119;
        pairs.put(second, -10);
        second = 121;
        pairs.put(second, 0);
        first = 76;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, 0);
        second = 146;
        pairs.put(second, -92);
        second = 87;
        pairs.put(second, -74);
        second = 89;
        pairs.put(second, -100);
        second = 121;
        pairs.put(second, -55);
        second = 84;
        pairs.put(second, -92);
        second = 86;
        pairs.put(second, -100);
        first = 148;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 32;
        pairs.put(second, 0);
        first = 109;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, 0);
        first = 89;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, -110);
        second = 45;
        pairs.put(second, -111);
        second = 105;
        pairs.put(second, -55);
        second = 79;
        pairs.put(second, -30);
        second = 58;
        pairs.put(second, -92);
        second = 97;
        pairs.put(second, -100);
        second = 65;
        pairs.put(second, -120);
        second = 117;
        pairs.put(second, -111);
        second = 46;
        pairs.put(second, -129);
        second = 101;
        pairs.put(second, -100);
        second = 59;
        pairs.put(second, -92);
        second = 44;
        pairs.put(second, -129);
        first = 74;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 111;
        pairs.put(second, 0);
        second = 97;
        pairs.put(second, 0);
        second = 65;
        pairs.put(second, -60);
        second = 117;
        pairs.put(second, 0);
        second = 46;
        pairs.put(second, 0);
        second = 101;
        pairs.put(second, 0);
        second = 44;
        pairs.put(second, 0);
        first = 46;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 148;
        pairs.put(second, -70);
        second = 146;
        pairs.put(second, -70);
        first = 110;
        pairs = (Map)kerning.get(first);
        if (pairs == null) {
            pairs = new HashMap();
            kerning.put(first, pairs);
        }
        second = 117;
        pairs.put(second, 0);
        second = 121;
        pairs.put(second, -15);
        second = 118;
        pairs.put(second, -40);
    }
}

