/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.table;

import jakarta.xml.bind.JAXBElement;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.finders.TcFinder;
import org.docx4j.model.table.TableModelCell;
import org.docx4j.model.table.TableModelRow;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTTrPrBase;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblGrid;
import org.docx4j.wml.TblGridCol;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModel {
    private static final Logger log = LoggerFactory.getLogger(TableModel.class);
    private static final int DEFAULT_PAGE_WIDTH_TWIPS = 12240;
    protected List<TableModelRow> rows;
    protected int headerMaxRow;
    protected int row;
    protected int col;
    protected int width = -1;
    protected boolean drawTableBorder = true;
    protected String styleId;
    protected Style effectiveTableStyle;
    protected TblPr tblPr;
    protected TblGrid tblGrid;
    private boolean borderConflictResolutionRequired = true;
    protected Tbl tbl;

    public TableModel() {
        this.resetIndexes();
        this.rows = new ArrayList<TableModelRow>();
        this.headerMaxRow = -1;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public Style getEffectiveTableStyle() {
        return this.effectiveTableStyle;
    }

    public TblPr getTblPr() {
        return this.tblPr;
    }

    public TblGrid getTblGrid() {
        return this.tblGrid;
    }

    public boolean isBorderConflictResolutionRequired() {
        return this.borderConflictResolutionRequired;
    }

    public boolean isDrawTableBorders() {
        return this.drawTableBorder;
    }

    public int getTableWidth() {
        return this.width;
    }

    public void resetIndexes() {
        this.row = -1;
        this.col = -1;
    }

    public void startRow(Tr tr) {
        this.rows.add(new TableModelRow(tr));
        ++this.row;
        this.col = -1;
    }

    public void addCell(Tc tc) {
        ++this.col;
        log.debug("Add tc row " + this.row + " col " + this.col);
        this.addCell(new TableModelCell(this, this.row, this.col, tc));
        if (tc.getTcPr() != null && tc.getTcPr().getGridSpan() != null && tc.getTcPr().getGridSpan().getVal() != null) {
            int gridSpan = tc.getTcPr().getGridSpan().getVal().intValue();
            this.addDummyCell(gridSpan, false, false);
        }
        log.debug("\n\n" + this.debugStr());
    }

    protected void addDummyCell(int colSpan, boolean isBefore, boolean isAfter) {
        log.debug("gridSpan, so addDummyCell " + colSpan + " " + isBefore + " " + isAfter);
        if (colSpan > 1) {
            for (int i = 1; i < colSpan; ++i) {
                TableModelCell cell = new TableModelCell(this, this.row, ++this.col);
                cell.dummyBefore = isBefore;
                cell.dummyAfter = isAfter;
                cell.setColspan(colSpan);
                this.addCell(cell);
            }
        }
    }

    protected void addCell(TableModelCell cell) {
        log.debug("add cell, col " + this.col);
        this.rows.get(this.row).add(cell);
    }

    public TableModelCell getCell(int row, int col) {
        log.debug("getting row " + row + "  col " + col);
        return this.rows.get(row).get(col);
    }

    public String getColName(int col) {
        return "col" + String.valueOf(col + 1);
    }

    public int getColCount() {
        return this.rows.get(0).size();
    }

    public List<TableModelRow> getRows() {
        return this.rows;
    }

    public int getHeaderMaxRow() {
        return this.headerMaxRow;
    }

    public void build(Tbl tbl) {
        this.tbl = tbl;
        if (tbl.getTblPr() != null && tbl.getTblPr().getTblStyle() != null) {
            this.styleId = tbl.getTblPr().getTblStyle().getVal();
        }
        this.tblGrid = tbl.getTblGrid();
        this.tblPr = tbl.getTblPr();
        TrFinder trFinder = new TrFinder();
        new TraversalUtil(tbl, trFinder);
        int r = 0;
        for (Tr tr : trFinder.getTrList()) {
            this.startRow(tr);
            this.handleRow(tr, r);
            ++r;
            if (log.isDebugEnabled()) {
                log.debug("\n\n" + this.debugStr());
            }
            if (!this.rows.get(this.row).getRowContents().isEmpty()) continue;
            log.debug("removing empty row");
            this.rows.remove(this.row);
            --this.row;
            --r;
        }
        this.width = this.calcTableWidth();
    }

    protected void handleRow(Tr tr, int r) {
        int gridAfter = this.getGridAfter(tr);
        int gridBefore = this.getGridBefore(tr);
        boolean headerRow = this.isHeaderRow(tr);
        log.debug("Processing r " + r);
        if (this.borderConflictResolutionRequired && tr.getTblPrEx() != null && tr.getTblPrEx().getTblCellSpacing() != null) {
            this.borderConflictResolutionRequired = false;
        }
        if (headerRow && this.headerMaxRow < r) {
            this.headerMaxRow = r;
        }
        if (this.drawTableBorder) {
            this.drawTableBorder = gridBefore == 0 && gridAfter == 0;
        }
        TcFinder tcFinder = new TcFinder();
        new TraversalUtil(tr, tcFinder);
        if (gridBefore > 0) {
            this.addDummyCell(gridBefore, true, false);
        }
        int c = 0;
        for (Tc tc : tcFinder.tcList) {
            log.debug("Processing  r " + r + ", docx cell " + c);
            this.addCell(tc);
            ++c;
        }
        if (gridAfter > 0) {
            this.addDummyCell(gridAfter, false, true);
        }
    }

    protected boolean isHeaderRow(Tr tr) {
        List cnfStyleOrDivIdOrGridBefore = tr.getTrPr() != null ? tr.getTrPr().getCnfStyleOrDivIdOrGridBefore() : null;
        JAXBElement<?> element = this.getElement(cnfStyleOrDivIdOrGridBefore, "tblHeader");
        BooleanDefaultTrue boolVal = element != null ? (BooleanDefaultTrue)element.getValue() : null;
        return boolVal != null ? boolVal.isVal() : false;
    }

    protected int getGridAfter(Tr tr) {
        List cnfStyleOrDivIdOrGridBefore = tr.getTrPr() != null ? tr.getTrPr().getCnfStyleOrDivIdOrGridBefore() : null;
        JAXBElement<?> element = this.getElement(cnfStyleOrDivIdOrGridBefore, "gridAfter");
        CTTrPrBase.GridAfter gridAfter = element != null ? (CTTrPrBase.GridAfter)element.getValue() : null;
        BigInteger val = gridAfter != null ? gridAfter.getVal() : null;
        return val != null ? val.intValue() : 0;
    }

    protected int getGridBefore(Tr tr) {
        List cnfStyleOrDivIdOrGridBefore = tr.getTrPr() != null ? tr.getTrPr().getCnfStyleOrDivIdOrGridBefore() : null;
        JAXBElement<?> element = this.getElement(cnfStyleOrDivIdOrGridBefore, "gridBefore");
        CTTrPrBase.GridBefore gridBefore = element != null ? (CTTrPrBase.GridBefore)element.getValue() : null;
        BigInteger val = gridBefore != null ? gridBefore.getVal() : null;
        return val != null ? val.intValue() : 0;
    }

    protected JAXBElement<?> getElement(List<JAXBElement<?>> cnfStyleOrDivIdOrGridBefore, String localName) {
        JAXBElement<?> element = null;
        if (cnfStyleOrDivIdOrGridBefore != null && !cnfStyleOrDivIdOrGridBefore.isEmpty()) {
            for (int i = 0; i < cnfStyleOrDivIdOrGridBefore.size(); ++i) {
                element = cnfStyleOrDivIdOrGridBefore.get(i);
                if (!localName.equals(element.getName().getLocalPart())) continue;
                return element;
            }
        }
        return null;
    }

    protected int calcTableWidth() {
        List gridCols;
        int ret = -1;
        List list = gridCols = this.getTblGrid() != null ? this.getTblGrid().getGridCol() : null;
        if (gridCols != null && !gridCols.isEmpty()) {
            ret = 0;
            for (int i = 0; i < gridCols.size(); ++i) {
                if (((TblGridCol)gridCols.get(i)).getW() == null) {
                    log.warn("Missing width " + XmlUtils.marshaltoString(this.getTblGrid()));
                    continue;
                }
                ret += ((TblGridCol)gridCols.get(i)).getW().intValue();
            }
        }
        return ret;
    }

    public String debugStr() {
        StringBuffer buf = new StringBuffer();
        for (TableModelRow row : this.rows) {
            List<TableModelCell> rowContents = row.getRowContents();
            for (TableModelCell c : rowContents) {
                if (c == null) {
                    buf.append("null     ");
                    continue;
                }
                buf.append(c.debugStr());
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public void setBorderConflictResolutionRequired(boolean borderConflictResolutionRequired) {
        this.borderConflictResolutionRequired = borderConflictResolutionRequired;
    }

    public static class TrFinder
    extends TraversalUtil.CallbackImpl {
        private List<Tr> trList = new ArrayList<Tr>();

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof Tr) {
                this.getTrList().add((Tr)o);
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof Tbl);
        }

        public List<Tr> getTrList() {
            return this.trList;
        }

        public void setTrList(List<Tr> trList) {
            this.trList = trList;
        }
    }
}

