/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.PresentationML;

import jakarta.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.McIgnorableNamespaceDeclarator;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.CommentsPart;
import org.docx4j.openpackaging.parts.PresentationML.JaxbPmlPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesMasterPart;
import org.docx4j.openpackaging.parts.PresentationML.NotesSlidePart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.pptx4j.jaxb.Context;
import org.pptx4j.model.ResolvedLayout;
import org.pptx4j.pml.CommonSlideData;
import org.pptx4j.pml.Notes;
import org.pptx4j.pml.ObjectFactory;
import org.pptx4j.pml.Sld;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SlidePart
extends JaxbPmlPart<Sld> {
    protected static Logger log = LoggerFactory.getLogger(SlidePart.class);
    private ResolvedLayout resolvedLayout;
    NotesSlidePart notesSlidePart;
    SlideLayoutPart layout;
    CommentsPart comments;

    public SlidePart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public SlidePart() throws InvalidFormatException {
        super(new PartName("/ppt/slides/slide1.xml"));
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.presentationml.slide+xml"));
        this.setRelationshipType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide");
    }

    @Override
    protected void setMceIgnorable(McIgnorableNamespaceDeclarator namespacePrefixMapper) {
        namespacePrefixMapper.setMcIgnorable("v");
    }

    public static Sld createSld() throws JAXBException {
        ObjectFactory factory = Context.getpmlObjectFactory();
        Sld sld = factory.createSld();
        sld.setCSld((CommonSlideData)XmlUtils.unmarshalString("<p:cSld  xmlns:a=\"http://schemas.openxmlformats.org/drawingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:p=\"http://schemas.openxmlformats.org/presentationml/2006/main\"><p:spTree><p:nvGrpSpPr><p:cNvPr id=\"1\" name=\"\"/><p:cNvGrpSpPr/><p:nvPr/></p:nvGrpSpPr><p:grpSpPr><a:xfrm><a:off x=\"0\" y=\"0\"/><a:ext cx=\"0\" cy=\"0\"/><a:chOff x=\"0\" y=\"0\"/><a:chExt cx=\"0\" cy=\"0\"/></a:xfrm></p:grpSpPr></p:spTree></p:cSld>", Context.jcPML, CommonSlideData.class));
        return sld;
    }

    public ResolvedLayout getResolvedLayout() {
        if (this.resolvedLayout != null) {
            return this.resolvedLayout;
        }
        this.resolvedLayout = ResolvedLayout.resolveSlideLayout(this);
        return this.resolvedLayout;
    }

    public boolean setPartShortcut(Part part) {
        if (part == null) {
            return false;
        }
        return this.setPartShortcut(part, part.getRelationshipType());
    }

    @Override
    public boolean setPartShortcut(Part part, String relationshipType) {
        if (relationshipType == null) {
            log.warn("trying to set part shortcut against a null relationship type.");
            return false;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/notesSlide")) {
            this.notesSlidePart = (NotesSlidePart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/slideLayout")) {
            this.layout = (SlideLayoutPart)part;
            return true;
        }
        if (relationshipType.equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments")) {
            this.comments = (CommentsPart)part;
            return true;
        }
        return false;
    }

    public NotesSlidePart getNotesSlidePart() {
        return this.notesSlidePart;
    }

    public SlideLayoutPart getSlideLayoutPart() {
        return this.layout;
    }

    public CommentsPart getCommentsPart() {
        return this.comments;
    }

    public NotesSlidePart createNotesSlidePart(NotesMasterPart nmp) throws InvalidFormatException, JAXBException {
        if (this.notesSlidePart == null) {
            this.notesSlidePart = new NotesSlidePart();
            Notes notes = NotesSlidePart.createNotes();
            this.notesSlidePart.setJaxbElement(notes);
            this.addTargetPart((Part)this.notesSlidePart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
            this.notesSlidePart.addTargetPart(this);
        }
        if (nmp != null && this.notesSlidePart.getNotesMasterPart() == null) {
            this.notesSlidePart.addTargetPart(nmp);
        }
        return this.notesSlidePart;
    }
}

