/*
 * Decompiled with CFR 0.152.
 */
package org.docstr.gwt;

import javax.inject.Inject;
import org.docstr.gwt.AbstractBaseTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class GwtCompileTask
extends AbstractBaseTask {
    public static final String COMPILER_CLASS = "com.google.gwt.dev.Compiler";
    @Input
    @Optional
    private final Property<Boolean> closureFormattedOutput;
    @Input
    @Optional
    private final Property<Boolean> compileReport;
    @Input
    @Optional
    private final Property<Boolean> strict;
    @Input
    @Optional
    private final Property<Boolean> classMetadata;
    @Input
    @Optional
    private final Property<Boolean> draftCompile;
    @Input
    @Optional
    private final Property<Boolean> checkAssertions;
    @Input
    @Optional
    private final Property<Integer> fragmentCount;
    @Input
    @Optional
    private final Property<String> namespace;
    @Input
    @Optional
    private final Property<Integer> optimize;
    @Input
    @Optional
    private final Property<Boolean> saveSource;
    @Input
    @Optional
    private final Property<Boolean> validateOnly;
    @Input
    @Optional
    private final Property<Integer> localWorkers;
    @OutputDirectory
    @Optional
    private final DirectoryProperty saveSourceOutput;

    @Inject
    public GwtCompileTask(ObjectFactory objects) {
        super(objects);
        this.closureFormattedOutput = objects.property(Boolean.class);
        this.compileReport = objects.property(Boolean.class);
        this.strict = objects.property(Boolean.class);
        this.classMetadata = objects.property(Boolean.class);
        this.draftCompile = objects.property(Boolean.class);
        this.checkAssertions = objects.property(Boolean.class);
        this.fragmentCount = objects.property(Integer.class);
        this.namespace = objects.property(String.class);
        this.optimize = objects.property(Integer.class);
        this.saveSource = objects.property(Boolean.class);
        this.validateOnly = objects.property(Boolean.class);
        this.localWorkers = objects.property(Integer.class);
        this.saveSourceOutput = objects.directoryProperty();
        this.getMainClass().set((Object)COMPILER_CLASS);
        this.dependsOn(new Object[]{this.getProject().getTasks().withType(JavaCompile.class)});
    }

    public Property<Boolean> getClosureFormattedOutput() {
        return this.closureFormattedOutput;
    }

    public Property<Boolean> getCompileReport() {
        return this.compileReport;
    }

    public Property<Boolean> getStrict() {
        return this.strict;
    }

    public Property<Boolean> getClassMetadata() {
        return this.classMetadata;
    }

    public Property<Boolean> getDraftCompile() {
        return this.draftCompile;
    }

    public Property<Boolean> getCheckAssertions() {
        return this.checkAssertions;
    }

    public Property<Integer> getFragmentCount() {
        return this.fragmentCount;
    }

    public Property<String> getNamespace() {
        return this.namespace;
    }

    public Property<Integer> getOptimize() {
        return this.optimize;
    }

    public Property<Boolean> getSaveSource() {
        return this.saveSource;
    }

    public Property<Boolean> getValidateOnly() {
        return this.validateOnly;
    }

    public Property<Integer> getLocalWorkers() {
        return this.localWorkers;
    }

    public DirectoryProperty getSaveSourceOutput() {
        return this.saveSourceOutput;
    }

    @Override
    public void exec() {
        if (this.getClosureFormattedOutput().isPresent()) {
            if (((Boolean)this.getClosureFormattedOutput().get()).booleanValue()) {
                this.args(new Object[]{"-XclosureFormattedOutput"});
            } else {
                this.args(new Object[]{"-XnoclosureFormattedOutput"});
            }
        }
        if (this.getCompileReport().isPresent()) {
            if (((Boolean)this.getCompileReport().get()).booleanValue()) {
                this.args(new Object[]{"-compileReport"});
            } else {
                this.args(new Object[]{"-nocompileReport"});
            }
        }
        if (this.getStrict().isPresent() && ((Boolean)this.getStrict().get()).booleanValue()) {
            this.args(new Object[]{"-strict"});
        }
        if (this.getClassMetadata().isPresent()) {
            if (((Boolean)this.getClassMetadata().get()).booleanValue()) {
                this.args(new Object[]{"-XclassMetadata"});
            } else {
                this.args(new Object[]{"-XnoclassMetadata"});
            }
        }
        if (this.getDraftCompile().isPresent()) {
            if (((Boolean)this.getDraftCompile().get()).booleanValue()) {
                this.args(new Object[]{"-draftCompile"});
            } else {
                this.args(new Object[]{"-nodraftCompile"});
            }
        }
        if (this.getCheckAssertions().isPresent()) {
            if (((Boolean)this.getCheckAssertions().get()).booleanValue()) {
                this.args(new Object[]{"-checkAssertions"});
            } else {
                this.args(new Object[]{"-nocheckAssertions"});
            }
        }
        if (this.getFragmentCount().isPresent()) {
            this.args(new Object[]{"-XfragmentCount", this.getFragmentCount().get()});
        }
        if (this.getNamespace().isPresent()) {
            this.args(new Object[]{"-Xnamespace", this.getNamespace().get()});
        }
        if (this.getOptimize().isPresent()) {
            this.args(new Object[]{"-optimize", this.getOptimize().get()});
        }
        if (this.getSaveSource().isPresent()) {
            if (((Boolean)this.getSaveSource().get()).booleanValue()) {
                this.args(new Object[]{"-saveSource"});
            } else {
                this.args(new Object[]{"-nosaveSource"});
            }
        }
        if (this.getValidateOnly().isPresent()) {
            if (((Boolean)this.getValidateOnly().get()).booleanValue()) {
                this.args(new Object[]{"-validateOnly"});
            } else {
                this.args(new Object[]{"-novalidateOnly"});
            }
        }
        if (this.getLocalWorkers().isPresent()) {
            this.args(new Object[]{"-localWorkers", this.getLocalWorkers().get()});
        }
        if (this.getSaveSourceOutput().isPresent()) {
            this.args(new Object[]{"-saveSourceOutput", ((Directory)this.getSaveSourceOutput().get()).getAsFile().getPath()});
        }
        this.getProject().getLogger().lifecycle("inputs: {}", new Object[]{this.getInputs().getFiles().getFiles()});
        super.exec();
    }
}

