/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.pkce;

import java.io.IOException;
import net.iharder.Base64;
import org.dmfs.httpessentials.types.CharToken;
import org.dmfs.httpessentials.types.Token;
import org.dmfs.jems.messagedigest.MessageDigestFactory;
import org.dmfs.jems.messagedigest.elementary.Sha256;
import org.dmfs.jems.single.elementary.Digest;
import org.dmfs.oauth2.client.pkce.PkceCodeChallenge;

public final class S256CodeChallenge
implements PkceCodeChallenge {
    private final CharSequence mCodeVerifier;

    public S256CodeChallenge(CharSequence codeVerifier) {
        this.mCodeVerifier = codeVerifier;
    }

    @Override
    public Token method() {
        return new CharToken((CharSequence)"S256");
    }

    @Override
    public CharSequence challenge() {
        try {
            String result = Base64.encodeBytes((byte[])new Digest((MessageDigestFactory)new Sha256(), new CharSequence[]{this.mCodeVerifier}).value(), (int)16);
            if (result.endsWith("==")) {
                return result.substring(0, result.length() - 2);
            }
            if (result.endsWith("=")) {
                return result.substring(0, result.length() - 1);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("IOException while operating on strings");
        }
    }
}

