/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.tokens;

import java.util.NoSuchElementException;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.utils.Parameters;
import org.dmfs.optional.Optional;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.parameters.ParameterList;
import org.dmfs.rfc3986.parameters.ParameterType;
import org.dmfs.rfc3986.parameters.ValueType;
import org.dmfs.rfc3986.parameters.adapters.OptionalParameter;
import org.dmfs.rfc3986.parameters.adapters.TextParameter;
import org.dmfs.rfc3986.parameters.adapters.XwfueParameterList;
import org.dmfs.rfc3986.parameters.parametertypes.BasicParameterType;
import org.dmfs.rfc3986.parameters.valuetypes.TextValueType;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Duration;

public final class ImplicitGrantAccessToken
implements OAuth2AccessToken {
    private final Uri mRedirectUri;
    private final ParameterList mRedirectUriParameters;
    private final DateTime mIssueDate;
    private final OAuth2Scope mScope;
    private final Duration mDefaultExpiresIn;

    public ImplicitGrantAccessToken(Uri redirectUri, OAuth2Scope scope, CharSequence state, Duration defaultExpiresIn) throws ProtocolException {
        this.mRedirectUri = redirectUri;
        this.mRedirectUriParameters = new XwfueParameterList((UriEncoded)redirectUri.fragment().value());
        if (!state.toString().equals(new TextParameter(Parameters.STATE, this.mRedirectUriParameters).toString())) {
            throw new ProtocolException("State in redirect uri doesn't match the original state!");
        }
        this.mIssueDate = DateTime.now();
        this.mScope = scope;
        this.mDefaultExpiresIn = defaultExpiresIn;
    }

    @Override
    public CharSequence accessToken() throws ProtocolException {
        OptionalParameter accessToken = new OptionalParameter(Parameters.ACCESS_TOKEN, this.mRedirectUriParameters);
        if (!accessToken.isPresent()) {
            throw new ProtocolException(String.format("Missing access_token in fragment '%s'", this.mRedirectUri.fragment().value()));
        }
        return (CharSequence)accessToken.value((Object)"");
    }

    @Override
    public CharSequence tokenType() throws ProtocolException {
        OptionalParameter tokenType = new OptionalParameter(Parameters.TOKEN_TYPE, this.mRedirectUriParameters);
        if (!tokenType.isPresent()) {
            throw new ProtocolException(String.format("Missing token_type in fragment '%s'", this.mRedirectUri.fragment().value()));
        }
        return (CharSequence)tokenType.value((Object)"");
    }

    @Override
    public boolean hasRefreshToken() {
        return false;
    }

    @Override
    public CharSequence refreshToken() throws ProtocolException {
        throw new NoSuchElementException("Implicit grants do no issue refresh tokens");
    }

    @Override
    public DateTime expirationDate() throws ProtocolException {
        return this.mIssueDate.addDuration((Duration)new OptionalParameter(Parameters.EXPIRES_IN, this.mRedirectUriParameters).value((Object)this.mDefaultExpiresIn));
    }

    @Override
    public OAuth2Scope scope() throws ProtocolException {
        return (OAuth2Scope)new OptionalParameter(Parameters.SCOPE, this.mRedirectUriParameters).value((Object)this.mScope);
    }

    @Override
    public Optional<CharSequence> extraParameter(String parameterName) {
        return new OptionalParameter((ParameterType)new BasicParameterType((CharSequence)parameterName, (ValueType)TextValueType.INSTANCE), this.mRedirectUriParameters);
    }
}

