/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.scope;

import org.dmfs.iterables.Split;
import org.dmfs.iterators.CsvIterator;
import org.dmfs.oauth2.client.OAuth2Scope;

public final class StringScope
implements OAuth2Scope {
    private final String mScope;

    public StringScope(String scope) {
        this.mScope = scope;
    }

    @Override
    public boolean hasToken(String token) {
        CsvIterator tokenIterator = new CsvIterator(this.mScope, ' ');
        while (tokenIterator.hasNext()) {
            if (!((String)tokenIterator.next()).equals(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int tokenCount() {
        if (this.mScope.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (CharSequence token : new Split((CharSequence)this.mScope, ' ')) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.mScope.isEmpty();
    }

    @Override
    public String toString() {
        return this.mScope;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OAuth2Scope)) {
            return false;
        }
        OAuth2Scope other = (OAuth2Scope)obj;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        if (this.tokenCount() != other.tokenCount()) {
            return false;
        }
        CsvIterator tokens = new CsvIterator(this.mScope, ' ');
        while (tokens.hasNext()) {
            if (other.hasToken((String)tokens.next())) continue;
            return false;
        }
        return true;
    }
}

