/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client.grants;

import java.io.IOException;
import java.net.URI;
import org.dmfs.httpessentials.client.HttpRequestExecutor;
import org.dmfs.httpessentials.exceptions.ProtocolError;
import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.oauth2.client.BasicOAuth2AuthCodeAuthorization;
import org.dmfs.oauth2.client.BasicOAuth2AuthorizationRequest;
import org.dmfs.oauth2.client.OAuth2AccessToken;
import org.dmfs.oauth2.client.OAuth2Client;
import org.dmfs.oauth2.client.OAuth2InteractiveGrant;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.http.requests.AuthorizationCodeTokenRequest;
import org.dmfs.oauth2.client.pkce.S256CodeChallenge;
import org.dmfs.oauth2.client.scope.StringScope;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.encoding.Precoded;
import org.dmfs.rfc3986.encoding.XWwwFormUrlEncoded;
import org.dmfs.rfc3986.parameters.ParameterList;
import org.dmfs.rfc3986.parameters.adapters.XwfueParameterList;
import org.dmfs.rfc3986.parameters.parametersets.EmptyParameterList;

public final class AuthorizationCodeGrant
implements OAuth2InteractiveGrant {
    private final OAuth2Client mClient;
    private final OAuth2Scope mScope;
    private final CharSequence mState;
    private final CharSequence mCodeVerifier;
    private final ParameterList mCustomParameters;

    public AuthorizationCodeGrant(OAuth2Client client, OAuth2Scope scope) {
        this(client, scope, client.randomChars(), client.randomChars(), EmptyParameterList.INSTANCE);
    }

    public AuthorizationCodeGrant(OAuth2Client client, OAuth2Scope scope, ParameterList customParameters) {
        this(client, scope, client.randomChars(), client.randomChars(), customParameters);
    }

    private AuthorizationCodeGrant(OAuth2Client client, OAuth2Scope scope, CharSequence state, CharSequence codeVerifier, ParameterList customParameters) {
        this.mClient = client;
        this.mScope = scope;
        this.mState = state;
        this.mCodeVerifier = codeVerifier;
        this.mCustomParameters = customParameters;
    }

    @Override
    public URI authorizationUrl() {
        BasicOAuth2AuthorizationRequest authorizationRequest = this.mScope.isEmpty() ? new BasicOAuth2AuthorizationRequest("code", this.mState, this.mCustomParameters) : new BasicOAuth2AuthorizationRequest("code", this.mScope, this.mState, this.mCustomParameters);
        return this.mClient.authorizationUrl(authorizationRequest.withCodeChallenge(new S256CodeChallenge(this.mCodeVerifier)));
    }

    @Override
    public OAuth2InteractiveGrant withRedirect(Uri redirectUri) throws ProtocolError {
        return new AuthorizedAuthorizationCodeGrant(this.mClient, redirectUri, this.mScope, this.mState, this.mCodeVerifier);
    }

    @Override
    public OAuth2AccessToken accessToken(HttpRequestExecutor executor) throws IOException, ProtocolError, ProtocolException {
        throw new IllegalStateException("first use withRedirectUri(URI) to pass the redirect URI returned by the authorization endpoint.");
    }

    @Override
    public OAuth2InteractiveGrant.OAuth2GrantState state() {
        return new InitialAuthorizationCodeGrantState(this.mScope, this.mState, this.mCodeVerifier, (CharSequence)new XWwwFormUrlEncoded(this.mCustomParameters));
    }

    private static final class AuthorizedAuthorizationCodeGrantState
    implements OAuth2InteractiveGrant.OAuth2GrantState {
        private static final long serialVersionUID = 1L;
        private final String mScopeString;
        private final Uri mRedirectUri;
        private final String mState;
        private final String mCodeVerifier;

        public AuthorizedAuthorizationCodeGrantState(OAuth2Scope scope, Uri redirectUri, CharSequence state, CharSequence codeVerifier) {
            this.mScopeString = scope.toString();
            this.mRedirectUri = redirectUri;
            this.mState = state.toString();
            this.mCodeVerifier = codeVerifier.toString();
        }

        @Override
        public OAuth2InteractiveGrant grant(OAuth2Client client) {
            return new AuthorizedAuthorizationCodeGrant(client, this.mRedirectUri, new StringScope(this.mScopeString), this.mState, this.mCodeVerifier);
        }
    }

    private static final class InitialAuthorizationCodeGrantState
    implements OAuth2InteractiveGrant.OAuth2GrantState {
        private static final long serialVersionUID = 1L;
        private final String mScopeString;
        private final String mState;
        private final String mCodeVerifier;
        private final String mCustomQueryParams;

        public InitialAuthorizationCodeGrantState(OAuth2Scope scope, CharSequence state, CharSequence codeVerifier, CharSequence customQuery) {
            this.mScopeString = scope.toString();
            this.mState = state.toString();
            this.mCodeVerifier = codeVerifier.toString();
            this.mCustomQueryParams = customQuery.toString();
        }

        @Override
        public AuthorizationCodeGrant grant(OAuth2Client client) {
            return new AuthorizationCodeGrant(client, new StringScope(this.mScopeString), this.mState, this.mCodeVerifier, (ParameterList)new XwfueParameterList((UriEncoded)new Precoded((CharSequence)this.mCustomQueryParams)));
        }
    }

    private static final class AuthorizedAuthorizationCodeGrant
    implements OAuth2InteractiveGrant {
        private final OAuth2Client mClient;
        private final Uri mRedirectUri;
        private final OAuth2Scope mScope;
        private final CharSequence mState;
        private final CharSequence mCodeVerifier;

        private AuthorizedAuthorizationCodeGrant(OAuth2Client client, Uri redirectUri, OAuth2Scope scope, CharSequence state, CharSequence codeVerifier) {
            this.mClient = client;
            this.mRedirectUri = redirectUri;
            this.mScope = scope;
            this.mState = state;
            this.mCodeVerifier = codeVerifier;
        }

        @Override
        public OAuth2AccessToken accessToken(HttpRequestExecutor executor) throws IOException, ProtocolError, ProtocolException {
            return this.mClient.accessToken(new AuthorizationCodeTokenRequest(new BasicOAuth2AuthCodeAuthorization(this.mRedirectUri, this.mScope, this.mState), this.mClient.redirectUri(), this.mCodeVerifier), executor);
        }

        @Override
        public URI authorizationUrl() {
            throw new IllegalStateException("This grant has already been completed. You can't start it again.");
        }

        @Override
        public OAuth2InteractiveGrant withRedirect(Uri redirectUri) {
            throw new IllegalStateException("This grant has already been completed. You can't feed another redirect URI.");
        }

        @Override
        public OAuth2InteractiveGrant.OAuth2GrantState state() {
            return new AuthorizedAuthorizationCodeGrantState(this.mScope, this.mRedirectUri, this.mState, this.mCodeVerifier);
        }
    }
}

