/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.oauth2.client;

import org.dmfs.httpessentials.exceptions.ProtocolException;
import org.dmfs.oauth2.client.OAuth2AuthCodeAuthorization;
import org.dmfs.oauth2.client.OAuth2Scope;
import org.dmfs.oauth2.client.utils.Parameters;
import org.dmfs.rfc3986.Uri;
import org.dmfs.rfc3986.UriEncoded;
import org.dmfs.rfc3986.parameters.ParameterList;
import org.dmfs.rfc3986.parameters.adapters.OptionalParameter;
import org.dmfs.rfc3986.parameters.adapters.TextParameter;
import org.dmfs.rfc3986.parameters.adapters.XwfueParameterList;

public final class BasicOAuth2AuthCodeAuthorization
implements OAuth2AuthCodeAuthorization {
    private final ParameterList mQueryParameters;
    private final OAuth2Scope mScope;

    public BasicOAuth2AuthCodeAuthorization(Uri redirectUri, OAuth2Scope requestedScope, CharSequence state) throws ProtocolException {
        this.mQueryParameters = new XwfueParameterList((UriEncoded)redirectUri.query().value());
        if (!state.toString().equals(new TextParameter(Parameters.STATE, this.mQueryParameters).toString())) {
            throw new ProtocolException("State in redirect uri doesn't match the original state!");
        }
        if (!new OptionalParameter(Parameters.AUTH_CODE, this.mQueryParameters).isPresent()) {
            throw new ProtocolException(String.format("Missing auth code in fragment '%s'", redirectUri.query().value()));
        }
        this.mScope = requestedScope;
    }

    @Override
    public CharSequence code() {
        return new TextParameter(Parameters.AUTH_CODE, this.mQueryParameters);
    }

    @Override
    public OAuth2Scope scope() {
        return this.mScope;
    }
}

