/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recurrenceset;

import java.util.NoSuchElementException;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.InstanceIterator;
import org.dmfs.rfc5545.RecurrenceSet;
import org.dmfs.rfc5545.instanceiterator.PeekableInstanceIterator;

public final class Preceding
implements RecurrenceSet {
    private final DateTime mBoundary;
    private final RecurrenceSet mDelegate;

    public Preceding(DateTime boundary, RecurrenceSet delegate) {
        this.mBoundary = boundary;
        this.mDelegate = delegate;
    }

    @Override
    public InstanceIterator iterator() {
        final PeekableInstanceIterator delegate = new PeekableInstanceIterator(this.mDelegate.iterator());
        return new InstanceIterator(){

            @Override
            public void fastForward(DateTime until) {
                delegate.fastForward(until);
            }

            @Override
            public boolean hasNext() {
                return delegate.hasNext() && delegate.peek().before(Preceding.this.mBoundary);
            }

            @Override
            public DateTime next() {
                DateTime result = delegate.next();
                if (!result.before(Preceding.this.mBoundary)) {
                    throw new NoSuchElementException("No more elements");
                }
                return result;
            }
        };
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return true;
    }
}

