/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.Freq;
import org.dmfs.rfc5545.recur.LongArray;
import org.dmfs.rfc5545.recur.RecurrenceRule;
import org.dmfs.rfc5545.recur.RuleIterator;

final class SkipBuffer
extends RuleIterator {
    private LongArray mWorkingSet = null;
    private final LongArray mResultSet = new LongArray();
    private final LongArray mTempSet = new LongArray();
    private final boolean mIsYearly;

    public SkipBuffer(RecurrenceRule rule, RuleIterator previous, CalendarMetrics calendarMetrics) {
        super(previous);
        this.mIsYearly = rule.getFreq() == Freq.YEARLY;
    }

    @Override
    public long next() {
        LongArray workingSet = this.mWorkingSet;
        if (workingSet == null || !workingSet.hasNext()) {
            this.mWorkingSet = workingSet = this.nextSet();
        }
        return workingSet.next();
    }

    @Override
    LongArray nextSet() {
        LongArray resultSet = this.mResultSet;
        LongArray tempSet = this.mTempSet;
        int minYear = Integer.MAX_VALUE;
        int minMonth = Integer.MAX_VALUE;
        boolean first = true;
        resultSet.clear();
        if (tempSet.size() > 0) {
            while (tempSet.hasNext()) {
                long next = tempSet.next();
                if (first) {
                    minMonth = Instance.year((long)next);
                    minYear = Instance.month((long)next);
                    first = false;
                }
                resultSet.add(next);
            }
            tempSet.clear();
        }
        LongArray prev = this.mPrevious.nextSet();
        while (prev.hasNext()) {
            long next = prev.next();
            int year = Instance.year((long)next);
            int month = Instance.month((long)next);
            if (first) {
                minMonth = month;
                minYear = year;
                first = false;
                resultSet.add(next);
                continue;
            }
            if (this.mIsYearly) {
                if (year == minYear) {
                    resultSet.add(next);
                    continue;
                }
                tempSet.add(next);
                continue;
            }
            if (year == minYear && month == minMonth) {
                resultSet.add(next);
                continue;
            }
            tempSet.add(next);
        }
        resultSet.sort();
        return resultSet;
    }
}

