/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.rfc5545.recur;

import java.util.TimeZone;
import org.dmfs.rfc5545.DateTime;
import org.dmfs.rfc5545.Instance;
import org.dmfs.rfc5545.InstanceIterator;
import org.dmfs.rfc5545.calendarmetrics.CalendarMetrics;
import org.dmfs.rfc5545.recur.RuleIterator;
import org.eclipse.jdt.annotation.NonNull;

public final class RecurrenceRuleIterator
implements InstanceIterator {
    private final RuleIterator mRuleIterator;
    private long mNextInstance;
    private final boolean mAllDay;
    private final TimeZone mTimeZone;
    private long mNextMillis = Long.MIN_VALUE;
    private DateTime mNextDateTime = null;
    private final CalendarMetrics mCalendarMetrics;

    RecurrenceRuleIterator(RuleIterator ruleIterator, DateTime start, CalendarMetrics calendarMetrics) {
        this.mRuleIterator = ruleIterator;
        this.mAllDay = start.isAllDay();
        this.mCalendarMetrics = calendarMetrics;
        this.mTimeZone = start.isFloating() ? null : start.getTimeZone();
        this.fetchNextInstance();
    }

    private void fetchNextInstance() {
        this.mNextInstance = this.mRuleIterator.next();
        this.mNextMillis = Long.MIN_VALUE;
        this.mNextDateTime = null;
    }

    public long nextMillis() {
        if (this.mNextInstance == Long.MIN_VALUE) {
            throw new ArrayIndexOutOfBoundsException("No more instances to iterate.");
        }
        long result = this.mNextMillis;
        if (result == Long.MIN_VALUE) {
            result = this.mCalendarMetrics.toMillis(this.mNextInstance, this.mTimeZone);
        }
        this.fetchNextInstance();
        return result;
    }

    public DateTime nextDateTime() {
        if (this.mNextInstance == Long.MIN_VALUE) {
            throw new ArrayIndexOutOfBoundsException("No more instances to iterate.");
        }
        long nextInstance = this.mNextInstance;
        DateTime nextDateTime = this.mNextDateTime;
        this.fetchNextInstance();
        if (nextDateTime != null) {
            return nextDateTime;
        }
        if (this.mAllDay) {
            return new DateTime(this.mCalendarMetrics, Instance.year((long)nextInstance), Instance.month((long)nextInstance), Instance.dayOfMonth((long)nextInstance));
        }
        return new DateTime(this.mCalendarMetrics, this.mTimeZone, Instance.year((long)nextInstance), Instance.month((long)nextInstance), Instance.dayOfMonth((long)nextInstance), Instance.hour((long)nextInstance), Instance.minute((long)nextInstance), Instance.second((long)nextInstance));
    }

    @Override
    public boolean hasNext() {
        return this.mNextInstance != Long.MIN_VALUE;
    }

    @Override
    public DateTime next() {
        return this.nextDateTime();
    }

    public long peekMillis() {
        if (this.mNextInstance == Long.MIN_VALUE) {
            throw new ArrayIndexOutOfBoundsException("No more instances to iterate.");
        }
        long result = this.mNextMillis;
        if (result == Long.MIN_VALUE) {
            result = this.mNextMillis = this.mCalendarMetrics.toMillis(this.mNextInstance, this.mTimeZone);
        }
        return result;
    }

    public DateTime peekDateTime() {
        if (this.mNextInstance == Long.MIN_VALUE) {
            throw new ArrayIndexOutOfBoundsException("No more instances to iterate.");
        }
        long nextInstance = this.mNextInstance;
        if (this.mAllDay) {
            this.mNextDateTime = new DateTime(this.mCalendarMetrics, Instance.year((long)nextInstance), Instance.month((long)nextInstance), Instance.dayOfMonth((long)nextInstance));
            return this.mNextDateTime;
        }
        this.mNextDateTime = new DateTime(this.mCalendarMetrics, this.mTimeZone, Instance.year((long)nextInstance), Instance.month((long)nextInstance), Instance.dayOfMonth((long)nextInstance), Instance.hour((long)nextInstance), Instance.minute((long)nextInstance), Instance.second((long)nextInstance));
        return this.mNextDateTime;
    }

    public void skip(int skip) {
        long instance;
        if (skip == 0) {
            return;
        }
        if (skip < 0) {
            throw new IllegalArgumentException("Can not skip backbards");
        }
        RuleIterator iterator = this.mRuleIterator;
        do {
            instance = iterator.next();
        } while (--skip > 0);
        this.mNextInstance = instance;
        this.mNextMillis = Long.MIN_VALUE;
        this.mNextDateTime = null;
    }

    public void fastForward(long until) {
        long next;
        if (!this.hasNext()) {
            return;
        }
        long untilInstance = this.mCalendarMetrics.toInstance(until, this.mTimeZone);
        if (untilInstance <= (next = Instance.maskWeekday((long)this.mNextInstance))) {
            return;
        }
        RuleIterator iterator = this.mRuleIterator;
        iterator.fastForward(untilInstance);
        while (next != Long.MIN_VALUE && next < untilInstance) {
            next = iterator.next();
        }
        this.mNextInstance = next;
        this.mNextMillis = Long.MIN_VALUE;
        this.mNextDateTime = null;
    }

    @Override
    public void fastForward(@NonNull DateTime until) {
        long next;
        if (!this.hasNext()) {
            return;
        }
        DateTime untilDate = until.isAllDay() ? until.startOfDay().shiftTimeZone(this.mTimeZone) : until.shiftTimeZone(this.mTimeZone);
        long untilInstance = untilDate.getInstance();
        if (untilInstance <= (next = Instance.maskWeekday((long)this.mNextInstance))) {
            return;
        }
        RuleIterator iterator = this.mRuleIterator;
        iterator.fastForward(untilInstance);
        while (next != Long.MIN_VALUE && next < untilInstance) {
            next = iterator.next();
        }
        this.mNextInstance = next;
        this.mNextMillis = Long.MIN_VALUE;
        this.mNextDateTime = null;
    }

    public void skipAllButLast() {
        long prevInstance;
        long instance = this.mNextInstance;
        RuleIterator iterator = this.mRuleIterator;
        do {
            prevInstance = instance;
        } while ((instance = iterator.next()) != Long.MIN_VALUE);
        this.mNextInstance = prevInstance;
        this.mNextMillis = Long.MIN_VALUE;
        this.mNextDateTime = null;
    }
}

